/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidInteractive;
import cofh.core.util.helpers.DamageHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidQuartz
extends BlockFluidInteractive {
    public static final int LEVELS = 5;
    public static final Material materialFluidQuartz = new MaterialLiquid(MapColor.field_151656_f);
    private static boolean effect = true;
    private static boolean enableSourceFall = true;

    public BlockFluidQuartz(Fluid fluid) {
        super(fluid, materialFluidQuartz, "thermalfoundation", "quartz");
        this.setQuantaPerBlock(5);
        this.setTickRate(10);
        this.func_149711_c(1000.0f);
        this.func_149713_g(1);
        this.setParticleColor(1.0f, 0.7f, 0.15f);
    }

    public static void config() {
        String category = "Fluid.Quartz";
        String comment = "If TRUE, Fluid Quartz will be worse than lava.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Quartz Source blocks will gradually fall downwards.";
        enableSourceFall = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Fall", category, enableSourceFall, comment);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!effect || entity.field_70178_ae) {
            return;
        }
        if (entity.field_70181_x < -0.25 || entity.field_70181_x > 0.25) {
            entity.field_70181_x *= 0.25;
        }
        if (entity.field_70179_y < -0.25 || entity.field_70179_y > 0.25) {
            entity.field_70179_y *= 0.25;
        }
        if (entity.field_70159_w < -0.25 || entity.field_70159_w > 0.25) {
            entity.field_70159_w *= 0.25;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (entity instanceof EntityCreeper) {
            world.func_72876_a(entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 6.0f, entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            entity.func_70106_y();
        } else {
            boolean t = entity.field_70133_I;
            entity.func_70097_a((DamageSource)DamageHelper.PYROTHEUM, 2.0f);
            entity.field_70133_I = t;
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidQuartz.getLuminosity();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return effect ? 800 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        if (materialIn != this.field_149764_J) {
            return null;
        }
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return effect && face.ordinal() > EnumFacing.UP.ordinal() && world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() != this;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing face) {
        return effect;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (effect) {
            this.checkForInteraction(world, pos);
        }
        if (enableSourceFall && state.func_177230_c().func_176201_c(state) == 0) {
            BlockPos offsetPos = pos.func_177982_a(0, this.densityDir, 0);
            IBlockState offsetState = world.func_180495_p(offsetPos);
            int bMeta = offsetState.func_177230_c().func_176201_c(offsetState);
            if (offsetState.func_177230_c() == this && bMeta != 0 || offsetState.func_177230_c().isFlammable((IBlockAccess)world, offsetPos, EnumFacing.UP)) {
                world.func_180501_a(offsetPos, this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void interactWithBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c() == this) {
            return;
        }
        if (this.hasInteraction(state)) {
            IBlockState result = this.getInteraction(state);
            world.func_180501_a(pos, result, 3);
            this.triggerInteractionEffects(world, pos);
        } else if (state.func_177230_c().isFlammable((IBlockAccess)world, pos, EnumFacing.UP)) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        } else if (state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && world.func_175623_d(pos.func_177972_a(EnumFacing.UP))) {
            world.func_180501_a(pos.func_177972_a(EnumFacing.UP), Blocks.field_150480_ab.func_176223_P(), 3);
        }
    }

    protected void triggerInteractionEffects(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(16) == 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 0.5f, 2.2f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, false);
        }
    }

    public void addInteractions() {
        this.addInteraction(Blocks.field_150347_e, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150349_c, Blocks.field_150346_d);
        this.addInteraction((Block)Blocks.field_150354_m, Blocks.field_150359_w);
        this.addInteraction((Block)Blocks.field_150355_j, Blocks.field_150348_b);
        this.addInteraction((Block)Blocks.field_150358_i, Blocks.field_150348_b);
        this.addInteraction(Blocks.field_150435_aG, Blocks.field_150405_ch);
        this.addInteraction(Blocks.field_150432_aD, Blocks.field_150348_b);
        this.addInteraction(Blocks.field_150433_aE, Blocks.field_150350_a);
        this.addInteraction(Blocks.field_150431_aC, Blocks.field_150350_a);
        for (int i = 0; i < 8; ++i) {
            this.addInteraction(Blocks.field_150446_ar.func_176203_a(i), Blocks.field_150390_bg.func_176203_a(i), false);
        }
    }

    public boolean preInit() {
        this.setRegistryName("fluid_quartz");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidQuartz.config();
        this.addInteractions();
        return true;
    }
}

