/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseItemBlock;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AEBaseItemBlockChargeable
extends AEBaseItemBlock
implements IAEItemPowerStorage {
    public AEBaseItemBlockChargeable(Block id) {
        super(id);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        NBTTagCompound tag = stack.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMaxEnergyCapacity();
        if (internalMaxPower > 0.0) {
            if (tag != null) {
                internalCurrentPower = tag.func_74769_h("internalCurrentPower");
            }
            double percent = internalCurrentPower / internalMaxPower;
            lines.add(GuiText.StoredEnergy.getLocal() + ':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
        }
    }

    @Override
    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getAEMaxPower(is);
        double required = internalMaxPower - internalCurrentPower;
        double overflow = Math.max(0.0, amount - required);
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(required, amount);
            double newPowerStored = internalCurrentPower + toAdd;
            this.setInternal(is, newPowerStored);
        }
        return overflow;
    }

    @Override
    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        return amount;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.getMaxEnergyCapacity();
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternal(is);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    private double getMaxEnergyCapacity() {
        Block blockID = Block.func_149634_a((Item)this);
        ITileDefinition energyCell = Api.INSTANCE.definitions().blocks().energyCell();
        return energyCell.maybeBlock().map(block -> {
            if (blockID == block) {
                return 200000;
            }
            return 1600000;
        }).orElse(0).intValue();
    }

    private double getInternal(ItemStack is) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        return nbt.func_74769_h("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        nbt.func_74780_a("internalCurrentPower", amt);
    }
}

