/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.creativetabs;

import com.google.common.base.Stopwatch;
import com.teamacronymcoders.base.creativetabs.CreativeTabBase;
import com.teamacronymcoders.base.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CreativeTabCarousel
extends CreativeTabBase {
    private ItemStack defaultIconStack = ItemStack.field_190927_a;
    private List<ItemStack> iconStacks = new ArrayList<ItemStack>();
    private int currentStackSize;
    private ItemStack currentIconStack;
    private Stopwatch watch = Stopwatch.createStarted();
    private Random random = new Random();

    public CreativeTabCarousel(String label) {
        super(label, null);
        this.updateIcon();
        this.setFunction(this::getCurrentIconStack);
    }

    private ItemStack getCurrentIconStack() {
        this.updateIcon();
        return this.currentIconStack;
    }

    private void updateIcon() {
        if (this.currentStackSize > 0) {
            if (this.watch.elapsed(TimeUnit.MILLISECONDS) >= 1500L) {
                this.watch.reset();
                this.watch.start();
                this.currentIconStack = this.iconStacks.get(this.random.nextInt(this.iconStacks.size()));
            }
        } else {
            if (!ItemStackUtils.isValid(this.defaultIconStack)) {
                this.defaultIconStack = new ItemStack(Items.field_151055_y);
            }
            this.currentIconStack = this.defaultIconStack;
        }
    }

    public void setIconStacks(List<ItemStack> iconStacks) {
        this.iconStacks = iconStacks;
        this.currentStackSize = this.iconStacks.size();
    }

    public void addIconStacks(List<ItemStack> iconStacks) {
        this.iconStacks.addAll(iconStacks);
        this.currentStackSize = this.iconStacks.size();
    }
}

