/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.registrysystem.pieces.gameregistry;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.blocks.IHasTileEntity;
import com.teamacronymcoders.base.registrysystem.Registry;
import com.teamacronymcoders.base.registrysystem.pieces.RegistryPiece;
import com.teamacronymcoders.base.registrysystem.pieces.RegistryPieceBase;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

@RegistryPiece
public class TileEntityRegisterRegistryPiece
extends RegistryPieceBase<IHasTileEntity> {
    private Map<String, Class<? extends TileEntity>> tileEntitiesToRegister = Maps.newHashMap();

    public TileEntityRegisterRegistryPiece() {
        super(IHasTileEntity.class);
    }

    @Override
    public boolean acceptsRegistry(Registry registry) {
        return "BLOCK".equalsIgnoreCase(registry.getName());
    }

    @Override
    public void onRegistryEvent(ResourceLocation name, IHasTileEntity entry) {
        this.tileEntitiesToRegister.put(entry.getTileName(name), entry.getTileEntityClass());
    }

    @Override
    public void afterRegistryEvent() {
        this.tileEntitiesToRegister.forEach((key, value) -> GameRegistry.registerTileEntity((Class)value, (String)key));
        this.tileEntitiesToRegister.clear();
    }
}

