/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.generation;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.biometweaker.property.PropertyField;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.common.handler.RegistryEventHandler;
import me.superckl.biometweaker.common.world.biome.BiomeTweakerBiome;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.util.LogHelper;
import me.superckl.biometweaker.util.ObfNameHelper;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeHills;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistryEntry;

@AutoRegister(classes={TweakerScriptObject.class}, name="createBiome")
public class ScriptCommandCreateBiome
extends ScriptCommand {
    public static final Map<Class<? extends Biome>, List<? extends Property<?>>> extraParameters = new IdentityHashMap();
    private final String rLoc;
    private final BiomePackage toCopy;

    public ScriptCommandCreateBiome(String rLoc) {
        this(rLoc, null);
    }

    @Override
    public void perform() throws Exception {
        if (RegistryEventHandler.registry == null) {
            throw new IllegalStateException("No biome registry avilable! Make sure you're using the biome registry script stage!");
        }
        if (this.toCopy == null) {
            BiomeTweakerBiome biome = new BiomeTweakerBiome(new Biome.BiomeProperties("BiomeTweaker Biome").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.4f));
            if (!MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.Create(this, biome))) {
                biome.setRegistryName("biometweaker", this.rLoc.toLowerCase());
                RegistryEventHandler.registry.register((IForgeRegistryEntry)biome);
                BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)biome));
            }
        } else {
            Biome biome;
            Iterator<Biome> it = this.toCopy.getIterator();
            if (!it.hasNext()) {
                throw new IllegalStateException("No biome found to copy!");
            }
            Biome toCopy = it.next();
            if (it.hasNext()) {
                LogHelper.warn("More than one biome found to copy! Only the first one will be copied.");
            }
            Constructor construct = null;
            try {
                if (extraParameters.containsKey(toCopy.func_150562_l())) {
                    List<Property<?>> props = extraParameters.get(toCopy.func_150562_l());
                    Class[] types = new Class[props.size() + 1];
                    for (int i = 0; i < props.size(); ++i) {
                        types[i] = Primitives.unwrap(props.get(i).getTypeClass());
                    }
                    types[types.length - 1] = Biome.BiomeProperties.class;
                    construct = toCopy.func_150562_l().getConstructor(types);
                } else {
                    construct = toCopy.func_150562_l().getConstructor(Biome.BiomeProperties.class);
                }
            }
            catch (Exception e) {
                try {
                    construct = toCopy.func_150562_l().getConstructor(new Class[0]);
                }
                catch (Exception types) {
                    // empty catch block
                }
            }
            if (construct == null) {
                LogHelper.warn("Unable to copy biome class " + toCopy.func_150562_l().getCanonicalName() + "! Some functionality may not be copied!");
                biome = new BiomeTweakerBiome(new Biome.BiomeProperties("BiomeTweaker Biome").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.4f));
            } else {
                switch (construct.getParameterCount()) {
                    case 0: {
                        biome = (Biome)construct.newInstance(new Object[0]);
                        break;
                    }
                    case 1: {
                        biome = (Biome)construct.newInstance(new Biome.BiomeProperties(BiomePropertyManager.NAME.get(toCopy)));
                        break;
                    }
                    default: {
                        List<Property<?>> props = extraParameters.get(toCopy.func_150562_l());
                        Object[] objs = new Object[props.size() + 1];
                        for (int i = 0; i < props.size(); ++i) {
                            objs[i] = props.get(i).get(toCopy);
                        }
                        objs[objs.length - 1] = new Biome.BiomeProperties(BiomePropertyManager.NAME.get(toCopy));
                        biome = (Biome)construct.newInstance(objs);
                    }
                }
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.Create(this, biome))) {
                return;
            }
            if (biome.getRegistryName() != null) {
                throw new IllegalStateException("It appears the biome " + biome.getRegistryName() + " is setting its registry name during construction. This biome cannot be copied! Contact the mod author.");
            }
            biome.setRegistryName("biometweaker", this.rLoc.toLowerCase());
            RegistryEventHandler.registry.register((IForgeRegistryEntry)biome);
            for (Property<?> prop : BiomePropertyManager.getAllProperties()) {
                if (!prop.isCopyable()) continue;
                prop.copy(toCopy, biome);
            }
            if (BiomeDictionary.hasAnyType((Biome)toCopy)) {
                BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])BiomeDictionary.getTypes((Biome)toCopy).toArray(new BiomeDictionary.Type[0]));
            }
            for (EnumCreatureType type : EnumCreatureType.values()) {
                List entries = biome.func_76747_a(type);
                entries.clear();
                entries.addAll(toCopy.func_76747_a(type));
            }
            BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)biome));
        }
    }

    public ScriptCommandCreateBiome(String rLoc, BiomePackage toCopy) {
        this.rLoc = rLoc;
        this.toCopy = toCopy;
    }

    static {
        extraParameters.put((Class<Biome>)BiomeForest.class, (List<Property<?>>)ImmutableList.of(new PropertyField<BiomeForest.Type>(BiomeForest.class, ObfNameHelper.Fields.BIOMEFOREST_TYPE.getName(), BiomeForest.Type.class)));
        extraParameters.put((Class<Biome>)BiomeTaiga.class, (List<Property<?>>)ImmutableList.of(new PropertyField<BiomeTaiga.Type>(BiomeTaiga.class, ObfNameHelper.Fields.BIOMETAIGA_TYPE.getName(), BiomeTaiga.Type.class)));
        extraParameters.put((Class<Biome>)BiomeHills.class, (List<Property<?>>)ImmutableList.of(new PropertyField<BiomeHills.Type>(BiomeHills.class, ObfNameHelper.Fields.BIOMEHILLS_TYPE.getName(), BiomeHills.Type.class)));
        extraParameters.put((Class<Biome>)BiomeSnow.class, (List<Property<?>>)ImmutableList.of(new PropertyField<Boolean>(BiomeSnow.class, ObfNameHelper.Fields.SUPERICY.getName(), Boolean.class)));
        extraParameters.put((Class<Biome>)BiomePlains.class, (List<Property<?>>)ImmutableList.of(new PropertyField<Boolean>(BiomePlains.class, ObfNameHelper.Fields.SUNFLOWERS.getName(), Boolean.class)));
        extraParameters.put((Class<Biome>)BiomeMesa.class, (List<Property<?>>)ImmutableList.of(new PropertyField<Boolean>(BiomeMesa.class, ObfNameHelper.Fields.BRYCEPILLARS.getName(), Boolean.class), new PropertyField<Boolean>(BiomeMesa.class, ObfNameHelper.Fields.HASFOREST.getName(), Boolean.class)));
        extraParameters.put((Class<Biome>)BiomeJungle.class, (List<Property<?>>)ImmutableList.of(new PropertyField<Boolean>(BiomeJungle.class, ObfNameHelper.Fields.ISEDGE.getName(), Boolean.class)));
    }
}

