/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.compat.waila.provider;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.item.sigil.ItemSigilDivination;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.helper.TextHelper;
import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DataProviderBloodAltar
implements IWailaDataProvider {
    public static final IWailaDataProvider INSTANCE = new DataProviderBloodAltar();

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("bloodmagic.bloodAltar")) {
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("altar")) {
            NBTTagCompound altarData = accessor.getNBTData().func_74775_l("altar");
            currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.seer.currentAltarTier", altarData.func_74762_e("tier")));
            currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.seer.currentAltarCapacity", altarData.func_74762_e("capacity")));
            currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.seer.currentEssence", altarData.func_74762_e("stored")));
            if (altarData.func_74764_b("charge")) {
                currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.seer.currentAltarProgress.percent", altarData.func_74762_e("progress") + "%"));
                currenttip.add(TextHelper.localizeEffect("tooltip.bloodmagic.sigil.seer.currentCharge", altarData.func_74762_e("charge")));
            }
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        TileAltar altar = (TileAltar)te;
        boolean hasSigil = false;
        boolean hasSeer = false;
        switch (ConfigHandler.compat.wailaAltarDisplayMode) {
            case ALWAYS: {
                hasSeer = true;
                hasSigil = true;
                break;
            }
            case SIGIL_HELD: {
                hasSeer = DataProviderBloodAltar.holdingSeerSigil((EntityPlayer)player);
                hasSigil = hasSeer || DataProviderBloodAltar.holdingDivinationSigil((EntityPlayer)player);
                break;
            }
            case SIGIL_CONTAINED: {
                hasSeer = DataProviderBloodAltar.hasStack(new ItemStack(RegistrarBloodMagicItems.SIGIL_SEER), (EntityPlayer)player);
                boolean bl = hasSigil = hasSeer || DataProviderBloodAltar.hasStack(new ItemStack(RegistrarBloodMagicItems.SIGIL_DIVINATION), (EntityPlayer)player);
            }
        }
        if (!hasSeer && !hasSigil) {
            return tag;
        }
        NBTTagCompound altarData = new NBTTagCompound();
        altarData.func_74768_a("tier", altar.getTier().toInt());
        altarData.func_74768_a("capacity", altar.getCapacity());
        altarData.func_74768_a("stored", altar.getCurrentBlood());
        if (hasSeer) {
            altarData.func_74768_a("progress", (int)((double)altar.getProgress() / (double)altar.getLiquidRequired() * 100.0 / (double)altar.func_70301_a(0).func_190916_E()));
            altarData.func_74768_a("charge", altar.getTotalCharge());
        }
        tag.func_74782_a("altar", (NBTBase)altarData);
        return tag;
    }

    public static boolean hasStack(ItemStack stack, EntityPlayer player) {
        for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
            if (inventoryStack == null || !inventoryStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean holdingSeerSigil(EntityPlayer player) {
        ItemStack amuletStack;
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (baubles != null && !(amuletStack = baubles.getStackInSlot(BaubleType.AMULET.getValidSlots()[0])).func_190926_b() && amuletStack.func_77973_b() == RegistrarBloodMagicItems.SIGIL_SEER) {
            return true;
        }
        if (player.func_184614_ca().func_77973_b() == RegistrarBloodMagicItems.SIGIL_SEER) {
            return true;
        }
        return player.func_184592_cb().func_77973_b() == RegistrarBloodMagicItems.SIGIL_SEER;
    }

    private static boolean holdingDivinationSigil(EntityPlayer player) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemSigilDivination) {
            return true;
        }
        return !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemSigilDivination;
    }
}

