/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBloodOrb
extends ItemBindableBase
implements IBloodOrb {
    public ItemBloodOrb() {
        this.func_77655_b("bloodmagic.orb");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        BloodOrb orb = this.getOrb(stack);
        if (orb == null) {
            return super.func_77667_c(stack);
        }
        return super.func_77667_c(stack) + "." + orb.getName();
    }

    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (BloodOrb orb : RegistrarBloodMagic.BLOOD_ORBS) {
            ItemStack orbStack = new ItemStack((Item)this);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("orb", orb.getRegistryName().toString());
            orbStack.func_77982_d(tag);
            list.add((Object)orbStack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BloodOrb orb = this.getOrb(stack);
        if (orb == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (world == null) {
            return super.func_77659_a(world, player, hand);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        if (!stack.func_77942_o()) {
            return super.func_77659_a(world, player, hand);
        }
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return super.func_77659_a(world, player, hand);
        }
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        SoulNetwork ownerNetwork = NetworkHelper.getSoulNetwork(binding);
        if (binding.getOwnerId().equals(player.func_146103_bH().getId())) {
            ownerNetwork.setOrbTier(orb.getTier());
        }
        ownerNetwork.add(SoulTicket.item(stack, world, (Entity)player, 200), orb.getCapacity());
        ownerNetwork.hurtPlayer(player, 200.0f);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.orb.desc", new Object[0]));
        BloodOrb orb = this.getOrb(stack);
        if (flag.func_194127_a() && orb != null) {
            tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.orb.owner", orb.getRegistryName().func_110624_b()));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Override
    @Nullable
    public BloodOrb getOrb(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        ResourceLocation id = new ResourceLocation(stack.func_77978_p().func_74779_i("orb"));
        return (BloodOrb)RegistrarBloodMagic.BLOOD_ORBS.getValue(id);
    }
}

