/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualManager;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileAltar;
import com.rwtema.extrautils2.tile.TileSuperMobSpawner;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@RitualRegister(value="well_of_suffering")
public class RitualWellOfSuffering
extends Ritual {
    public static final String ALTAR_RANGE = "altar";
    public static final String DAMAGE_RANGE = "damage";
    public static final int SACRIFICE_AMOUNT = 1000;
    public BlockPos altarOffsetPos = new BlockPos(0, 0, 0);

    public RitualWellOfSuffering() {
        super("ritualWellOfSuffering", 0, 40000, "ritual.bloodmagic.wellOfSufferingRitual");
        this.addBlockRange(ALTAR_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-5, -10, -5), 11, 21, 11));
        this.addBlockRange(DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(ALTAR_RANGE, 0, 10, 15);
        this.setMaximumVolumeAndDistanceOfRange(DAMAGE_RANGE, 0, 15, 15);
    }

    public static boolean isSpawnerNearby(World world, BlockPos center, int radius) {
        WorldServer ws;
        ChunkProviderServer provider;
        int r2 = radius * radius;
        if (world instanceof WorldServer && (provider = (ws = (WorldServer)world).func_72863_F()) instanceof ChunkProviderServer) {
            ChunkProviderServer cps = provider;
            int cx = center.func_177958_n() >> 4;
            int cz = center.func_177952_p() >> 4;
            int d = (radius >> 4) + 1;
            for (int dx = -d; dx <= d; ++dx) {
                for (int dz = -d; dz <= d; ++dz) {
                    Chunk chunk = cps.func_186026_b(cx + dx, cz + dz);
                    if (chunk == null) continue;
                    for (TileEntity te : chunk.func_177434_r().values()) {
                        if (!(te instanceof TileSuperMobSpawner) || !(te.func_174877_v().func_177951_i((Vec3i)center) <= (double)r2)) continue;
                        return true;
                    }
                }
            }
        }
        for (TileEntity te : world.field_147482_g) {
            if (!(te instanceof TileSuperMobSpawner) || !(te.func_174877_v().func_177951_i((Vec3i)center) <= (double)r2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        boolean hasSpawner = RitualWellOfSuffering.isSpawnerNearby(world, pos, 10);
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        BlockPos altarPos = pos.func_177971_a((Vec3i)this.altarOffsetPos);
        TileEntity tile = world.func_175625_s(altarPos);
        AreaDescriptor altarRange = masterRitualStone.getBlockRange(ALTAR_RANGE);
        if (!altarRange.isWithinArea(this.altarOffsetPos) || !(tile instanceof TileAltar)) {
            for (BlockPos newPos : altarRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof TileAltar)) continue;
                tile = nextTile;
                this.altarOffsetPos = newPos.func_177973_b((Vec3i)pos);
                altarRange.resetCache();
                break;
            }
        }
        if (tile instanceof TileAltar) {
            TileAltar tileAltar = (TileAltar)tile;
            AreaDescriptor damageRange = masterRitualStone.getBlockRange(DAMAGE_RANGE);
            AxisAlignedBB range = damageRange.getAABB(pos);
            List entities = world.func_72872_a(EntityLivingBase.class, range);
            for (EntityLivingBase entity : entities) {
                int lifeEssenceRatio;
                EntityEntry entityEntry = EntityRegistry.getEntry(entity.getClass());
                if (entityEntry == null || BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(entityEntry.getRegistryName()) || (lifeEssenceRatio = BloodMagicAPI.INSTANCE.getValueManager().getSacrificial().getOrDefault(false, 1000).intValue()) <= 0 || !entity.func_70089_S() || entity instanceof EntityPlayer || !entity.func_70097_a(RitualManager.RITUAL_DAMAGE, 1.0f)) continue;
                if (entity.func_70631_g_()) {
                    lifeEssenceRatio = (int)((float)lifeEssenceRatio * 0.5f);
                }
                if (!hasSpawner) {
                    tileAltar.sacrificialDaggerCall(lifeEssenceRatio, true);
                }
                if (++totalEffects < maxEffects) continue;
                break;
            }
            if (hasSpawner) {
                tileAltar.sacrificialDaggerCall(15000, true);
            }
            masterRitualStone.setLastLP(tileAltar.getFluidAmount());
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 25;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, -1, EnumRuneType.EARTH);
        this.addCornerRunes(components, -3, -1, EnumRuneType.DUSK);
        this.addOffsetRunes(components, 2, 4, -1, EnumRuneType.WATER);
        this.addOffsetRunes(components, 1, 4, 0, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 1, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualWellOfSuffering();
    }
}

