/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class ASMAdditionRegistry {
    private static final Map<String, List<FieldNode>> fieldAdditions = new HashMap<String, List<FieldNode>>();
    private static final Map<String, List<MethodNode>> methodAdditions = new HashMap<String, List<MethodNode>>();
    private static final Map<String, ASMAdditionRegistryWrapper> wrappers = new HashMap<String, ASMAdditionRegistryWrapper>();

    public boolean registerFieldAddition(String clazz, FieldNode node) {
        if (!fieldAdditions.containsKey(clazz = clazz.replace('.', '/'))) {
            fieldAdditions.put(clazz, new ArrayList());
        }
        return fieldAdditions.get(clazz).add(node);
    }

    public boolean registerMethodAddition(String clazz, MethodNode node) {
        if (!methodAdditions.containsKey(clazz = clazz.replace('.', '/'))) {
            methodAdditions.put(clazz, new ArrayList());
        }
        return methodAdditions.get(clazz).add(node);
    }

    public abstract String getWrapString();

    public static ASMAdditionRegistryWrapper getWrapper(String id) {
        if (!wrappers.containsKey(id)) {
            wrappers.put(id, new ASMAdditionRegistryWrapper(id));
        }
        return wrappers.get(id);
    }

    public static Map<String, List<FieldNode>> getFieldAdditions() {
        return new HashMap<String, List<FieldNode>>(fieldAdditions);
    }

    public static Map<String, List<MethodNode>> getMethodAdditions() {
        return new HashMap<String, List<MethodNode>>(methodAdditions);
    }

    public static class ASMAdditionRegistryWrapper
    extends ASMAdditionRegistry {
        private final String wrap;
        private final Map<String, List<FieldNode>> fieldAdditions = new HashMap<String, List<FieldNode>>();
        private final Map<String, List<MethodNode>> methodAdditions = new HashMap<String, List<MethodNode>>();

        private ASMAdditionRegistryWrapper(String wrappedName) {
            this.wrap = wrappedName;
        }

        @Override
        public boolean registerFieldAddition(String clazz, FieldNode node) {
            node.name = this.wrap + node.name;
            if (!this.fieldAdditions.containsKey(clazz = clazz.replace('.', '/'))) {
                this.fieldAdditions.put(clazz, new ArrayList());
            }
            this.fieldAdditions.get(clazz).add(node);
            return super.registerFieldAddition(clazz, node);
        }

        @Override
        public boolean registerMethodAddition(String clazz, MethodNode node) {
            node.name = this.wrap + node.name;
            if (!this.methodAdditions.containsKey(clazz = clazz.replace('.', '/'))) {
                this.methodAdditions.put(clazz, new ArrayList());
            }
            this.methodAdditions.get(clazz).add(node);
            return super.registerMethodAddition(clazz, node);
        }

        @Override
        public String getWrapString() {
            return this.wrap;
        }

        public Map<String, List<FieldNode>> getWrapperFieldAdditions() {
            return new HashMap<String, List<FieldNode>>(this.fieldAdditions);
        }

        public Map<String, List<MethodNode>> getWrapperMethodAdditions() {
            return new HashMap<String, List<MethodNode>>(this.methodAdditions);
        }
    }
}

