/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.data;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class BlockPredicate {
    public static final BlockPredicate ANY = new BlockPredicate();
    private final Block block;
    private final MinMaxBounds meta;
    private final Map<IProperty<?>, Object> properties;
    private final String oreDict;
    private final NBTPredicate tile;

    public BlockPredicate() {
        this.block = null;
        this.properties = null;
        this.oreDict = null;
        this.meta = MinMaxBounds.field_192516_a;
        this.tile = NBTPredicate.field_193479_a;
    }

    public BlockPredicate(@Nullable Block block, MinMaxBounds meta, @Nullable Map<IProperty<?>, Object> properties, @Nullable String oreDict, NBTPredicate tile) {
        this.block = block;
        this.meta = meta;
        this.properties = properties;
        this.oreDict = oreDict;
        this.tile = tile;
    }

    public boolean test(IBlockState state) {
        return this.test(state, null);
    }

    public boolean test(IBlockState state, TileEntity tile) {
        if (this.block != null && state.func_177230_c() != this.block) {
            return false;
        }
        if (this.properties != null) {
            for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
        }
        if (!this.meta.func_192514_a((float)state.func_177230_c().func_176201_c(state))) {
            return false;
        }
        if (this.oreDict != null) {
            boolean foundOreDict = false;
            Block block = state.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                ItemStack itemStack = new ItemStack(item, 1, block.func_180651_a(state));
                NonNullList ores = OreDictionary.getOres((String)this.oreDict, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack stack : ores) {
                        if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)itemStack, (boolean)false)) continue;
                        foundOreDict = true;
                        break;
                    }
                }
            }
            if (!foundOreDict) {
                return false;
            }
        }
        return this.tile == null || this.tile == NBTPredicate.field_193479_a || tile != null && this.tile.func_193477_a((NBTBase)tile.serializeNBT());
    }
}

