/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.dave.compactmachines3.command.CommandBaseExt;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.schema.BlockInformation;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.schema.SchemaRegistry;
import org.dave.compactmachines3.utility.SerializationHelper;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.StructureTools;

public class CommandSchemaSave
extends CommandBaseExt {
    public String func_71517_b() {
        return "save";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative && isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw this.getUsageException(sender);
        }
        String sane = args[0].replaceAll("[^a-zA-Z0-9\\._]+", "_") + ".json";
        if (sender.func_174793_f() != null && sender.func_174793_f() instanceof EntityLivingBase) {
            if (sender.func_130014_f_().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
                throw this.getException(sender, "not_in_machine_dimension", new Object[0]);
            }
            int id = StructureTools.getIdForPos(sender.func_174793_f().func_180425_c());
            List<BlockInformation> blockList = StructureTools.createNewSchema(id);
            if (blockList != null) {
                Schema schema = new Schema(args[0]);
                schema.setBlocks(blockList);
                schema.setSize(WorldSavedDataMachines.getInstance().machineSizes.get(id));
                BlockPos roomPos = WorldSavedDataMachines.getInstance().getMachineRoomPosition(id);
                Vec3d pos = sender.func_174791_d();
                schema.setSpawnPosition(new Vec3d(pos.field_72450_a - (double)roomPos.func_177958_n(), pos.field_72448_b - (double)roomPos.func_177956_o(), pos.field_72449_c - (double)roomPos.func_177952_p()));
                try {
                    File schemaFile = new File(ConfigurationHandler.schemaDirectory, sane);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(schemaFile));
                    String json = SerializationHelper.GSON.toJson((Object)schema);
                    writer.write(json);
                    writer.close();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.compactmachines3.schema.save.success", new Object[]{sane}));
                }
                catch (IOException e) {
                    throw this.getException(sender, "invalid_file", new Object[0]);
                }
                SchemaRegistry.instance.addSchema(schema);
            } else {
                throw this.getException(sender, "not_serializable", new Object[0]);
            }
        }
    }
}

