/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.framework.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.dave.compactmachines3.gui.framework.GUIHelper;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.MouseEnterEvent;
import org.dave.compactmachines3.gui.framework.event.MouseExitEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.dave.compactmachines3.gui.framework.widgets.Widget;

public class WidgetButton
extends Widget {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("compactmachines3", "textures/gui/tabicons.png");
    public boolean hovered = false;
    public ResourceLocation backgroundTexture = new ResourceLocation("minecraft", "textures/blocks/stone.png");
    public TextureAtlasSprite atlasSprite;
    protected String unlocalizedLabel;

    public WidgetButton(String unlocalizedLabel) {
        this.setHeight(20);
        this.setWidth(100);
        this.setId("Button[" + unlocalizedLabel + "]");
        this.unlocalizedLabel = unlocalizedLabel;
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public static void fillAreaWithIcon(TextureAtlasSprite icon, int x, int y, int width, int height) {
        int xNow;
        int yNow;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float zLevel = 0.0f;
        int iconWidth = icon.func_94211_a();
        int iconHeight = icon.func_94216_b();
        int fullCols = width / iconWidth;
        int fullRows = height / iconHeight;
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        int excessWidth = width % iconWidth;
        int excessHeight = height % iconHeight;
        float partialMaxU = minU + (maxU - minU) * ((float)excessWidth / (float)iconWidth);
        float partialMaxV = minV + (maxV - minV) * ((float)excessHeight / (float)iconHeight);
        for (int row = 0; row < fullRows; ++row) {
            yNow = y + row * iconHeight;
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                WidgetButton.drawRect(xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
            }
            if (excessWidth == 0) continue;
            xNow = x + fullCols * iconWidth;
            WidgetButton.drawRect(xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
        }
        if (excessHeight != 0) {
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                yNow = y + fullRows * iconHeight;
                WidgetButton.drawRect(xNow, yNow, iconWidth, excessHeight, zLevel, minU, minV, maxU, partialMaxV);
            }
            if (excessWidth != 0) {
                xNow = x + fullCols * iconWidth;
                yNow = y + fullRows * iconHeight;
                WidgetButton.drawRect(xNow, yNow, excessWidth, excessHeight, zLevel, minU, minV, partialMaxU, partialMaxV);
            }
        }
        t.func_78381_a();
    }

    private static void drawRect(float x, float y, float width, float height, float z, float u, float v, float maxU, float maxV) {
        BufferBuilder b = Tessellator.func_178181_a().func_178180_c();
        b.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)u, (double)maxV).func_181675_d();
        b.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        b.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)maxU, (double)v).func_181675_d();
        b.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)u, (double)v).func_181675_d();
    }

    public WidgetButton setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetButton setAtlasSprite(TextureAtlasSprite atlasSprite) {
        this.atlasSprite = atlasSprite;
        return this;
    }

    public void setUnlocalizedLabel(String unlocalizedLabel) {
        this.unlocalizedLabel = unlocalizedLabel;
    }

    @Override
    public void draw(GuiScreen screen) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.atlasSprite != null) {
            screen.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            WidgetButton.fillAreaWithIcon(this.atlasSprite, 0, 0, this.width, this.height);
        } else {
            screen.field_146297_k.func_110434_K().func_110577_a(this.backgroundTexture);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)16.0f, (float)16.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        screen.field_146297_k.func_110434_K().func_110577_a(BUTTON_TEXTURES);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        screen.func_73729_b(0, 0, texOffsetX, texOffsetY, 4, 4);
        screen.func_73729_b(this.width - 4, 0, texOffsetX + overlayWidth - 4, texOffsetY, 4, 4);
        screen.func_73729_b(0, this.height - 4, texOffsetX, texOffsetY + overlayWidth - 4, 4, 4);
        screen.func_73729_b(this.width - 4, this.height - 4, texOffsetX + overlayWidth - 4, texOffsetY + overlayWidth - 4, 4, 4);
        GUIHelper.drawStretchedTexture(4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        FontRenderer fontrenderer = screen.field_146297_k.field_71466_p;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        this.drawButtonContent(screen, fontrenderer);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        GlStateManager.func_179121_F();
    }

    protected void drawButtonContent(GuiScreen screen, FontRenderer renderer) {
        this.drawString(screen, renderer);
    }

    protected void drawString(GuiScreen screen, FontRenderer renderer) {
        int color = 0xEEEEEE;
        screen.func_73732_a(renderer, this.unlocalizedLabel, this.width / 2, (this.height - 8) / 2, color);
    }
}

