/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.gui.machine.widgets;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.gui.framework.event.MouseClickEvent;
import org.dave.compactmachines3.gui.framework.event.MouseClickMoveEvent;
import org.dave.compactmachines3.gui.framework.event.WidgetEventResult;
import org.dave.compactmachines3.gui.framework.widgets.Widget;
import org.dave.compactmachines3.gui.machine.GuiMachineData;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.utility.ChunkUtils;

public class WidgetMachinePreview
extends Widget {
    protected double rotateX = 0.0;
    protected double rotateY = 25.0;
    int glListId = -1;
    long lastClickTime = Long.MAX_VALUE;
    private int prevMouseX = -1;
    private int prevMouseY = -1;

    public WidgetMachinePreview() {
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (this.rotateX == 0.0) {
                this.rotateX = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
            }
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseClickMoveEvent.class, (event, widget) -> {
            int mouseX = event.x;
            int mouseY = event.y;
            if (event.timeSinceLastClick < this.lastClickTime) {
                this.prevMouseX = mouseX;
                this.prevMouseY = mouseY;
            }
            if (this.prevMouseX != mouseX || this.prevMouseY != mouseY) {
                int relativeX = mouseX - this.prevMouseX;
                int relativeY = mouseY - this.prevMouseY;
                this.rotateX += (double)relativeX;
                this.rotateY += (double)relativeY;
                this.prevMouseX = mouseX;
                this.prevMouseY = mouseY;
            }
            this.lastClickTime = event.timeSinceLastClick;
            return WidgetEventResult.HANDLED;
        });
    }

    private static void renderEntity(Entity entity, BlockPos roomPos) {
        GlStateManager.func_179094_E();
        double x = entity.field_70165_t - (double)roomPos.func_177958_n();
        double y = entity.field_70163_u - (double)roomPos.func_177956_o();
        double z = entity.field_70161_v - (double)roomPos.func_177952_p();
        RenderHelper.func_74519_b();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, x, y, z, entity.field_70177_z, 1.0f, false);
        }
        catch (Exception e) {
            CompactMachines3.logger.debug("Could not render entity '{}': {}", (Object)entity.getClass().getSimpleName(), (Object)e.getMessage());
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @Override
    public void draw(GuiScreen screen) {
        super.draw(screen);
        if (!GuiMachineData.canRender || GuiMachineData.roomPos == null) {
            return;
        }
        if (GuiMachineData.requiresNewDisplayList) {
            BlockPos roomPos = GuiMachineData.roomPos;
            ChunkPos chunkPos = new ChunkPos(roomPos);
            List<BlockPos> toRenderCopy = CompactMachines3.clientWorldData.worldClone.providerClient.getRenderListForChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
            if (toRenderCopy != null) {
                TileEntityRendererDispatcher.field_147556_a.func_147543_a((World)CompactMachines3.clientWorldData.worldClone);
                if (this.glListId != -1) {
                    GLAllocation.func_74523_b((int)this.glListId);
                }
                this.glListId = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)this.glListId, (int)4864);
                GlStateManager.func_179123_a();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-roomPos.func_177958_n()), (float)(-roomPos.func_177956_o()), (float)(-roomPos.func_177952_p()));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                GlStateManager.func_179118_c();
                this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRenderCopy);
                GlStateManager.func_179141_d();
                this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRenderCopy);
                this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRenderCopy);
                GlStateManager.func_179103_j((int)7424);
                this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRenderCopy);
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179099_b();
                GlStateManager.func_187415_K();
            }
        }
        if (CompactMachines3.clientWorldData.worldClone != null) {
            this.renderChunk();
        }
    }

    public void renderChunk() {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179109_b((float)(this.width / 2), (float)(this.height / 2), (float)180.0f);
        double scaleToWindow = 1.0 / (double)GuiMachineData.machineSize;
        GlStateManager.func_179139_a((double)(scaleToWindow *= 8.0), (double)scaleToWindow, (double)scaleToWindow);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)(-this.rotateY)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)(this.rotateX == 0.0 ? (float)RenderTickCounter.renderTicks * 45.0f / 128.0f : (float)this.rotateX), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-8.0f);
        float shift = (float)(GuiMachineData.machineSize - 1) * -4.0f;
        GlStateManager.func_179109_b((float)shift, (float)shift, (float)shift);
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        GlStateManager.func_179148_o((int)this.glListId);
        GlStateManager.func_179117_G();
        BlockPos roomPos = GuiMachineData.roomPos;
        if (roomPos == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(roomPos);
        List<BlockPos> toRenderCopy = CompactMachines3.clientWorldData.worldClone.providerClient.getRenderListForChunk(chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (ConfigurationHandler.MachineSettings.renderTileEntitiesInGUI) {
            this.renderTileEntities(TileEntityRendererDispatcher.field_147556_a, toRenderCopy);
        }
        if (ConfigurationHandler.MachineSettings.renderLivingEntitiesInGUI) {
            this.renderEntities();
            GlStateManager.func_179147_l();
        }
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        for (BlockPos pos : toRender) {
            IBlockState state = CompactMachines3.clientWorldData.worldClone.func_180495_p(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            try {
                state = state.func_185899_b((IBlockAccess)CompactMachines3.clientWorldData.worldClone, pos);
            }
            catch (Exception e) {
                CompactMachines3.logger.debug("Could not determine actual state of block: {}", (Object)state.func_177230_c());
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                TileEntity te = CompactMachines3.clientWorldData.worldClone.func_175625_s(pos);
                if (te != null && ChunkUtils.erroneousTiles.contains(te.getClass().getName())) {
                }
            }
            catch (Exception e) {}
            continue;
            try {
                blockrendererdispatcher.func_175018_a(state, pos, (IBlockAccess)CompactMachines3.clientWorldData.worldClone, buffer);
            }
            catch (Throwable e) {
                CompactMachines3.logger.debug("Failed rendering of block: {}", (Object)state.func_177230_c());
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private void renderEntities() {
        if (CompactMachines3.clientWorldData == null || CompactMachines3.clientWorldData.worldClone == null) {
            return;
        }
        BlockPos roomPos = GuiMachineData.roomPos;
        ChunkPos chunkPos = new ChunkPos(roomPos);
        ClassInheritanceMultiMap entities = CompactMachines3.clientWorldData.worldClone.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b).func_177429_s()[2];
        for (Entity entity : entities) {
            WidgetMachinePreview.renderEntity(entity, roomPos);
        }
    }

    private void renderTileEntities(TileEntityRendererDispatcher renderer, List<BlockPos> toRender) {
        if (toRender == null) {
            return;
        }
        BlockPos roomPos = GuiMachineData.roomPos;
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
        for (BlockPos pos : toRender) {
            TileEntity te;
            try {
                te = CompactMachines3.clientWorldData.worldClone.func_175625_s(pos);
            }
            catch (Exception e) {
                continue;
            }
            if (te == null) continue;
            te.func_145834_a((World)CompactMachines3.clientWorldData.worldClone);
            te.func_174878_a(pos);
            if (te instanceof ITickable) {
                try {
                    ((ITickable)te).func_73660_a();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            renderer.field_147553_e = Minecraft.func_71410_x().field_71446_o;
            renderer.preDrawBatch();
            try {
                renderer.func_147549_a(te, (double)(pos.func_177958_n() - roomPos.func_177958_n()), (double)(pos.func_177956_o() - roomPos.func_177956_o()), (double)(pos.func_177952_p() - roomPos.func_177952_p()), 0.0f);
            }
            catch (Exception e) {
                CompactMachines3.logger.warn("Could not render tile entity '{}': {}", (Object)te.getClass().getSimpleName(), (Object)e.getMessage());
            }
            renderer.drawBatch(0);
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
        ForgeHooksClient.setRenderLayer(null);
    }
}

