/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.render;

import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.world.ProxyWorld;

@SideOnly(value=Side.CLIENT)
public class RecipeRenderManager {
    public static RecipeRenderManager instance = new RecipeRenderManager();
    private final HashMap<MultiblockRecipe, RecipeRenderData> data = new HashMap();

    public void renderRecipe(MultiblockRecipe recipe, float partialTicks) {
        RecipeRenderData renderData;
        if (recipe == null) {
            return;
        }
        if (!this.data.containsKey(recipe)) {
            this.data.put(recipe, new RecipeRenderData(recipe));
        }
        if ((renderData = this.data.get(recipe)).requiresNewDisplayList()) {
            renderData.initializeDisplayList();
        }
        renderData.render(partialTicks);
    }

    private class RecipeRenderData {
        ProxyWorld proxyWorld = new ProxyWorld();
        IBlockAccess blockAccess;
        int glListId = -1;
        List<BlockPos> toRender;

        public RecipeRenderData(MultiblockRecipe recipe) {
            this.blockAccess = recipe.getBlockAccess(this.proxyWorld);
            this.proxyWorld.setFakeWorld(this.blockAccess);
            this.toRender = recipe.getShapeAsBlockPosList();
        }

        public boolean requiresNewDisplayList() {
            return this.glListId == -1;
        }

        public void render(float partialTicks) {
            GlStateManager.func_179148_o((int)this.glListId);
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
            TileEntityRendererDispatcher renderer = TileEntityRendererDispatcher.field_147556_a;
            renderer.field_147553_e = Minecraft.func_71410_x().field_71446_o;
            for (BlockPos pos : this.toRender) {
                TileEntity renderTe = this.proxyWorld.func_175625_s(pos);
                if (renderTe == null) continue;
                renderTe.func_145834_a((World)this.proxyWorld);
                renderTe.func_174878_a(pos);
                if (renderTe instanceof ITickable) {
                    ((ITickable)renderTe).func_73660_a();
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179123_a();
                try {
                    renderer.func_147549_a(renderTe, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f);
                }
                catch (Exception e) {
                    CompactMachines3.logger.info("Could not render tile entity '{}': {}", (Object)renderTe.getClass().getSimpleName(), (Object)e.getMessage());
                }
                GlStateManager.func_179099_b();
                GlStateManager.func_179121_F();
            }
            ForgeHooksClient.setRenderLayer(null);
        }

        public void initializeDisplayList() {
            this.glListId = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glListId, (int)4864);
            GlStateManager.func_179123_a();
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.func_179118_c();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID);
            GlStateManager.func_179141_d();
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT);
            GlStateManager.func_179103_j((int)7424);
            this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
            GlStateManager.func_187415_K();
        }

        public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer) {
            for (BlockPos pos : this.toRender) {
                IBlockState state = this.proxyWorld.func_180495_p(pos);
                if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
                try {
                    blockrendererdispatcher.func_175018_a(state, pos, this.blockAccess, buffer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ForgeHooksClient.setRenderLayer(null);
            }
        }
    }
}

