/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.render;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.misc.RenderTickCounter;
import org.dave.compactmachines3.render.RecipeRenderManager;
import org.dave.compactmachines3.tile.TileEntityCraftingHologram;
import org.dave.compactmachines3.world.ProxyWorld;

@SideOnly(value=Side.CLIENT)
public class TESRCraftingHologram
extends TileEntitySpecialRenderer<TileEntityCraftingHologram> {
    private IBlockAccess blockAccess;
    private MultiblockRecipe recipe;
    private ProxyWorld proxyWorld;
    private final int glListId = -1;

    public void render(TileEntityCraftingHologram te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.recipe = te.getRecipe();
        if (this.recipe == null) {
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179089_o();
        GlStateManager.func_179141_d();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179101_C();
        float angle = (float)RenderTickCounter.renderTicks * 45.0f / 64.0f;
        float rotateOffsetX = (float)this.recipe.getWidth() / 2.0f;
        float rotateOffsetY = 0.0f;
        float rotateOffsetZ = (float)this.recipe.getDepth() / 2.0f;
        double progress = 1.0 - (double)te.getProgress() / (double)this.recipe.getTicks();
        double scale = progress * (1.0 - (Math.sin(Math.toDegrees(RenderTickCounter.renderTicks) / 2000.0) + 1.0) * (double)0.1f);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179139_a((double)(scale *= 0.7), (double)scale, (double)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)(-this.recipe.getHeight() / 2), (float)0.0f);
        GlStateManager.func_179109_b((float)(-rotateOffsetX), (float)(-rotateOffsetY), (float)(-rotateOffsetZ));
        GlStateManager.func_179109_b((float)rotateOffsetX, (float)rotateOffsetY, (float)rotateOffsetZ);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-rotateOffsetX), (float)(-rotateOffsetY), (float)(-rotateOffsetZ));
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179084_k();
        RecipeRenderManager.instance.renderRecipe(this.recipe, partialTicks);
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, BufferBuilder buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
        for (BlockPos pos : toRender) {
            IBlockState state = this.recipe.getStateAtBlockPos(pos);
            if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
            try {
                blockrendererdispatcher.func_175018_a(state, pos, this.blockAccess, buffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ForgeHooksClient.setRenderLayer(null);
        }
    }
}

