/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.integration.AbstractNullHandler;
import org.dave.compactmachines3.integration.CapabilityNullHandler;
import org.dave.compactmachines3.world.data.provider.AbstractExtraTileDataProvider;
import org.dave.compactmachines3.world.data.provider.ExtraTileDataProvider;

public class AnnotatedInstanceUtil {
    public static ASMDataTable asmData;

    private AnnotatedInstanceUtil() {
    }

    public static List<AbstractNullHandler> getNullHandlers() {
        return AnnotatedInstanceUtil.getInstances(asmData, CapabilityNullHandler.class, AbstractNullHandler.class);
    }

    public static List<AbstractExtraTileDataProvider> getExtraTileDataProviders() {
        return AnnotatedInstanceUtil.getInstances(asmData, ExtraTileDataProvider.class, AbstractExtraTileDataProvider.class);
    }

    private static <T> List<T> getInstances(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException e) {
                CompactMachines3.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
            catch (IllegalAccessException e) {
                CompactMachines3.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
            catch (InstantiationException e) {
                CompactMachines3.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
            catch (ExceptionInInitializerError e) {
                CompactMachines3.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return instances;
    }

    public static void setAsmData(ASMDataTable asmData) {
        AnnotatedInstanceUtil.asmData = asmData;
    }
}

