/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.Launch;
import org.dave.compactmachines3.CompactMachines3;

public class ResourceLoader {
    public static final boolean DEVELOPMENT = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    private final String runtimePathName;
    private final String assetPathName;
    private final Class jarClass;

    public ResourceLoader(Class jarClass, File runtimeFile, String assetPathName) {
        this.assetPathName = assetPathName;
        this.runtimePathName = runtimeFile.getAbsolutePath();
        this.jarClass = jarClass;
    }

    public ResourceLoader(Class jarClass, String runtimePathName, String assetPathName) {
        this.runtimePathName = runtimePathName;
        this.assetPathName = assetPathName;
        this.jarClass = jarClass;
    }

    public Map<String, InputStream> getResources() {
        HashMap<String, InputStream> result;
        block12: {
            block11: {
                result = new HashMap<String, InputStream>();
                File runtimePath = new File(this.runtimePathName);
                if (runtimePath.exists() && runtimePath.isDirectory()) {
                    for (File file : runtimePath.listFiles()) {
                        try {
                            result.put(file.getName(), new FileInputStream(file));
                            CompactMachines3.logger.debug(" - Loading file '{}' from config folder", (Object)file.getName());
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (!DEVELOPMENT) break block11;
                File assetPath = new File(this.jarClass.getResource("/" + this.assetPathName).getFile());
                if (!assetPath.exists() || !assetPath.isDirectory()) break block12;
                for (File file : assetPath.listFiles()) {
                    if (result.containsKey(file.getName())) continue;
                    try {
                        result.put(file.getName(), new FileInputStream(file));
                        CompactMachines3.logger.debug(" - Loading file '{}' from development assets folder", (Object)file.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                break block12;
            }
            URL srcUrl = this.jarClass.getResource("/" + this.assetPathName);
            if (srcUrl == null || !srcUrl.getProtocol().equals("jar")) {
                CompactMachines3.logger.error("Error while reading files from jar: unable to get Resource URL for '{}'.", (Object)this.assetPathName);
                return null;
            }
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)srcUrl.openConnection();
                JarFile zipFile = jarURLConnection.getJarFile();
                Enumeration<? extends ZipEntry> zipEntries = ((ZipFile)zipFile).entries();
                while (zipEntries.hasMoreElements()) {
                    String filename;
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String zipName = zipEntry.getName();
                    if (!zipName.startsWith(this.assetPathName) || result.containsKey(filename = zipName.substring(this.assetPathName.length())) || filename.length() == 0) continue;
                    result.put(filename, ((ZipFile)zipFile).getInputStream(zipEntry));
                    CompactMachines3.logger.debug(" - Loading file '{}' from jar", (Object)filename);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

