/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class WorldSavedDataMachines
extends WorldSavedData {
    private static WorldSavedDataMachines instance;
    private static Map<Integer, BlockPos> clientMachineGrid;
    private static Map<Integer, EnumMachineSize> clientMachineSizes;
    public int nextId = 0;
    public Map<Integer, Vec3d> spawnPoints = new HashMap<Integer, Vec3d>();
    public Map<Integer, Map<EnumFacing, BlockPos>> tunnels = new HashMap<Integer, Map<EnumFacing, BlockPos>>();
    public Map<Integer, Map<EnumFacing, RedstoneTunnelData>> redstoneTunnels = new HashMap<Integer, Map<EnumFacing, RedstoneTunnelData>>();
    public Map<Integer, DimensionBlockPos> machinePositions = new HashMap<Integer, DimensionBlockPos>();
    public Map<Integer, BlockPos> machineGrid = new HashMap<Integer, BlockPos>();
    public Map<Integer, EnumMachineSize> machineSizes = new HashMap<Integer, EnumMachineSize>();
    public Map<UUID, Integer> bedLocations = new HashMap<UUID, Integer>();
    public BlockPos lastGrid = null;

    public WorldSavedDataMachines(String name) {
        super(name);
    }

    public static WorldSavedDataMachines getInstance() {
        if (instance == null) {
            WorldSavedDataMachines.loadSaveData();
        }
        return instance;
    }

    public static int getClientMachineIdFromBoxPos(BlockPos pos) {
        if (clientMachineGrid == null || clientMachineSizes == null) {
            return -1;
        }
        return WorldSavedDataMachines.getMachineIdFromBoxPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), clientMachineGrid, clientMachineSizes);
    }

    private static int getMachineIdFromBoxPos(int x, int y, int z, Map<Integer, BlockPos> machineGrid, Map<Integer, EnumMachineSize> machineSizes) {
        for (Map.Entry<Integer, BlockPos> entry : machineGrid.entrySet()) {
            int roomPosX = entry.getValue().func_177958_n();
            int roomPosZ = entry.getValue().func_177952_p();
            EnumMachineSize sizeEnum = machineSizes.get(entry.getKey());
            if (sizeEnum == null) {
                CompactMachines3.logger.error("Machine size was null with key {}", (Object)entry.getKey());
                continue;
            }
            int size = sizeEnum.getDimension();
            boolean insideRoom = roomPosX <= x && x <= roomPosX + size && roomPosZ <= z && z <= roomPosZ + size && 40 <= y && y <= 40 + size;
            if (!insideRoom) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static int reserveMachineId() {
        WorldSavedDataMachines wsd = WorldSavedDataMachines.getInstance();
        int val = wsd.nextId++;
        wsd.func_76185_a();
        return val;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void loadWorld(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        WorldSavedDataMachines.loadSaveData();
    }

    public static synchronized void loadSaveData() {
        if (instance != null) {
            return;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        instance = (WorldSavedDataMachines)machineWorld.func_175693_T().func_75742_a(WorldSavedDataMachines.class, "WorldSavedDataMachines");
        if (instance == null) {
            instance = new WorldSavedDataMachines("WorldSavedDataMachines");
            instance.func_76185_a();
        }
        CompactMachines3.logger.info("Loaded data for compact machine world: {} spawn points, next machine id is {}, players with beds: {}", (Object)WorldSavedDataMachines.instance.spawnPoints.size(), (Object)WorldSavedDataMachines.instance.nextId, (Object)WorldSavedDataMachines.instance.bedLocations.size());
        machineWorld.func_175693_T().func_75745_a("WorldSavedDataMachines", (WorldSavedData)instance);
    }

    public static Map<Integer, BlockPos> getClientMachineGrid() {
        return clientMachineGrid;
    }

    public static void setClientMachineGrid(Map<Integer, BlockPos> clientMachineGrid) {
        WorldSavedDataMachines.clientMachineGrid = clientMachineGrid;
    }

    public static Map<Integer, EnumMachineSize> getClientMachineSizes() {
        return clientMachineSizes;
    }

    public static void setClientMachineSizes(Map<Integer, EnumMachineSize> clientMachineSizes) {
        WorldSavedDataMachines.clientMachineSizes = clientMachineSizes;
    }

    public void setBedLocation(EntityPlayer player) {
        int id = this.getMachineIdFromEntityPos((Entity)player);
        this.bedLocations.put(player.func_110124_au(), id);
        this.func_76185_a();
    }

    public int getBedLocation(EntityPlayer player) {
        return this.bedLocations.getOrDefault(player.func_110124_au(), -1);
    }

    public DimensionBlockPos getMachineBlockPosition(int id) {
        return this.machinePositions.get(id);
    }

    public TileEntityMachine getMachine(int id) {
        if (!this.machinePositions.containsKey(id)) {
            return null;
        }
        DimensionBlockPos dimPos = this.getMachineBlockPosition(id);
        WorldServer world = DimensionTools.getWorldServerForDimension(dimPos.getDimension());
        TileEntity result = world.func_175625_s(dimPos.getBlockPos());
        if (!(result instanceof TileEntityMachine)) {
            return null;
        }
        return (TileEntityMachine)result;
    }

    public void setMachineRoomPosition(int id, BlockPos roomPos, boolean updateLastGrid) {
        this.machineGrid.put(id, roomPos);
        if (updateLastGrid && roomPos != null) {
            this.lastGrid = roomPos;
        }
    }

    public BlockPos getMachineRoomPosition(int id) {
        return this.machineGrid.get(id);
    }

    public int getMachineIdFromEntityPos(Entity entity) {
        return this.getMachineIdFromBoxPos(new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
    }

    public int getMachineIdFromBoxPos(BlockPos pos) {
        return this.getMachineIdFromBoxPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int getMachineIdFromBoxPos(int x, int y, int z) {
        return WorldSavedDataMachines.getMachineIdFromBoxPos(x, y, z, this.machineGrid, this.machineSizes);
    }

    public void addMachineSize(int id, EnumMachineSize size) {
        this.machineSizes.put(id, size);
        CompactMachines3.logger.debug("Adding machine size: id={}, size={}", (Object)id, (Object)size.func_176610_l());
        this.func_76185_a();
    }

    public void addMachinePosition(int id, BlockPos pos, int dimension) {
        this.machinePositions.put(id, new DimensionBlockPos(pos, dimension));
        CompactMachines3.logger.debug("Adding machine position: id={}, pos={}, dimension={}", (Object)id, (Object)pos, (Object)dimension);
        this.func_76185_a();
    }

    public void addSpawnPoint(int id, @Nonnull Vec3d destination) {
        this.spawnPoints.put(id, destination);
        CompactMachines3.logger.debug(String.format("Setting spawn point: id=%s, x=%.2f, y=%.2f, z=%.2f", id, destination.field_72450_a, destination.field_72448_b, destination.field_72449_c));
        this.func_76185_a();
    }

    public void removeMachinePosition(int id) {
        this.machinePositions.remove(id);
        CompactMachines3.logger.debug("Removing machine position by id: id={}", (Object)id);
        this.func_76185_a();
    }

    public void removeTunnel(BlockPos pos) {
        int id = this.getMachineIdFromBoxPos(pos);
        Map<EnumFacing, BlockPos> sideMapping = this.tunnels.get(id);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get(side).equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            CompactMachines3.logger.debug("Removing tunnel mapping by blockpos: pos={} --> id={}, side={}", (Object)pos, (Object)id, sideToRemove);
            sideMapping.remove(sideToRemove);
        }
        this.func_76185_a();
    }

    public void removeTunnel(BlockPos position, EnumFacing side) {
        int id = this.getMachineIdFromBoxPos(position);
        Map<EnumFacing, BlockPos> sideMapping = this.tunnels.get(id);
        if (sideMapping == null) {
            return;
        }
        CompactMachines3.logger.debug("Removing tunnel mapping by pos+side: id={}, side={}", (Object)id, (Object)side);
        sideMapping.remove(side);
        this.func_76185_a();
    }

    public void addTunnel(BlockPos position, EnumFacing side) {
        this.addTunnel(position, side, false);
    }

    private void addTunnel(BlockPos position, EnumFacing side, boolean isLoading) {
        int id = instance.getMachineIdFromBoxPos(position);
        this.addTunnel(position, side, id, isLoading);
    }

    private void addTunnel(BlockPos position, EnumFacing side, int id, boolean isLoading) {
        Map sideMapping = this.tunnels.computeIfAbsent(id, k -> new HashMap());
        sideMapping.put(side, position);
        CompactMachines3.logger.debug("Adding tunnel mapping: side={}, pos={} --> id={}", (Object)side, (Object)position, (Object)id);
        if (!isLoading) {
            this.func_76185_a();
        }
    }

    public void toggleRedstoneTunnelOutput(BlockPos pos) {
        int id = this.getMachineIdFromBoxPos(pos);
        Map<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(id);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get((Object)side).pos.equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            sideMapping.get(sideToRemove).isOutput = !sideMapping.get(sideToRemove).isOutput;
            CompactMachines3.logger.debug("Toggle tunnel output by blockpos: pos={} --> id={}, side={}, output={}", (Object)pos, (Object)id, (Object)sideToRemove, (Object)sideMapping.get((Object)sideToRemove).isOutput);
        }
        this.func_76185_a();
    }

    public void removeRedstoneTunnel(BlockPos pos) {
        int id = this.getMachineIdFromBoxPos(pos);
        Map<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(id);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get((Object)side).pos.equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            CompactMachines3.logger.debug("Removing tunnel mapping by blockpos: pos={} --> id={}, side={}", (Object)pos, (Object)id, sideToRemove);
            sideMapping.remove(sideToRemove);
        }
        this.func_76185_a();
    }

    public void removeRedstoneTunnel(BlockPos position, EnumFacing side) {
        int id = this.getMachineIdFromBoxPos(position);
        Map<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(id);
        if (sideMapping == null) {
            return;
        }
        CompactMachines3.logger.debug("Removing tunnel mapping by pos+side: id={}, side={}", (Object)id, (Object)side);
        sideMapping.remove(side);
        this.func_76185_a();
    }

    public void addRedstoneTunnel(BlockPos position, EnumFacing side, boolean isOutput) {
        this.addRedstoneTunnel(position, side, isOutput, false);
    }

    private void addRedstoneTunnel(BlockPos position, EnumFacing side, boolean isOutput, boolean isLoading) {
        int id = this.getMachineIdFromBoxPos(position);
        Map<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(id);
        if (sideMapping == null) {
            sideMapping = new HashMap<EnumFacing, RedstoneTunnelData>();
            this.redstoneTunnels.put(id, sideMapping);
        }
        sideMapping.put(side, new RedstoneTunnelData(position, isOutput));
        CompactMachines3.logger.debug("Adding redstone tunnel mapping: side={}, pos={}, isOutput={} --> id={}", (Object)side, (Object)position, (Object)isOutput, (Object)id);
        if (!isLoading) {
            this.func_76185_a();
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound tag;
        EnumFacing side;
        Map<EnumFacing, Object> sideMappings;
        compound.func_74768_a("nextMachineId", this.nextId);
        NBTTagCompound bedLocationsTag = new NBTTagCompound();
        for (UUID uUID : this.bedLocations.keySet()) {
            int id = this.bedLocations.get(uUID);
            bedLocationsTag.func_74768_a(uUID.toString(), id);
        }
        NBTTagCompound machineSizesTag = new NBTTagCompound();
        for (int id : this.machineSizes.keySet()) {
            int size = this.machineSizes.get(id).getMeta();
            machineSizesTag.func_74768_a("" + id, size);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int id2 : this.spawnPoints.keySet()) {
            Vec3d vec3d = this.spawnPoints.get(id2);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("id", id2);
            nBTTagCompound.func_74780_a("x", vec3d.field_72450_a);
            nBTTagCompound.func_74780_a("y", vec3d.field_72448_b);
            nBTTagCompound.func_74780_a("z", vec3d.field_72449_c);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound);
        }
        NBTTagList tunnelList = new NBTTagList();
        for (Map.Entry<Integer, Map<EnumFacing, BlockPos>> entry : this.tunnels.entrySet()) {
            int n = entry.getKey();
            sideMappings = entry.getValue();
            for (Map.Entry<EnumFacing, Object> sideEntry : sideMappings.entrySet()) {
                side = sideEntry.getKey();
                BlockPos position = sideEntry.getValue();
                tag = new NBTTagCompound();
                tag.func_74768_a("id", n);
                tag.func_74768_a("side", side.func_176745_a());
                tag.func_74768_a("x", position.func_177958_n());
                tag.func_74768_a("y", position.func_177956_o());
                tag.func_74768_a("z", position.func_177952_p());
                tunnelList.func_74742_a((NBTBase)tag);
            }
        }
        NBTTagList redstoneTunnelList = new NBTTagList();
        for (Map.Entry<Integer, Map<EnumFacing, RedstoneTunnelData>> entry : this.redstoneTunnels.entrySet()) {
            sideMappings = entry.getValue();
            for (Map.Entry<EnumFacing, Object> sideEntry : sideMappings.entrySet()) {
                side = sideEntry.getKey();
                RedstoneTunnelData info = (RedstoneTunnelData)sideEntry.getValue();
                tag = new NBTTagCompound();
                tag.func_74768_a("side", side.func_176745_a());
                tag.func_74768_a("x", info.pos.func_177958_n());
                tag.func_74768_a("y", info.pos.func_177956_o());
                tag.func_74768_a("z", info.pos.func_177952_p());
                tag.func_74757_a("output", info.isOutput);
                redstoneTunnelList.func_74742_a((NBTBase)tag);
            }
        }
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Map.Entry<Integer, DimensionBlockPos> entry : this.machinePositions.entrySet()) {
            int id4 = entry.getKey();
            DimensionBlockPos dimpos = entry.getValue();
            BlockPos roomPos = this.machineGrid.get(id4);
            NBTTagCompound tag3 = dimpos.getAsNBT();
            tag3.func_74768_a("id", id4);
            if (roomPos != null) {
                tag3.func_74782_a("roomPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)roomPos));
            }
            nBTTagList2.func_74742_a((NBTBase)tag3);
        }
        compound.func_74782_a("spawnpoints", (NBTBase)nBTTagList);
        compound.func_74782_a("tunnels", (NBTBase)tunnelList);
        compound.func_74782_a("machines", (NBTBase)nBTTagList2);
        compound.func_74782_a("bedLocations", (NBTBase)bedLocationsTag);
        compound.func_74782_a("sizes", (NBTBase)machineSizesTag);
        compound.func_74782_a("redstoneTunnels", (NBTBase)redstoneTunnelList);
        if (this.lastGrid != null) {
            compound.func_74782_a("lastGrid", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.lastGrid));
        }
        return compound;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList tagList;
        int id;
        this.nextId = nbt.func_74764_b("nextMachineId") ? nbt.func_74762_e("nextMachineId") : nbt.func_74762_e("nextMachineCoord");
        NBTTagCompound bedLocationsTag = null;
        if (nbt.func_74764_b("bedLocations")) {
            bedLocationsTag = nbt.func_74775_l("bedLocations");
        } else if (nbt.func_74764_b("bedcoords")) {
            bedLocationsTag = nbt.func_74775_l("bedcoords");
        }
        if (bedLocationsTag != null) {
            this.bedLocations.clear();
            for (Object uuidString : bedLocationsTag.func_150296_c()) {
                UUID uuid = UUID.fromString((String)uuidString);
                int machineId = bedLocationsTag.func_74762_e((String)uuidString);
                this.bedLocations.put(uuid, machineId);
            }
        }
        if (nbt.func_74764_b("sizes")) {
            this.machineSizes.clear();
            NBTTagCompound machineSizesTag = nbt.func_74775_l("sizes");
            for (String idString : machineSizesTag.func_150296_c()) {
                id = Integer.parseInt(idString);
                int size = machineSizesTag.func_74762_e(idString);
                this.machineSizes.put(id, EnumMachineSize.getFromMeta(size));
            }
        }
        if (nbt.func_74764_b("spawnpoints")) {
            this.spawnPoints.clear();
            tagList = nbt.func_150295_c("spawnpoints", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                id = tag.func_150297_b("id", 3) ? tag.func_74762_e("id") : tag.func_74762_e("coords");
                Vec3d position = new Vec3d(tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z"));
                this.spawnPoints.put(id, position);
            }
        }
        if (nbt.func_74764_b("machines")) {
            this.machinePositions.clear();
            this.machineGrid.clear();
            tagList = nbt.func_150295_c("machines", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos roomPos = null;
                if (tag.func_74764_b("coords")) {
                    id = tag.func_74762_e("coords");
                    roomPos = new BlockPos(id * 1024, 0, 0);
                } else {
                    id = tag.func_74762_e("id");
                    if (tag.func_74764_b("roomPos")) {
                        roomPos = NBTUtil.func_186861_c((NBTTagCompound)tag.func_74775_l("roomPos"));
                    }
                }
                this.machinePositions.put(id, new DimensionBlockPos(tag));
                if (roomPos == null) continue;
                this.machineGrid.put(id, roomPos);
            }
        }
        if (nbt.func_74764_b("redstoneTunnels")) {
            this.redstoneTunnels.clear();
            tagList = nbt.func_150295_c("redstoneTunnels", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                EnumFacing side = EnumFacing.func_82600_a((int)tag.func_74762_e("side"));
                boolean isOutput = tag.func_74767_n("output");
                this.addRedstoneTunnel(position, side, isOutput, true);
            }
        }
        if (nbt.func_74764_b("tunnels")) {
            this.tunnels.clear();
            tagList = nbt.func_150295_c("tunnels", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                int id2 = tag.func_74764_b("id") ? tag.func_74762_e("id") : this.getMachineIdFromBoxPos(position);
                EnumFacing side = EnumFacing.func_82600_a((int)tag.func_74762_e("side"));
                this.addTunnel(position, side, id2, true);
            }
        }
        if (nbt.func_74764_b("lastGrid")) {
            this.lastGrid = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("lastGrid"));
        }
    }
}

