/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.schema.BlockInformation;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class StructureTools {
    public static int getIdForPos(BlockPos pos) {
        return StructureTools.getIdForPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static int getIdForPos(int x, int y, int z) {
        return WorldSavedDataMachines.getInstance().getMachineIdFromBoxPos(x, y, z);
    }

    public static EnumFacing getNextDirection(EnumFacing in) {
        if (in == null) {
            return null;
        }
        int next = in.func_176745_a() + 1;
        if (next == EnumFacing.EAST.func_176745_a() + 1) {
            return null;
        }
        return EnumFacing.func_82600_a((int)next);
    }

    public static boolean setBiomeForMachineId(int id, Biome biome) {
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        BlockPos roomPos = WorldSavedDataMachines.getInstance().getMachineRoomPosition(id);
        if (roomPos == null) {
            return false;
        }
        Chunk chunk = machineWorld.func_175726_f(roomPos);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.func_76605_m()[z << 4 | x] = (byte)Biome.func_185362_a((Biome)biome);
            }
        }
        return true;
    }

    public static void generateCubeForMachine(TileEntityMachine machine) {
        if (machine.id != -1) {
            return;
        }
        machine.id = WorldSavedDataMachines.reserveMachineId();
        CompactMachines3.logger.info("Reserved id {} for machine", (Object)machine.id);
        machine.func_70296_d();
        StructureTools.generateCube(machine);
    }

    private static void generateCube(TileEntityMachine machine) {
        int size = machine.getSize().getDimension();
        WorldSavedDataMachines wsd = WorldSavedDataMachines.getInstance();
        Map<Integer, BlockPos> machineGrid = wsd.machineGrid;
        BlockPos roomPos = null;
        while (machineGrid.containsValue(roomPos = StructureTools.getNextGridPosition(roomPos))) {
        }
        machine.setRoomPos(roomPos);
        wsd.addMachineSize(machine.id, machine.getSize());
        machine.func_70296_d();
        int startX = machine.getRoomPos().func_177958_n();
        int startY = machine.getRoomPos().func_177956_o();
        int startZ = machine.getRoomPos().func_177952_p();
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        IBlockState wallDefaultState = Blockss.wall.func_176223_P();
        IBlockState barrier = Blocks.field_180401_cv.func_176223_P();
        StructureTools.generateCubeWalls((World)machineWorld, new BlockPos(startX, startY, startZ), size, wallDefaultState);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX - 1, startY - 1, startZ - 1), size + 2, barrier);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX - 2, startY - 2, startZ - 2), size + 4, barrier);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX - 3, startY - 3, startZ - 3), size + 6, barrier);
    }

    private static BlockPos getNextGridPosition(BlockPos previous) {
        BlockPos lastGrid;
        WorldSavedDataMachines wsd = WorldSavedDataMachines.getInstance();
        BlockPos blockPos = lastGrid = previous != null ? previous : wsd.lastGrid;
        if (lastGrid == null) {
            lastGrid = new BlockPos(0, 40, 0);
            return lastGrid;
        }
        int x = lastGrid.func_177958_n();
        int z = lastGrid.func_177952_p();
        int distance = 512;
        if (x < z) {
            if (-1 * x < z) {
                return lastGrid.func_177982_a(distance, 0, 0);
            }
            return lastGrid.func_177982_a(0, 0, distance);
        }
        if (x > z) {
            if (-1 * x >= z) {
                return lastGrid.func_177982_a(-distance, 0, 0);
            }
            return lastGrid.func_177982_a(0, 0, -distance);
        }
        if (x <= 0) {
            return lastGrid.func_177982_a(0, 0, distance);
        }
        return lastGrid.func_177982_a(0, 0, -distance);
    }

    public static void generateCubeWalls(World world, BlockPos cornerPos, int size, IBlockState state) {
        for (int x = 0; x <= size; ++x) {
            for (int y = 0; y <= size; ++y) {
                for (int z = 0; z <= size; ++z) {
                    if (x != 0 && x != size && y != 0 && y != size && z != 0 && z != size) continue;
                    BlockPos pos = new BlockPos(x, y, z).func_177971_a((Vec3i)cornerPos);
                    if (x == 0 && y == 2 && z == size / 2) {
                        world.func_175656_a(pos, Blockss.window.func_176223_P());
                        continue;
                    }
                    world.func_175656_a(pos, state);
                }
            }
        }
    }

    public static void generateCube(World world, BlockPos cornerPos, int size, IBlockState state) {
        for (BlockPos pos : StructureTools.getCubePositions(cornerPos, size, size, size)) {
            world.func_175656_a(pos, state);
        }
    }

    public static EnumFacing getInsetWallFacing(BlockPos wallPos, BlockPos roomPos, EnumMachineSize size) {
        int dimensions = size.getDimension();
        int x = wallPos.func_177958_n() - roomPos.func_177958_n();
        int y = wallPos.func_177956_o() - roomPos.func_177956_o();
        int z = wallPos.func_177952_p() - roomPos.func_177952_p();
        if (y == 0) {
            return EnumFacing.UP;
        }
        if (y == dimensions) {
            return EnumFacing.DOWN;
        }
        if (x == 0) {
            return EnumFacing.EAST;
        }
        if (x == dimensions) {
            return EnumFacing.WEST;
        }
        if (z == 0) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }

    public static List<BlockPos> getCubePositionsLegacy(BlockPos cornerPos, int width, int height, int depth, boolean includeFloor) {
        int minX = Math.min(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int minY = Math.min(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int minZ = Math.min(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        int maxX = Math.max(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int maxY = Math.max(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int maxZ = Math.max(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && z != minZ && x != maxX && y != maxY && z != maxZ && y != minY || !includeFloor && y == minY) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public static List<BlockPos> getCubePositions(BlockPos bottomNorthwestCorner, int width, int height, int depth) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = 0; x <= width; ++x) {
            for (int y = 0; y <= height; ++y) {
                for (int z = 0; z <= depth; ++z) {
                    if (x != 0 && x != width && y != 0 && y != height && z != 0 && z != depth) continue;
                    BlockPos pos = new BlockPos(x, y, z).func_177971_a((Vec3i)bottomNorthwestCorner);
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public static List<BlockInformation> createNewSchema(int id) {
        TileEntity machine = WorldSavedDataMachines.getInstance().getMachineBlockPosition(id).getTileEntity();
        if (machine instanceof TileEntityMachine) {
            return StructureTools.createNewSchema((TileEntityMachine)machine);
        }
        return null;
    }

    public static List<BlockInformation> createNewSchema(TileEntityMachine machine) {
        ArrayList<BlockInformation> blockList = new ArrayList<BlockInformation>();
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        int size = machine.getSize().getDimension();
        BlockPos roomPos = machine.getRoomPos().func_177982_a(size, size, size);
        for (int x = 1; x <= size - 1; ++x) {
            for (int y = 1; y <= size - 1; ++y) {
                for (int z = 1; z <= size - 1; ++z) {
                    BlockPos absolutePos = roomPos.func_177982_a(-x, -y, -z);
                    BlockPos relativePos = new BlockPos(x - 1, y - 1, z - 1);
                    if (machineWorld.func_175623_d(absolutePos)) continue;
                    IBlockState state = machineWorld.func_180495_p(absolutePos);
                    Block block = state.func_177230_c();
                    NBTTagCompound nbt = null;
                    boolean writePositionData = false;
                    TileEntity te = machineWorld.func_175625_s(absolutePos);
                    if (block.hasTileEntity(state) && te != null) {
                        boolean storedZ;
                        nbt = new NBTTagCompound();
                        te.func_189515_b(nbt);
                        boolean storedX = nbt.func_74764_b("x") && nbt.func_74762_e("x") == absolutePos.func_177958_n();
                        boolean storedY = nbt.func_74764_b("y") && nbt.func_74762_e("y") == absolutePos.func_177956_o();
                        boolean bl = storedZ = nbt.func_74764_b("z") && nbt.func_74762_e("z") == absolutePos.func_177952_p();
                        if (storedX && storedY && storedZ) {
                            writePositionData = true;
                        }
                    }
                    blockList.add(new BlockInformation(relativePos, block, block.func_176201_c(state), nbt, writePositionData));
                }
            }
        }
        return blockList;
    }

    public static void restoreSchema(Schema schema, int id) {
        List<BlockInformation> blockList = schema.getBlocks();
        TileEntityMachine machine = WorldSavedDataMachines.getInstance().getMachine(id);
        if (machine == null) {
            return;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        int size = machine.getSize().getDimension();
        BlockPos roomPos = machine.getRoomPos().func_177982_a(size - 1, size - 1, size - 1);
        for (BlockInformation bi : blockList) {
            BlockPos absolutePos = roomPos.func_177982_a(-bi.position.func_177958_n(), -bi.position.func_177956_o(), -bi.position.func_177952_p());
            IBlockState state = bi.block.func_176203_a(bi.meta);
            machineWorld.func_175656_a(absolutePos, state);
            if (bi.nbt == null) continue;
            TileEntity restoredTe = machineWorld.func_175625_s(absolutePos);
            if (restoredTe == null) {
                restoredTe = bi.block.createTileEntity((World)machineWorld, state);
            }
            if (restoredTe == null) continue;
            if (bi.writePositionData) {
                bi.nbt.func_74768_a("x", absolutePos.func_177958_n());
                bi.nbt.func_74768_a("y", absolutePos.func_177956_o());
                bi.nbt.func_74768_a("z", absolutePos.func_177952_p());
            }
            restoredTe.func_145839_a(bi.nbt);
            restoredTe.func_70296_d();
        }
    }
}

