/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.brackets;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.damage.IDamageSource;
import crafttweaker.mc1120.damage.expand.MCDamageSourceExpand;
import crafttweaker.zenscript.IBracketHandler;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

@BracketHandler(priority=10)
@ZenRegister
public class BracketHandlerDamageSource
implements IBracketHandler {
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(BracketHandlerDamageSource.class, "getFromString", String.class);

    @Override
    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        String name;
        if (tokens == null || tokens.size() < 3 || !tokens.get(0).getValue().equalsIgnoreCase("damageSource")) {
            return null;
        }
        switch (name = tokens.get(2).getValue()) {
            case "IN_FIRE": 
            case "LIGHTNING_BOLT": 
            case "ON_FIRE": 
            case "LAVA": 
            case "HOT_FLOOR": 
            case "IN_WALL": 
            case "CRAMMING": 
            case "DROWN": 
            case "STARVE": 
            case "CACTUS": 
            case "FALL": 
            case "FLY_INTO_WALL": 
            case "OUT_OF_WORLD": 
            case "GENERIC": 
            case "MAGIC": 
            case "WITHER": 
            case "ANVIL": 
            case "FALLING_BLOCK": 
            case "DRAGON_BREATH": 
            case "FIREWORKS": {
                return this.makeSymbolSwitched(name, environment);
            }
        }
        return this.makeSymbol(name, environment);
    }

    private IZenSymbol makeSymbolSwitched(String name, IEnvironmentGlobal environment) {
        return position -> new ExpressionCallStatic(position, environment, JavaMethod.get(environment.getEnvironment().getTypeRegistry(), MCDamageSourceExpand.class, name, new Class[0]), new Expression[0]);
    }

    private IZenSymbol makeSymbol(String name, IEnvironmentGlobal environment) {
        return position -> new ExpressionCallStatic(position, environment, this.method, new ExpressionString(position, name));
    }

    public static IDamageSource getFromString(String name) {
        return MCDamageSourceExpand.createOfType(name);
    }

    @Override
    public String getRegexMatchingString() {
        return "damageSource:.*";
    }

    @Override
    public Class<?> getReturnedClass() {
        return IDamageSource.class;
    }
}

