/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.api.ICrystalLink;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBeam;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXLink;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXWireless;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ENetFXHandlerClientWireless
extends ENetFXHandler<TileCrystalDirectIO> {
    protected CrystalGLFXBase staticFX;
    protected LinkedList<CrystalGLFXBase> beamFXList = new LinkedList();
    protected LinkedList<CrystalGLFXBase> transferFXList = new LinkedList();
    protected LinkedList<CrystalGLFXBase> linkFX = null;

    public ENetFXHandlerClientWireless(TileCrystalDirectIO tile) {
        super(tile);
    }

    @Override
    public void update() {
        int i;
        if (((TileCrystalDirectIO)this.tile).hasStaticFX()) {
            if (this.staticFX == null || !this.staticFX.func_187113_k()) {
                this.staticFX = ((TileCrystalDirectIO)this.tile).createStaticFX();
                BCEffectHandler.spawnGLParticle((IGLFXHandler)this.staticFX.getFXHandler(), (BCParticle)this.staticFX);
            }
            this.staticFX.updateFX(0.5f);
            boolean bl = this.staticFX.renderEnabled = this.renderCooldown > 0;
        }
        if (this.renderCooldown > 0) {
            --this.renderCooldown;
        }
        boolean requiresUpdate = false;
        for (CrystalGLFXBase beam : this.beamFXList) {
            if (!beam.func_187113_k()) {
                requiresUpdate = true;
            }
            i = this.beamFXList.indexOf((Object)beam);
            if (((TileCrystalDirectIO)this.tile).flowRates.size() <= i || i < 0) continue;
            beam.updateFX((float)((Byte)((TileCrystalDirectIO)this.tile).flowRates.get((byte)i) & 0xFF) / 255.0f);
        }
        for (CrystalGLFXBase transFX : this.transferFXList) {
            if (!transFX.func_187113_k()) {
                requiresUpdate = true;
            }
            i = this.transferFXList.indexOf((Object)transFX);
            if (((TileCrystalDirectIO)this.tile).receiverFlowRates.size() <= i || i < 0) continue;
            transFX.updateFX((float)(((TileCrystalDirectIO)this.tile).receiverFlowRates.get(i) & 0xFF) / 255.0f);
        }
        if (requiresUpdate || ((TileCrystalDirectIO)this.tile).getReceivers().size() != this.transferFXList.size()) {
            this.reloadConnections();
        }
        if (ClientEventHandler.playerHoldingWrench) {
            if (this.linkFX == null || this.linkFX.size() != ((TileCrystalDirectIO)this.tile).getReceivers().size()) {
                if (this.linkFX != null) {
                    for (CrystalGLFXBase fx : this.linkFX) {
                        fx.func_187112_i();
                    }
                }
                this.linkFX = new LinkedList();
                for (BlockPos receiver : ((TileCrystalDirectIO)this.tile).getReceivers()) {
                    CrystalFXLink link = new CrystalFXLink(((TileCrystalDirectIO)this.tile).func_145831_w(), (TileCrystalBase)this.tile, Vec3D.getCenter((BlockPos)receiver));
                    this.linkFX.add(link);
                    BCEffectHandler.spawnGLParticle((IGLFXHandler)link.getFXHandler(), (BCParticle)link);
                }
            }
        } else if (this.linkFX != null) {
            this.linkFX = null;
        }
    }

    @Override
    public void updateReceived(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        byte index;
        ((TileCrystalDirectIO)this.tile).modifyEnergyStored(update.crystalCapacity - ((TileCrystalDirectIO)this.tile).getEnergyStored());
        Map<Byte, Byte> flowMap = update.indexToFlowMap;
        for (index = 0; index < ((TileCrystalDirectIO)this.tile).flowRates.size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey(index)) continue;
            flowMap.put(index, (Byte)((TileCrystalDirectIO)this.tile).flowRates.get(index));
        }
        for (index = 0; index < ((TileCrystalDirectIO)this.tile).receiverFlowRates.size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey((byte)(index + 128))) continue;
            flowMap.put((byte)(index + 128), ((TileCrystalDirectIO)this.tile).receiverFlowRates.get(index));
        }
        ((TileCrystalDirectIO)this.tile).flowRates.clear();
        ((TileCrystalDirectIO)this.tile).receiverFlowRates.clear();
        for (byte b : flowMap.keySet()) {
            if ((b & 0xFF) >= 128) {
                ((TileCrystalDirectIO)this.tile).receiverFlowRates.add(flowMap.get(b));
                continue;
            }
            ((TileCrystalDirectIO)this.tile).flowRates.add(flowMap.get(b));
        }
    }

    @Override
    public void reloadConnections() {
        this.beamFXList.clear();
        this.transferFXList.clear();
        for (BlockPos pos : ((TileCrystalDirectIO)this.tile).getLinks()) {
            TileEntity target = ((TileCrystalDirectIO)this.tile).func_145831_w().func_175625_s(pos);
            if (!(target instanceof ICrystalLink)) continue;
            CrystalFXBeam beam = new CrystalFXBeam(((TileCrystalDirectIO)this.tile).func_145831_w(), this.tile, (ICrystalLink)target);
            this.beamFXList.add(beam);
            BCEffectHandler.spawnGLParticle((IGLFXHandler)beam.getFXHandler(), (BCParticle)beam);
        }
        for (BlockPos pos : ((TileCrystalDirectIO)this.tile).getReceivers()) {
            CrystalFXWireless wirelessFX = new CrystalFXWireless(((TileCrystalDirectIO)this.tile).func_145831_w(), (TileCrystalDirectIO)this.tile, pos);
            this.transferFXList.add(wirelessFX);
            BCEffectHandler.spawnGLParticle((IGLFXHandler)wirelessFX.getFXHandler(), (BCParticle)wirelessFX);
        }
    }

    @Override
    public void tileUnload() {
        super.tileUnload();
    }
}

