/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.draconicevolution.blocks.machines.FlowGate;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluxGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileFlowGate
extends TileBCBase
implements ITickable,
IChangeListener {
    protected int transferThisTick = 0;
    public final ManagedInt minFlow = (ManagedInt)this.register("minFlow", (IManagedData)new ManagedInt(0)).syncViaTile().saveToTile().saveToItem().finish();
    public final ManagedInt maxFlow = (ManagedInt)this.register("maxFlow", (IManagedData)new ManagedInt(0)).syncViaTile().saveToTile().saveToItem().finish();
    public final ManagedInt flowOverride = (ManagedInt)this.register("flowOverride", (IManagedData)new ManagedInt(0)).syncViaTile().saveToTile().finish();
    public final ManagedBool flowOverridden = (ManagedBool)this.register("flowOverridden", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().finish();
    public final ManagedByte rsSignal = (ManagedByte)this.register("rsSignal", (IManagedData)new ManagedByte(-1)).syncViaTile().saveToTile().finish();

    public TileFlowGate() {
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        super.update();
        this.transferThisTick = 0;
    }

    public String getName() {
        return "tile.draconicevolution:" + (this instanceof TileFluxGate ? "flux_gate" : "fluid_gate") + ".name";
    }

    public abstract String getUnits();

    @SideOnly(value=Side.CLIENT)
    public void setMin(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void setMax(String value) {
        this.sendPacketToServer(output -> output.writeString(value), 1);
    }

    public int getFlow() {
        if (this.flowOverridden.value) {
            return this.flowOverride.value;
        }
        if (this.rsSignal.value == -1) {
            this.rsSignal.value = (byte)this.field_145850_b.func_175687_A(this.field_174879_c);
        }
        return this.minFlow.value + (int)((double)this.rsSignal.value / 15.0 * (double)(this.maxFlow.value - this.minFlow.value));
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        if (this.flowOverridden.value) {
            return;
        }
        try {
            String value = data.readString();
            long l = Long.parseLong(value);
            if (l < 0L) {
                l = 0L;
            } else if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (id == 0) {
                this.minFlow.value = (int)l;
            } else if (id == 1) {
                this.maxFlow.value = (int)l;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public TileEntity getTarget() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getDirection()));
    }

    public EnumFacing getDirection() {
        IBlockState state = this.getState(this.func_145838_q());
        return (EnumFacing)state.func_177229_b((IProperty)FlowGate.FACING);
    }

    public void onNeighborChange(BlockPos neighbor) {
        this.rsSignal.value = (byte)this.field_145850_b.func_175687_A(this.field_174879_c);
    }
}

