/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network.impl;

import com.google.common.collect.Lists;
import elec332.core.api.network.IPacketRegistry;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.relauncher.Side;

class DefaultPacketRegistry
implements IPacketRegistry {
    private final List<Wrapper<?, ?>> registeredPackets = Lists.newArrayList();

    DefaultPacketRegistry() {
    }

    @Override
    public <M extends IMessage, R extends IMessage> void registerPacket(IMessageHandler<M, R> messageHandler, Class<M> messageType, Side side) {
        this.registeredPackets.add(new Wrapper(messageHandler, messageType, side));
    }

    @Override
    public void registerPacketsTo(IPacketRegistry packetRegistry) {
        for (Wrapper<?, ?> wrapper : this.registeredPackets) {
            packetRegistry.registerPacket(((Wrapper)wrapper).messageHandler, ((Wrapper)wrapper).messageType, ((Wrapper)wrapper).side);
        }
    }

    private class Wrapper<M extends IMessage, R extends IMessage> {
        private final IMessageHandler<M, R> messageHandler;
        private final Class<M> messageType;
        private final Side side;

        private Wrapper(IMessageHandler<M, R> messageHandler, Class<M> messageType, Side side) {
            this.messageHandler = messageHandler;
            this.messageType = messageType;
            this.side = side;
        }
    }
}

