/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network.impl;

import com.google.common.base.Preconditions;
import elec332.core.api.network.INetworkHandler;
import elec332.core.api.network.IPacketDispatcher;
import elec332.core.api.network.simple.ISimpleNetworkPacketManager;
import elec332.core.api.network.simple.ISimplePacket;
import elec332.core.api.network.simple.ISimplePacketHandler;
import elec332.core.network.impl.ElecByteBufImpl;
import elec332.core.network.impl.NetworkManager;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

class DefaultSimpleNetworkHandler
implements ISimpleNetworkPacketManager,
IMessageHandler<PacketSimplePacket, IMessage> {
    private final IPacketDispatcher packetDispatcher;
    private final String s;
    private TIntObjectMap<ISimplePacketHandler> idToHandler = new TIntObjectHashMap();
    private TObjectIntMap<ISimplePacketHandler> handlerToId = new TObjectIntHashMap();
    private TObjectIntMap<Class<? extends ISimplePacket>> packetToId = new TObjectIntHashMap();
    private byte b = 0;

    DefaultSimpleNetworkHandler(INetworkHandler networkHandler, String s) {
        for (Side side : Side.values()) {
            networkHandler.registerPacket(this, PacketSimplePacket.class, side);
        }
        this.packetDispatcher = networkHandler;
        this.s = s;
    }

    @Override
    public String getChannelName() {
        return this.s;
    }

    @Override
    public void sendToAll(ISimplePacket message) {
        this.packetDispatcher.sendToAll(this.from(message));
    }

    @Override
    public void sendTo(ISimplePacket message, EntityPlayerMP player) {
        this.packetDispatcher.sendTo((IMessage)this.from(message), player);
    }

    @Override
    public void sendToAllAround(ISimplePacket message, NetworkRegistry.TargetPoint point) {
        this.packetDispatcher.sendToAllAround(this.from(message), point);
    }

    @Override
    public void sendToDimension(ISimplePacket message, int dimensionId) {
        this.packetDispatcher.sendToDimension(this.from(message), dimensionId);
    }

    @Override
    public void sendToServer(ISimplePacket message) {
        this.packetDispatcher.sendToServer(this.from(message));
    }

    @Override
    public void sendToAll(ISimplePacket message, ISimplePacketHandler packetHandler) {
        this.packetDispatcher.sendToAll(this.from(message, packetHandler));
    }

    @Override
    public void sendTo(ISimplePacket message, ISimplePacketHandler packetHandler, EntityPlayerMP player) {
        this.packetDispatcher.sendTo((IMessage)this.from(message, packetHandler), player);
    }

    @Override
    public void sendToAllAround(ISimplePacket message, ISimplePacketHandler packetHandler, NetworkRegistry.TargetPoint point) {
        this.packetDispatcher.sendToAllAround(this.from(message, packetHandler), point);
    }

    @Override
    public void sendToDimension(ISimplePacket message, ISimplePacketHandler packetHandler, int dimensionId) {
        this.packetDispatcher.sendToDimension(this.from(message, packetHandler), dimensionId);
    }

    @Override
    public void sendToServer(ISimplePacket message, ISimplePacketHandler packetHandler) {
        this.packetDispatcher.sendToServer(this.from(message, packetHandler));
    }

    @Override
    public void sendToAll(ByteBuf data, ISimplePacketHandler packetHandler) {
        this.packetDispatcher.sendToAll(this.from(data, packetHandler));
    }

    @Override
    public void sendTo(ByteBuf data, ISimplePacketHandler packetHandler, EntityPlayerMP player) {
        this.packetDispatcher.sendTo((IMessage)this.from(data, packetHandler), player);
    }

    @Override
    public void sendToAllAround(ByteBuf data, ISimplePacketHandler packetHandler, NetworkRegistry.TargetPoint point) {
        this.packetDispatcher.sendToAllAround(this.from(data, packetHandler), point);
    }

    @Override
    public void sendToDimension(ByteBuf data, ISimplePacketHandler packetHandler, int dimensionId) {
        this.packetDispatcher.sendToDimension(this.from(data, packetHandler), dimensionId);
    }

    @Override
    public void sendToServer(ByteBuf data, ISimplePacketHandler packetHandler) {
        this.packetDispatcher.sendToServer(this.from(data, packetHandler));
    }

    private PacketSimplePacket from(ISimplePacket message) {
        return new PacketSimplePacket(this.packetToId.get(message.getClass()), this.fetchData(message));
    }

    private PacketSimplePacket from(ISimplePacket message, ISimplePacketHandler handler) {
        return new PacketSimplePacket(this.handlerToId.get((Object)handler), this.fetchData(message));
    }

    private PacketSimplePacket from(ByteBuf data, ISimplePacketHandler handler) {
        return new PacketSimplePacket(this.handlerToId.get((Object)handler), data);
    }

    private ByteBuf fetchData(ISimplePacket packet) {
        ElecByteBufImpl ret = new ElecByteBufImpl(UnpooledByteBufAllocator.DEFAULT.ioBuffer());
        packet.toBytes(ret);
        return ret;
    }

    @Override
    public void registerPacket(Class<? extends ISimplePacket> packet) {
        try {
            this.registerPacket(packet.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerPacket(ISimplePacket packet) {
        ISimplePacketHandler handler = packet.getPacketHandler();
        if (handler == null) {
            throw new UnsupportedOperationException();
        }
        this.registerPacket(packet, handler);
    }

    @Override
    public void registerPacketHandler(ISimplePacketHandler packetHandler) {
        Preconditions.checkNotNull((Object)packetHandler);
        this.idToHandler.put((int)this.b, (Object)packetHandler);
        this.handlerToId.put((Object)packetHandler, (int)this.b);
        this.b = (byte)(this.b + 1);
    }

    @Override
    public void registerPacket(Class<? extends ISimplePacket> packet, ISimplePacketHandler packetHandler) {
        try {
            this.registerPacket(packet.newInstance(), packetHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerPacket(ISimplePacket packet, ISimplePacketHandler packetHandler) {
        Preconditions.checkNotNull((Object)packet);
        Preconditions.checkNotNull((Object)packetHandler);
        ISimplePacketHandler ph = packet.getPacketHandler();
        if (ph != null && ph != packetHandler) {
            throw new IllegalArgumentException();
        }
        this.packetToId.put(packet.getClass(), (int)this.b);
        this.registerPacketHandler(packetHandler);
    }

    @Override
    public IPacketDispatcher getPacketDispatcher() {
        return this.packetDispatcher;
    }

    public IMessage onMessage(PacketSimplePacket message, MessageContext ctx) {
        ((ISimplePacketHandler)Preconditions.checkNotNull((Object)this.idToHandler.get((int)message.i))).onPacket(new ElecByteBufImpl(message.data), NetworkManager.INSTANCE.wrapMessageContext(ctx), this);
        return null;
    }

    public static class PacketSimplePacket
    implements IMessage {
        byte i;
        ByteBuf data;

        public PacketSimplePacket() {
        }

        PacketSimplePacket(int i, ByteBuf buf) {
            this.i = (byte)i;
            this.data = buf;
        }

        public void fromBytes(ByteBuf buf) {
            this.i = buf.readByte();
            this.data = Unpooled.buffer((int)buf.readableBytes());
            buf.readBytes(this.data);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.i);
            buf.writeBytes(this.data);
        }
    }
}

