/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class FluidTankWrapper
implements IFluidHandler,
IFluidTank,
INBTSerializable<NBTTagCompound> {
    private IFluidTankProperties[] properties;

    public static FluidTankWrapper withCapacity(int capacity) {
        return FluidTankWrapper.of((IFluidTank)new FluidTank(capacity));
    }

    public static FluidTankWrapper of(final Supplier<IFluidTank> tank) {
        return new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return (IFluidTank)tank.get();
            }
        };
    }

    public static FluidTankWrapper of(final IFluidTank tank) {
        return new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return tank;
            }
        };
    }

    public FluidTankWrapper() {
        Properties prop = new Properties(this);
        this.properties = new IFluidTankProperties[]{prop};
    }

    protected abstract IFluidTank getTank();

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack f = this.getTank().getFluid();
        if (f != null && !f.isFluidEqual(resource)) {
            return 0;
        }
        if (this.canFillFluidType(resource)) {
            return this.getTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack f = this.getTank().getFluid();
        if (resource == null || !resource.isFluidEqual(f)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack f = this.getTank().getFluid();
        if (f == null || !this.canDrainFluidType(f)) {
            return null;
        }
        return this.getTank().drain(maxDrain, doDrain);
    }

    @Nullable
    public FluidStack getFluid() {
        FluidStack tankStack = this.getTank().getFluid();
        return tankStack == null ? null : tankStack.copy();
    }

    public int getFluidAmount() {
        return this.getTank().getFluidAmount();
    }

    public int getCapacity() {
        return this.getTank().getCapacity();
    }

    public FluidTankInfo getInfo() {
        return this.getTank().getInfo();
    }

    protected boolean canFill() {
        return true;
    }

    protected boolean canDrain() {
        return true;
    }

    protected boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill();
    }

    protected boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain();
    }

    public NBTTagCompound serializeNBT() {
        if (this.getTank() instanceof FluidTankWrapper) {
            return ((FluidTankWrapper)this.getTank()).serializeNBT();
        }
        if (this.getTank() instanceof FluidTank) {
            return ((FluidTank)this.getTank()).writeToNBT(new NBTTagCompound());
        }
        throw new UnsupportedOperationException();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (this.getTank() instanceof FluidTankWrapper) {
            ((FluidTankWrapper)this.getTank()).deserializeNBT(nbt);
        } else if (this.getTank() instanceof FluidTank) {
            ((FluidTank)this.getTank()).readFromNBT(nbt);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private class Properties
    implements IFluidTankProperties {
        private final FluidTankWrapper tank;

        private Properties(FluidTankWrapper tank) {
            this.tank = tank;
        }

        @Nullable
        public FluidStack getContents() {
            FluidStack stack = this.tank.getTank().getFluid();
            return stack == null ? null : stack.copy();
        }

        public int getCapacity() {
            return this.tank.getTank().getCapacity();
        }

        public boolean canFill() {
            return this.tank.canFill();
        }

        public boolean canDrain() {
            return this.tank.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return this.tank.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.tank.canDrainFluidType(fluidStack);
        }
    }
}

