/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import info.loenwind.autoconfig.ConfigHandler;
import info.loenwind.autoconfig.factory.IRootFactory;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class Config
extends ConfigHandler {
    public Config(@Nonnull FMLPreInitializationEvent event, @Nonnull IRootFactory factory, String folder) {
        super(event, factory, folder);
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals(this.factory.getModid())) {
            Log.info("Reloading config file...");
            this.config.load();
            this.syncConfig();
            event.setSuccessful();
            Log.info("Config reload finished");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(this.factory.getModid())) {
            Log.info("Updating config...");
            this.syncConfig();
            for (ModContainer modContainer : Loader.instance().getModList()) {
                if (!(modContainer.getMod() instanceof IEnderIOAddon) || modContainer.getModId().equals(this.factory.getModid())) continue;
                MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent(modContainer.getModId(), null, event.isWorldRunning(), event.isRequiresMcRestart()));
            }
            Log.info("Config update finished");
        }
    }

    @Nonnull
    public File getConfigDirectory() {
        return this.configDirectory;
    }
}

