/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.common.util.NullHelper;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FuncUtil {
    public static <F, E> E runIf(@Nullable F source, FunctionNN<F, E> getter) {
        return source == null ? null : (E)getter.apply(source);
    }

    public static <F, E> E runIfOr(@Nullable F source, FunctionNN<F, E> getter, E defaultValue) {
        return source == null ? defaultValue : getter.apply(source);
    }

    public static <F, E> E runIfOrSup(@Nullable F source, FunctionNN<F, E> getter, Supplier<E> defaultValue) {
        return source == null ? defaultValue.get() : getter.apply(source);
    }

    @Nonnull
    public static <F, E> E runIfOrNN(@Nullable F source, FunctionNN<F, E> getter, @Nonnull E defaultValue) {
        return (E)NullHelper.first((Object[])new Object[]{source == null ? null : getter.apply(source), defaultValue});
    }

    @Nonnull
    public static <F, E> E runIfOrSupNN(@Nullable F source, FunctionNN<F, E> getter, @Nonnull Supplier<E> defaultValue) {
        return (E)NullHelper.first((Object[])new Object[]{source == null ? null : getter.apply(source), defaultValue.get()});
    }

    public static <F> void doIf(@Nullable F source, ConsumerNN<F> setter) {
        if (source != null) {
            setter.accept(source);
        }
    }

    @FunctionalInterface
    public static interface ConsumerNN<T>
    extends Consumer<T> {
        @Override
        public void accept(@Nonnull T var1);
    }

    @FunctionalInterface
    public static interface FunctionNN<T, R>
    extends Function<T, R> {
        @Override
        public R apply(@Nonnull T var1);
    }
}

