/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.registry.ConduitBuilder;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.conduit.registry.ConduitTypeDefinition;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.conduits.conduit.AbstractItemConduit;
import crazypants.enderio.conduits.conduit.ItemConduitSubtype;
import crazypants.enderio.conduits.conduit.liquid.AdvancedLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.AdvancedLiquidConduitRenderer;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduitRenderer;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.LiquidConduitRenderer;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.ConduitBundleRenderManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLiquidConduit
extends AbstractItemConduit
implements IAdvancedTooltipProvider {
    public static ItemLiquidConduit create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemLiquidConduit(modObject);
    }

    protected ItemLiquidConduit(@Nonnull IModObject modObject) {
        super(modObject, new ItemConduitSubtype(modObject.getUnlocalisedName(), modObject.getRegistryName().toString()), new ItemConduitSubtype(modObject.getUnlocalisedName() + "_advanced", modObject.getRegistryName().toString() + "_advanced"), new ItemConduitSubtype(modObject.getUnlocalisedName() + "_ender", modObject.getRegistryName().toString() + "_ender"));
        ConduitRegistry.register((ConduitTypeDefinition)ConduitBuilder.start().setUUID(new ResourceLocation("enderio", "fluid")).setClass(this.getBaseConduitType()).setOffsets(Offset.WEST, Offset.NORTH, Offset.WEST, Offset.WEST).build().setUUID(new ResourceLocation("enderio", "liquid_conduit")).setClass(LiquidConduit.class).build().setUUID(new ResourceLocation("enderio", "advanced_liquid_conduit")).setClass(AdvancedLiquidConduit.class).build().setUUID(new ResourceLocation("enderio", "ender_liquid_conduit")).setClass(EnderLiquidConduit.class).build().finish());
        ConduitDisplayMode.registerDisplayMode((ConduitDisplayMode)new ConduitDisplayMode(this.getBaseConduitType(), (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID_OFF));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        super.registerRenderers(modObject);
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer(LiquidConduitRenderer.create());
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer(new AdvancedLiquidConduitRenderer());
        ConduitBundleRenderManager.instance.getConduitBundleRenderer().registerRenderer(new EnderLiquidConduitRenderer());
    }

    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return ILiquidConduit.class;
    }

    public IServerConduit createConduit(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        if (stack.func_77952_i() == 1) {
            return new AdvancedLiquidConduit();
        }
        if (stack.func_77952_i() == 2) {
            return new EnderLiquidConduit();
        }
        return new LiquidConduit();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        int maxIo;
        int extractRate;
        if (itemstack.func_77952_i() == 0) {
            extractRate = (Integer)ConduitConfig.fluid_tier1_extractRate.get();
            maxIo = (Integer)ConduitConfig.fluid_tier1_maxIO.get();
        } else if (itemstack.func_77952_i() == 1) {
            extractRate = (Integer)ConduitConfig.fluid_tier2_extractRate.get();
            maxIo = (Integer)ConduitConfig.fluid_tier2_maxIO.get();
        } else {
            extractRate = (Integer)ConduitConfig.fluid_tier3_extractRate.get();
            maxIo = (Integer)ConduitConfig.fluid_tier3_maxIO.get();
        }
        String mbt = " " + Lang.FLUID_MILLIBUCKETS_TICK.get();
        list.add(Lang.GUI_LIQUID_TOOLTIP_MAX_EXTRACT.get() + " " + extractRate + mbt);
        list.add(Lang.GUI_LIQUID_TOOLTIP_MAX_IO.get() + " " + maxIo + mbt);
        if (itemstack.func_77952_i() == 0) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.item_liquid_conduit");
        } else if (itemstack.func_77952_i() == 2) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(list, (String)"enderio.item_liquid_conduit_ender");
        }
    }

    public boolean shouldHideFacades(@Nonnull ItemStack stack, @Nonnull EntityPlayer player) {
        return true;
    }
}

