/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.client.gui.button.ColorButton;
import crazypants.enderio.base.conduit.IExtractor;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.network.PacketExtractMode;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ConduitRedstoneModeControlable
implements IRedstoneModeControlable {
    private final IExtractor con;
    private final IGuiExternalConnection gui;
    private final ColorButton colorB;

    public ConduitRedstoneModeControlable(@Nonnull IExtractor con, @Nonnull IGuiExternalConnection gui, @Nonnull ColorButton colorB) {
        this.con = con;
        this.gui = gui;
        this.colorB = colorB;
    }

    public void setRedstoneControlMode(@Nonnull RedstoneControlMode mode) {
        RedstoneControlMode curMode = this.getRedstoneControlMode();
        this.con.setExtractionRedstoneMode(mode, this.gui.getDir());
        this.colorB.onGuiInit();
        this.colorB.setColorIndex(this.con.getExtractionSignalColor(this.gui.getDir()).ordinal());
        if (mode == RedstoneControlMode.OFF || mode == RedstoneControlMode.ON) {
            this.colorB.setIsVisible(true);
        } else {
            this.colorB.setIsVisible(false);
        }
        if (curMode != mode) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.con, this.gui.getDir()));
        }
    }

    @Nonnull
    public RedstoneControlMode getRedstoneControlMode() {
        return this.con.getExtractionRedstoneMode(this.gui.getDir());
    }

    public boolean getRedstoneControlStatus() {
        return false;
    }
}

