/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitOutputStrength
extends AbstractConduitPacket.Sided<IRedstoneConduit> {
    private boolean isStrong;

    public PacketRedstoneConduitOutputStrength() {
    }

    public PacketRedstoneConduitOutputStrength(@Nonnull IRedstoneConduit con, @Nonnull EnumFacing dir) {
        super(con, dir);
        this.isStrong = con.isOutputStrong(dir);
    }

    @Override
    public void write(@Nonnull ByteBuf buf) {
        super.write(buf);
        buf.writeBoolean(this.isStrong);
    }

    @Override
    public void read(@Nonnull ByteBuf buf) {
        super.read(buf);
        this.isStrong = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketRedstoneConduitOutputStrength, IMessage> {
        public IMessage onMessage(PacketRedstoneConduitOutputStrength message, MessageContext ctx) {
            IRedstoneConduit tile = (IRedstoneConduit)message.getConduit(ctx);
            if (tile != null) {
                tile.setOutputStrength(message.dir, message.isStrong);
            }
            return null;
        }
    }
}

