/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.google.common.collect.ImmutableMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class XUCollectorHelper {
    public static <E> Collector<E, ?, List<Pair<E, Integer>>> runs() {
        return Collector.of(LinkedList::new, (pairs, e) -> {
            Pair lastValue;
            if (!pairs.isEmpty() && Objects.equals(e, (lastValue = (Pair)pairs.peekLast()).getKey())) {
                lastValue.setValue((Object)((Integer)lastValue.getValue() + 1));
            } else {
                pairs.add(new MutablePair(e, (Object)1));
            }
        }, (pairs, pairs2) -> {
            if (pairs.isEmpty()) {
                return pairs2;
            }
            if (pairs2.isEmpty()) {
                return pairs;
            }
            Pair last = (Pair)pairs.peekLast();
            Pair first = (Pair)pairs2.peekFirst();
            if (Objects.equals(last.getValue(), first.getValue())) {
                first = (Pair)pairs2.pollFirst();
                last.setValue((Object)((Integer)last.getValue() + (Integer)first.getValue()));
            }
            pairs.addAll(pairs2);
            return pairs;
        }, pairs -> pairs.stream().map(t -> Pair.of((Object)t.getLeft(), (Object)t.getRight())).collect(Collectors.toList()), new Collector.Characteristics[0]);
    }

    public static <E extends Enum<E>> Collector<E, ?, EnumMap<E, Integer>> tabulate(Class<E> clazz) {
        return Collector.of(() -> new int[((Enum[])clazz.getEnumConstants()).length], (array, e) -> {
            int n = e.ordinal();
            array[n] = array[n] + 1;
        }, (array1, array2) -> {
            for (int i = 0; i < ((int[])array2).length; ++i) {
                int n = i;
                array1[n] = array1[n] + array2[i];
            }
            return array1;
        }, array -> {
            EnumMap<Enum, Integer> map = new EnumMap<Enum, Integer>(clazz);
            for (int i = 0; i < ((int[])array).length; ++i) {
                map.put(((Enum[])clazz.getEnumConstants())[i], array[i]);
            }
            return map;
        }, new Collector.Characteristics[0]);
    }

    public static <V> Collector<V, ?, TObjectIntHashMap<V>> tabulate() {
        return Collector.of(TObjectIntHashMap::new, (map, v) -> map.adjustOrPutValue(v, 1, 1), (mapA, mapB) -> {
            mapA.forEachEntry((a, b) -> {
                mapB.adjustOrPutValue(a, b, b);
                return true;
            });
            return mapA;
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, HashMap<K, V>> toHashMap(Function<T, K> getKey, Function<T, V> getValue) {
        return Collector.of(HashMap::new, (kvHashMap, t) -> kvHashMap.put(getKey.apply(t), getValue.apply(t)), (kvHashMap, kvHashMap2) -> {
            kvHashMap.putAll(kvHashMap2);
            return kvHashMap;
        }, new Collector.Characteristics[0]);
    }

    public static <K, V> Collector<K, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> makeMap(Function<K, V> function) {
        return Collector.of(ImmutableMap::builder, (kvBuilder, k) -> kvBuilder.put(k, function.apply(k)), (kvBuilder, kvBuilder2) -> kvBuilder.putAll((Map)kvBuilder2.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]);
    }
}

