/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.integration.jei;

import com.google.common.collect.Lists;
import crazypants.enderio.base.init.ModObject;
import de.lathanael.facadepainter.integration.jei.FacadePaintingRecipeWrapper;
import de.lathanael.facadepainter.network.SyncedConfig;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FacadePaintingRecipeCategory
implements IRecipeCategory<FacadePaintingRecipeWrapper> {
    public static final String UID = "facadepainter.crafting";
    private static final int INPUT_SLOT = 0;
    private static final int FACADE_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int CHAMAELEO_SLOT = 3;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public FacadePaintingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("facadepainter", "textures/gui/jei/facade_painting.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 96, 36);
        this.localizedName = I18n.func_135052_a((String)"gui.facadepainter.jei.facade_painting", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModObject.itemConduitFacade.getItem()));
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Facade Painter";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX > 42 && mouseX < 59 && mouseY > 11 && mouseY < 26) {
            tooltip.add(I18n.func_135052_a((String)"gui.facadepainter.jei.shapeless_recipe", (Object[])new Object[0]));
        }
        return tooltip;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FacadePaintingRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().init(3, true, 0, 18);
        recipeLayout.getItemStacks().init(1, true, 18, 0);
        recipeLayout.getItemStacks().init(2, false, 73, 9);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ItemStack input = (ItemStack)((List)inputs.get(0)).get(0);
        ItemStack facade = (ItemStack)((List)inputs.get(1)).get(0);
        facade.func_77964_b(Short.MAX_VALUE);
        ItemStack chamaeleo_paint = (ItemStack)((List)inputs.get(2)).get(0);
        ItemStack output = (ItemStack)((List)outputs.get(0)).get(0);
        recipeLayout.getItemStacks().set(0, input);
        recipeLayout.getItemStacks().set(1, facade);
        if (SyncedConfig.useChamaeleoPaint) {
            recipeLayout.getItemStacks().set(3, chamaeleo_paint);
        } else {
            recipeLayout.getItemStacks().set(3, ItemStack.field_190927_a);
        }
        recipeLayout.getItemStacks().set(2, output);
    }
}

