/*
 * Decompiled with CFR 0.152.
 */
package de.lathanael.facadepainter.network;

import de.lathanael.facadepainter.FacadePainter;
import de.lathanael.facadepainter.config.Configs;
import de.lathanael.facadepainter.network.SyncedConfig;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketConfigSync
implements IMessage {
    public boolean enableChamaeleoPaint;
    public boolean hideJEIFacadePaintingRecipeCategory;
    public boolean useChamaeleoPaint;
    public boolean enableShapelessClearingRecipe;

    public PacketConfigSync() {
        MinecraftForge.EVENT_BUS.register(PacketConfigSync.class);
        this.enableChamaeleoPaint = Configs.features.enableChamaeleoPaint;
        this.hideJEIFacadePaintingRecipeCategory = Configs.features.hideJEIFacadePaintingRecipeCategory;
        this.useChamaeleoPaint = Configs.recipes.useChamaeleoPaint;
        this.enableShapelessClearingRecipe = Configs.recipes.enableShapelessClearingRecipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.enableChamaeleoPaint = buf.readBoolean();
        this.hideJEIFacadePaintingRecipeCategory = buf.readBoolean();
        this.useChamaeleoPaint = buf.readBoolean();
        this.enableShapelessClearingRecipe = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.enableChamaeleoPaint);
        buf.writeBoolean(this.hideJEIFacadePaintingRecipeCategory);
        buf.writeBoolean(this.useChamaeleoPaint);
        buf.writeBoolean(this.enableShapelessClearingRecipe);
    }

    @SubscribeEvent
    public static void onPlayerLeftServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        FacadePainter.logger.info("Disconnected from server - restoring client side configs");
        SyncedConfig.enableChamaeleoPaint = Configs.features.enableChamaeleoPaint;
        SyncedConfig.hideJEIFacadePaintingRecipeCategory = Configs.features.hideJEIFacadePaintingRecipeCategory;
        SyncedConfig.useChamaeleoPaint = Configs.recipes.useChamaeleoPaint;
        SyncedConfig.enableShapelessClearingRecipe = Configs.recipes.enableShapelessClearingRecipe;
        FacadePainter.logger.info("Disconnected from server - client side configs restored");
    }
}

