/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.vector;

import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class BlockVec3
implements Cloneable {
    public static final BlockVec3 INVALID_VECTOR = new BlockVec3(-1, -1, -1);
    public static int chunkCacheDim = Integer.MAX_VALUE;
    public static int chunkCacheDim_Client = Integer.MAX_VALUE;
    private static Chunk chunkCached;
    private static int chunkCacheX;
    private static int chunkCacheZ;
    private static Chunk chunkCached_Client;
    private static int chunkCacheX_Client;
    private static int chunkCacheZ_Client;
    public int x;
    public int y;
    public int z;
    public int sideDoneBits = 0;

    public BlockVec3() {
        this(0, 0, 0);
    }

    public BlockVec3(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockVec3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockVec3(Entity par1) {
        this.x = (int)Math.floor(par1.field_70165_t);
        this.y = (int)Math.floor(par1.field_70163_u);
        this.z = (int)Math.floor(par1.field_70161_v);
    }

    public BlockVec3(TileEntity par1) {
        this.x = par1.func_174877_v().func_177958_n();
        this.y = par1.func_174877_v().func_177956_o();
        this.z = par1.func_174877_v().func_177952_p();
    }

    public BlockVec3(NBTTagCompound par1NBTTagCompound) {
        this.x = par1NBTTagCompound.func_74762_e("x");
        this.y = par1NBTTagCompound.func_74762_e("y");
        this.z = par1NBTTagCompound.func_74762_e("z");
    }

    public static BlockVec3 add(BlockVec3 par1, BlockVec3 a) {
        return new BlockVec3(par1.x + a.x, par1.y + a.y, par1.z + a.z);
    }

    public static BlockVec3 readFromNBT(NBTTagCompound nbtCompound) {
        BlockVec3 tempVector = new BlockVec3();
        tempVector.x = nbtCompound.func_74762_e("x");
        tempVector.y = nbtCompound.func_74762_e("y");
        tempVector.z = nbtCompound.func_74762_e("z");
        return tempVector;
    }

    public static BlockVec3 readFromNBT(NBTTagCompound par1NBTTagCompound, String prefix) {
        Integer readX = par1NBTTagCompound.func_74762_e(prefix + "_x");
        if (readX == null) {
            return null;
        }
        Integer readY = par1NBTTagCompound.func_74762_e(prefix + "_y");
        if (readY == null) {
            return null;
        }
        Integer readZ = par1NBTTagCompound.func_74762_e(prefix + "_z");
        if (readZ == null) {
            return null;
        }
        return new BlockVec3(readX, readY, readZ);
    }

    public final BlockVec3 clone() {
        return new BlockVec3(this.x, this.y, this.z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public IBlockState getBlockState(World world) {
        if (this.y < 0 || this.y >= 256 || this.x < -30000000 || this.z < -30000000 || this.x >= 30000000 || this.z >= 30000000) {
            return null;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            Chunk chunk;
            if (world.field_72995_K) {
                Chunk chunk2;
                if (chunkCacheX_Client == chunkx && chunkCacheZ_Client == chunkz && chunkCacheDim_Client == world.field_73011_w.getDimension() && chunkCached_Client.func_177410_o()) {
                    return chunkCached_Client.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                chunkCached_Client = chunk2 = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim_Client = world.field_73011_w.getDimension();
                chunkCacheX_Client = chunkx;
                chunkCacheZ_Client = chunkz;
                return chunk2.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.getDimension() && chunkCached.func_177410_o()) {
                return chunkCached.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
            chunkCacheDim = world.field_73011_w.getDimension();
            chunkCacheX = chunkx;
            chunkCacheZ = chunkz;
            return chunk.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_180522_a((BlockPos)new BlockPos(this.x, this.y, this.z)));
            throw new ReportedException(crashreport);
        }
    }

    public IBlockState getBlockState_noChunkLoad(World world) {
        if (this.y < 0 || this.y >= 256 || this.x < -30000000 || this.z < -30000000 || this.x >= 30000000 || this.z >= 30000000) {
            return null;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (world.func_72863_F().func_186026_b(chunkx, chunkz) != null) {
                Chunk chunk;
                if (world.field_72995_K) {
                    Chunk chunk2;
                    if (chunkCacheX_Client == chunkx && chunkCacheZ_Client == chunkz && chunkCacheDim_Client == world.field_73011_w.getDimension() && chunkCached_Client.func_177410_o()) {
                        return chunkCached_Client.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                    }
                    chunkCached_Client = chunk2 = world.func_72964_e(chunkx, chunkz);
                    chunkCacheDim_Client = world.field_73011_w.getDimension();
                    chunkCacheX_Client = chunkx;
                    chunkCacheZ_Client = chunkz;
                    return chunk2.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.getDimension() && chunkCached.func_177410_o()) {
                    return chunkCached.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim = world.field_73011_w.getDimension();
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            return Blocks.field_150357_h.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_180522_a((BlockPos)new BlockPos(this.x, this.y, this.z)));
            throw new ReportedException(crashreport);
        }
    }

    public IBlockState getBlockState(IBlockAccess par1iBlockAccess) {
        return par1iBlockAccess.func_180495_p(new BlockPos(this.x, this.y, this.z));
    }

    @Nullable
    public IBlockState getBlockStateSafe_noChunkLoad(World world) {
        if (this.y < 0 || this.y >= 256) {
            return null;
        }
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        try {
            if (world.func_72863_F().func_186026_b(chunkx, chunkz) != null) {
                Chunk chunk;
                if (world.field_72995_K) {
                    Chunk chunk2;
                    if (chunkCacheX_Client == chunkx && chunkCacheZ_Client == chunkz && chunkCacheDim_Client == world.field_73011_w.getDimension() && chunkCached_Client.func_177410_o()) {
                        return chunkCached_Client.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                    }
                    chunkCached_Client = chunk2 = world.func_72964_e(chunkx, chunkz);
                    chunkCacheDim_Client = world.field_73011_w.getDimension();
                    chunkCacheX_Client = chunkx;
                    chunkCacheZ_Client = chunkz;
                    return chunk2.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.getDimension() && chunkCached.func_177410_o()) {
                    return chunkCached.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
                }
                chunkCached = chunk = world.func_72964_e(chunkx, chunkz);
                chunkCacheDim = world.field_73011_w.getDimension();
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_186032_a(this.x & 0xF, this.y, this.z & 0xF);
            }
            return Blocks.field_150357_h.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Oxygen Sealer thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_180522_a((BlockPos)new BlockPos(this.x, this.y, this.z)));
            throw new ReportedException(crashreport);
        }
    }

    public BlockVec3 translate(BlockVec3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public BlockVec3 translate(int par1x, int par1y, int par1z) {
        this.x += par1x;
        this.y += par1y;
        this.z += par1z;
        return this;
    }

    public BlockVec3 subtract(BlockVec3 par1) {
        this.x -= par1.x;
        this.y -= par1.y;
        this.z -= par1.z;
        return this;
    }

    public BlockVec3 scale(int par1) {
        this.x *= par1;
        this.y *= par1;
        this.z *= par1;
        return this;
    }

    public BlockVec3 modifyPositionFromSide(EnumFacing side, int amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
        return this;
    }

    public BlockVec3 newVecSide(int side) {
        BlockVec3 vec = new BlockVec3(this.x, this.y, this.z);
        vec.sideDoneBits = (1 << (side ^ 1)) + (side << 6);
        switch (side) {
            case 0: {
                --vec.y;
                return vec;
            }
            case 1: {
                ++vec.y;
                return vec;
            }
            case 2: {
                --vec.z;
                return vec;
            }
            case 3: {
                ++vec.z;
                return vec;
            }
            case 4: {
                --vec.x;
                return vec;
            }
            case 5: {
                ++vec.x;
                return vec;
            }
        }
        return vec;
    }

    public BlockVec3 modifyPositionFromSide(EnumFacing side) {
        return this.modifyPositionFromSide(side, 1);
    }

    public int hashCode() {
        return ((this.y * 379 + this.x) * 373 + this.z) * 7;
    }

    public boolean equals(Object o) {
        if (o instanceof BlockVec3) {
            BlockVec3 vector = (BlockVec3)o;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        return false;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_175625_s(new BlockPos(this.x, this.y, this.z));
    }

    public TileEntity getTileEntityOnSide(World world, EnumFacing side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side.ordinal()) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return null;
            }
        }
        BlockPos pos = new BlockPos(x, y, z);
        return world.func_175668_a(pos, false) ? world.func_175625_s(pos) : null;
    }

    public TileEntity getTileEntityOnSide(World world, int side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return null;
            }
        }
        BlockPos pos = new BlockPos(x, y, z);
        return world.func_175668_a(pos, false) ? world.func_175625_s(pos) : null;
    }

    public boolean blockOnSideHasSolidFace(World world, int side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return false;
            }
        }
        BlockPos pos = new BlockPos(x, y, z);
        return world.func_180495_p(pos).func_177230_c().isSideSolid(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.func_82600_a((int)(side ^ 1)));
    }

    public Block getBlockOnSide(World world, int side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return null;
            }
        }
        BlockPos pos = new BlockPos(x, y, z);
        return world.func_175668_a(pos, false) ? world.func_180495_p(pos).func_177230_c() : null;
    }

    public int getBlockMetadata(IBlockAccess world) {
        IBlockState state = world.func_180495_p(new BlockPos(this.x, this.y, this.z));
        return state.func_177230_c().func_176201_c(state);
    }

    public int distanceTo(BlockVec3 vector) {
        int var2 = vector.x - this.x;
        int var4 = vector.y - this.y;
        int var6 = vector.z - this.z;
        return MathHelper.func_76128_c((double)Math.sqrt(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public int distanceSquared(BlockVec3 vector) {
        int var2 = vector.x - this.x;
        int var4 = vector.y - this.y;
        int var6 = vector.z - this.z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("x", this.x);
        par1NBTTagCompound.func_74768_a("y", this.y);
        par1NBTTagCompound.func_74768_a("z", this.z);
        return par1NBTTagCompound;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound, String prefix) {
        par1NBTTagCompound.func_74768_a(prefix + "_x", this.x);
        par1NBTTagCompound.func_74768_a(prefix + "_y", this.y);
        par1NBTTagCompound.func_74768_a(prefix + "_z", this.z);
        return par1NBTTagCompound;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public int getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void setBlock(World worldObj, IBlockState block) {
        worldObj.func_180501_a(new BlockPos(this.x, this.y, this.z), block, 3);
    }

    public boolean blockExists(World world) {
        return world.func_175668_a(new BlockPos(this.x, this.y, this.z), false);
    }

    public void setSideDone(int side) {
        this.sideDoneBits |= 1 << side;
    }

    public TileEntity getTileEntityForce(World world) {
        int chunkx = this.x >> 4;
        int chunkz = this.z >> 4;
        if (world.func_72863_F().func_186026_b(chunkx, chunkz) != null) {
            return world.func_175625_s(this.toBlockPos());
        }
        Chunk chunk = ((ChunkProviderServer)world.func_72863_F()).func_186028_c(chunkx, chunkz);
        return chunk.func_177424_a(new BlockPos(this.x & 0xF, this.y, this.z & 0xF), Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    public Vector3 midPoint() {
        return new Vector3((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    static {
        chunkCacheX = 1876000;
        chunkCacheZ = 1876000;
        chunkCacheX_Client = 1876000;
        chunkCacheZ_Client = 1876000;
    }
}

