/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class SkyProviderOverworld
extends IRenderHandler {
    private static final ResourceLocation moonTexture = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation sunTexture = new ResourceLocation("textures/environment/sun.png");
    private static boolean optifinePresent = false;
    private final int starGLCallList = GLAllocation.func_74526_a((int)7);
    private final int glSkyList;
    private final int glSkyList2;
    private final ResourceLocation planetToRender = new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/earth.png");
    private final Minecraft minecraft = FMLClientHandler.instance().getClient();

    public SkyProviderOverworld() {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        Random rand = new Random(10842L);
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars(worldrenderer, rand);
        tessellator.func_78381_a();
        GL11.glEndList();
        GL11.glNewList((int)(this.starGLCallList + 1), (int)4864);
        this.renderStars(worldrenderer, rand);
        tessellator.func_78381_a();
        GL11.glEndList();
        GL11.glNewList((int)(this.starGLCallList + 2), (int)4864);
        this.renderStars(worldrenderer, rand);
        tessellator.func_78381_a();
        GL11.glEndList();
        GL11.glNewList((int)(this.starGLCallList + 3), (int)4864);
        this.renderStars(worldrenderer, rand);
        tessellator.func_78381_a();
        GL11.glEndList();
        GL11.glNewList((int)(this.starGLCallList + 4), (int)4864);
        this.renderStars(worldrenderer, rand);
        tessellator.func_78381_a();
        GL11.glEndList();
        GL11.glPopMatrix();
        this.glSkyList = this.starGLCallList + 5;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 5;
        int i = 53;
        float f = 16.0f;
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        for (int j = -265; j <= 265; j += 5) {
            for (int l = -265; l <= 265; l += 5) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                worldRenderer.func_181662_b((double)j, (double)f, (double)l).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 5), (double)f, (double)l).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 5), (double)f, (double)(l + 5)).func_181675_d();
                worldRenderer.func_181662_b((double)j, (double)f, (double)(l + 5)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 6;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -265; k <= 265; k += 5) {
            for (int i1 = -265; i1 <= 265; i1 += 5) {
                worldRenderer.func_181662_b((double)(k + 5), (double)f, (double)i1).func_181675_d();
                worldRenderer.func_181662_b((double)k, (double)f, (double)i1).func_181675_d();
                worldRenderer.func_181662_b((double)k, (double)f, (double)(i1 + 5)).func_181675_d();
                worldRenderer.func_181662_b((double)(k + 5), (double)f, (double)(i1 + 5)).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float r;
        float rand1;
        float size;
        float var9;
        float z;
        if (!ClientProxyCore.overworldTextureRequestSent) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, GCCoreUtil.getDimensionID((World)mc.field_71441_e), new Object[0]));
            ClientProxyCore.overworldTextureRequestSent = true;
        }
        double zoom = 0.0;
        double yaw = 0.0;
        double pitch = 0.0;
        Object m = null;
        if (!optifinePresent) {
            try {
                Class<?> c = mc.field_71460_t.getClass();
                zoom = mc.field_71460_t.field_78503_V;
                yaw = mc.field_71460_t.field_78502_W;
                pitch = mc.field_71460_t.field_78509_X;
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                if (zoom != 1.0) {
                    GL11.glTranslatef((float)((float)yaw), (float)((float)(-pitch)), (float)0.0f);
                    GL11.glScaled((double)zoom, (double)zoom, (double)1.0);
                }
                Project.gluPerspective((float)mc.field_71474_y.field_74334_X, (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)1400.0f);
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                mc.field_71460_t.func_78467_g(partialTicks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        float theta = MathHelper.func_76129_c((float)(((float)mc.field_71439_g.field_70163_u - 200.0f) / 1000.0f));
        float var21 = Math.max(1.0f - theta * 4.0f, 0.0f);
        GL11.glDisable((int)3553);
        GlStateManager.func_179101_C();
        Vec3d var2 = this.minecraft.field_71441_e.func_72833_a(this.minecraft.func_175606_aa(), partialTicks);
        float i = (float)var2.field_72450_a * var21;
        float x = (float)var2.field_72448_b * var21;
        float var5 = (float)var2.field_72449_c * var21;
        if (this.minecraft.field_71474_y.field_74337_g) {
            float y = (i * 30.0f + x * 59.0f + var5 * 11.0f) / 100.0f;
            float var7 = (i * 30.0f + x * 70.0f) / 100.0f;
            z = (i * 30.0f + var5 * 70.0f) / 100.0f;
            i = y;
            x = var7;
            var5 = z;
        }
        GL11.glColor3f((float)i, (float)x, (float)var5);
        Tessellator var23 = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = var23.func_178180_c();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)i, (float)x, (float)var5);
        if (mc.field_71439_g.field_70163_u < 214.0) {
            GL11.glCallList((int)this.glSkyList);
        }
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        float[] costh = this.minecraft.field_71441_e.field_73011_w.func_76560_a(this.minecraft.field_71441_e.func_72826_c(partialTicks), partialTicks);
        if (costh != null) {
            float rand3;
            float sunsetModInv = Math.min(1.0f, Math.max(1.0f - theta * 50.0f, 0.0f));
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)this.minecraft.field_71441_e.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            z = costh[0] * sunsetModInv;
            var9 = costh[1] * sunsetModInv;
            size = costh[2] * sunsetModInv;
            if (this.minecraft.field_71474_y.field_74337_g) {
                rand1 = (z * 30.0f + var9 * 59.0f + size * 11.0f) / 100.0f;
                r = (z * 30.0f + var9 * 70.0f) / 100.0f;
                rand3 = (z * 30.0f + size * 70.0f) / 100.0f;
                z = rand1;
                var9 = r;
                size = rand3;
            }
            worldRenderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            worldRenderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(z * sunsetModInv, var9 * sunsetModInv, size * sunsetModInv, costh[3]).func_181675_d();
            int phi = 16;
            for (int var27 = 0; var27 <= 16; ++var27) {
                rand3 = (float)var27 * ((float)Math.PI * 2) / 16.0f;
                float xx = MathHelper.func_76126_a((float)rand3);
                float rand5 = MathHelper.func_76134_b((float)rand3);
                worldRenderer.func_181662_b((double)(xx * 120.0f), (double)(rand5 * 120.0f), (double)(-rand5 * 40.0f * costh[3])).func_181666_a(costh[0] * sunsetModInv, costh[1] * sunsetModInv, costh[2] * sunsetModInv, 0.0f).func_181675_d();
            }
            var23.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        z = 1.0f - this.minecraft.field_71441_e.func_72867_j(partialTicks);
        var9 = 0.0f;
        size = 0.0f;
        rand1 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)z);
        GL11.glTranslatef((float)var9, (float)size, (float)rand1);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.minecraft.field_71441_e.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        double playerHeight = this.minecraft.field_71439_g.field_70163_u;
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Vec3d vec = TransformerHooks.getFogColorHook((World)this.minecraft.field_71441_e);
        float threshold = Math.max(0.1f, (float)vec.func_72433_c() - 0.1f);
        float var20 = ((float)playerHeight - 200.0f) / 1000.0f;
        var20 = MathHelper.func_76129_c((float)var20);
        float bright1 = Math.min(0.9f, var20 * 3.0f);
        if (bright1 > threshold) {
            GL11.glColor4f((float)bright1, (float)bright1, (float)bright1, (float)1.0f);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glCallList((int)(this.starGLCallList + 2));
        GL11.glCallList((int)(this.starGLCallList + 3));
        GL11.glCallList((int)(this.starGLCallList + 4));
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        r = 30.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.field_71446_o.func_110577_a(sunTexture);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-r), 100.0, (double)(-r)).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)r, 100.0, (double)(-r)).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)r, 100.0, (double)r).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(-r), 100.0, (double)r).func_187315_a(0.0, 1.0).func_181675_d();
        var23.func_78381_a();
        r = 40.0f;
        this.minecraft.field_71446_o.func_110577_a(moonTexture);
        float sinphi = this.minecraft.field_71441_e.func_72853_d();
        int cosphi = (int)(sinphi % 4.0f);
        int var29 = (int)(sinphi / 4.0f % 2.0f);
        float yy = (float)cosphi / 4.0f;
        float rand7 = (float)var29 / 2.0f;
        float zz = (float)(cosphi + 1) / 4.0f;
        float rand9 = (float)(var29 + 1) / 2.0f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-r), -100.0, (double)r).func_187315_a((double)zz, (double)rand9).func_181675_d();
        worldRenderer.func_181662_b((double)r, -100.0, (double)r).func_187315_a((double)yy, (double)rand9).func_181675_d();
        worldRenderer.func_181662_b((double)r, -100.0, (double)(-r)).func_187315_a((double)yy, (double)rand7).func_181675_d();
        worldRenderer.func_181662_b((double)(-r), -100.0, (double)(-r)).func_187315_a((double)zz, (double)rand7).func_181675_d();
        var23.func_78381_a();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double var25 = playerHeight - 64.0;
        if (var25 > (double)(this.minecraft.field_71474_y.field_151451_c * 16)) {
            float sinth = Math.max(Math.min((theta *= 400.0f) / 100.0f - 0.2f, 0.5f), 0.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2912);
            float scale = 850.0f * (0.25f - theta / 10000.0f);
            scale = Math.max(scale, 0.2f);
            GL11.glScalef((float)scale, (float)1.0f, (float)scale);
            GL11.glTranslatef((float)0.0f, (float)(-((float)mc.field_71439_g.field_70163_u)), (float)0.0f);
            this.minecraft.field_71446_o.func_110577_a(this.planetToRender);
            size = 1.0f;
            GL11.glColor4f((float)sinth, (float)sinth, (float)sinth, (float)1.0f);
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double zoomIn = 0.0;
            double cornerB = 1.0 - zoomIn;
            worldRenderer.func_181662_b((double)(-size), 0.0, (double)size).func_187315_a(zoomIn, cornerB).func_181675_d();
            worldRenderer.func_181662_b((double)size, 0.0, (double)size).func_187315_a(cornerB, cornerB).func_181675_d();
            worldRenderer.func_181662_b((double)size, 0.0, (double)(-size)).func_187315_a(cornerB, zoomIn).func_181675_d();
            worldRenderer.func_181662_b((double)(-size), 0.0, (double)(-size)).func_187315_a(zoomIn, zoomIn).func_181675_d();
            var23.func_78381_a();
            GL11.glDisable((int)3553);
            GL11.glPopMatrix();
        }
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        if (!optifinePresent) {
            try {
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                if (zoom != 1.0) {
                    GL11.glTranslatef((float)((float)yaw), (float)((float)(-pitch)), (float)0.0f);
                    GL11.glScaled((double)zoom, (double)zoom, (double)1.0);
                }
                Project.gluPerspective((float)mc.field_71474_y.field_74334_X, (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)((float)(this.minecraft.field_71474_y.field_151451_c * 16) * 2.0f));
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                mc.field_71460_t.func_78467_g(partialTicks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GL11.glEnable((int)2903);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    private void renderStars(BufferBuilder worldRenderer, Random rand) {
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < (ConfigManagerCore.moreStars ? 4000 : 1200); ++i) {
            double x = rand.nextFloat() * 2.0f - 1.0f;
            double y = rand.nextFloat() * 2.0f - 1.0f;
            double z = rand.nextFloat() * 2.0f - 1.0f;
            double size = 0.15f + rand.nextFloat() * 0.1f;
            double r = x * x + y * y + z * z;
            if (!(r < 1.0) || !(r > 0.01)) continue;
            r = 1.0 / Math.sqrt(r);
            y *= r;
            double xx = (x *= r) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 100.0 + 150.0 : 100.0);
            double zz = (z *= r) * (ConfigManagerCore.moreStars ? rand.nextDouble() * 100.0 + 150.0 : 100.0);
            if (Math.abs(xx) < 29.0 && Math.abs(zz) < 29.0) continue;
            double yy = y * (ConfigManagerCore.moreStars ? rand.nextDouble() * 100.0 + 150.0 : 100.0);
            double theta = Math.atan2(x, z);
            double sinth = Math.sin(theta);
            double costh = Math.cos(theta);
            double phi = Math.atan2(Math.sqrt(x * x + z * z), y);
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double rho = rand.nextDouble() * Math.PI * 2.0;
            double sinrho = Math.sin(rho);
            double cosrho = Math.cos(rho);
            for (int j = 0; j < 4; ++j) {
                double a = 0.0;
                double b = (double)((j & 2) - 1) * size;
                double c = (double)((j + 1 & 2) - 1) * size;
                double d = b * cosrho - c * sinrho;
                double e = c * cosrho + b * sinrho;
                double dy = d * sinphi + 0.0 * cosphi;
                double ff = 0.0 * sinphi - d * cosphi;
                double dx = ff * sinth - e * costh;
                double dz = e * sinth + ff * costh;
                worldRenderer.func_181662_b(xx + dx, yy + dy, zz + dz).func_181675_d();
            }
        }
    }

    static {
        try {
            optifinePresent = Launch.classLoader.getClassBytes("CustomColorizer") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

