/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGenericHandler;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemCanisterGeneric
extends ItemFluidContainer {
    public static final int EMPTY = 1001;
    private static final boolean isTELoaded = CompatibilityManager.isTELoaded();
    private String allowedFluid = null;

    public ItemCanisterGeneric(String assetName) {
        super(1000);
        this.func_77656_e(1001);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(assetName);
        this.func_77627_a(true);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCanisterGenericHandler(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GalacticraftCore.galacticraftItemsTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (isTELoaded && JavaUtil.instance.isCalledBy("thermalexpansion.block.machine.TileTransposer")) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(this.func_77668_q(), 1, 1001);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (1001 == par1ItemStack.func_77952_i()) {
            par1ItemStack.func_77982_d(null);
        } else if (par1ItemStack.func_77952_i() <= 0) {
            par1ItemStack.func_77964_b(1);
        }
    }

    public String getAllowedFluid() {
        return this.allowedFluid;
    }

    public void setAllowedFluid(String name) {
        this.allowedFluid = name;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || resource.amount <= 0 || container == null || container.func_77952_i() <= 1 || !(container.func_77973_b() instanceof ItemCanisterGeneric)) {
            return 0;
        }
        String fluidName = resource.getFluid().getName();
        int capacityPlusOne = container.func_77952_i();
        if (capacityPlusOne <= 1) {
            if (capacityPlusOne < 1) {
                container.func_77964_b(1);
            }
            return 0;
        }
        if (capacityPlusOne >= 1001) {
            for (ItemCanisterGeneric i : GCItems.canisterTypes) {
                if (!fluidName.equalsIgnoreCase(i.allowedFluid)) continue;
                if (!doFill) {
                    return Math.min(resource.amount, this.capacity);
                }
                this.replaceEmptyCanisterItem(container, (Item)i);
                break;
            }
            if (capacityPlusOne > 1001) {
                capacityPlusOne = 1001;
                container.func_77964_b(capacityPlusOne);
            }
        }
        if (fluidName.equalsIgnoreCase(((ItemCanisterGeneric)container.func_77973_b()).allowedFluid)) {
            int added = Math.min(resource.amount, capacityPlusOne - 1);
            if (doFill && added > 0) {
                container.func_77964_b(Math.max(1, container.func_77952_i() - added));
            }
            return added;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.allowedFluid == null || container.func_77952_i() >= 1001) {
            return null;
        }
        FluidStack used = this.getFluid(container);
        if (used != null && used.amount > maxDrain) {
            used.amount = maxDrain;
        }
        if (doDrain && used != null && used.amount > 0) {
            this.setNewDamage(container, container.func_77952_i() + used.amount);
        }
        return used;
    }

    protected void setNewDamage(ItemStack container, int newDamage) {
        newDamage = Math.min(newDamage, 1001);
        container.func_77964_b(newDamage);
        if (newDamage == 1001) {
            // empty if block
        }
    }

    private void replaceEmptyCanisterItem(ItemStack container, Item newItem) {
        try {
            Class<?> itemStack = container.getClass();
            Field itemId = itemStack.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "item" : "field_151002_e");
            itemId.setAccessible(true);
            itemId.set(container, newItem);
            Method forgeInit = itemStack.getDeclaredMethod("forgeInit", new Class[0]);
            forgeInit.setAccessible(true);
            forgeInit.invoke((Object)container, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FluidStack getFluid(ItemStack container) {
        String fluidName = ((ItemCanisterGeneric)container.func_77973_b()).allowedFluid;
        if (fluidName == null || container.func_77952_i() >= 1001) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, 1001 - container.func_77952_i());
    }
}

