/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.FluidTankGC;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.DelayTimer;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFluidTank
extends TileEntityAdvanced
implements IFluidHandlerWrapper {
    private final DelayTimer delayTimer = new DelayTimer(1L);
    public FluidTankGC fluidTank = new FluidTankGC(16000, this);
    public boolean updateClient = false;
    private AxisAlignedBB renderAABB;

    public TileEntityFluidTank() {
        super("tile.fluid_tank.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public void onBreak() {
        if (this.fluidTank.getFluidAmount() > 0) {
            Block b;
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(this.fluidTank.getFluid(), this.field_145850_b, this.field_174879_c));
            if (!this.field_145850_b.field_72995_K && this.fluidTank.getFluidAmount() > 1000 && (b = this.fluidTank.getFluid().getFluid().getBlock()) != null && !(b instanceof BlockAir)) {
                TickHandlerServer.scheduleNewBlockChange(GCCoreUtil.getDimensionID(this.field_145850_b), new ScheduledBlockChange(this.field_174879_c, b.func_176203_a(0), 3));
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.fluidTank.getFluid() != null) {
            this.moveFluidDown();
        }
        if (!this.field_145850_b.field_72995_K && this.updateClient && this.delayTimer.markTimeIfDelay(this.field_145850_b)) {
            PacketDynamic packet = new PacketDynamic(this);
            GalacticraftCore.packetPipeline.sendToAllAround(packet, new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_145850_b), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.getPacketRange()));
            this.updateClient = false;
        }
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        int totalUsed = 0;
        TileEntityFluidTank toFill = this.getLastTank();
        FluidStack fluid = toFill.fluidTank.getFluid();
        if (fluid != null && fluid.amount > 0 && !fluid.isFluidEqual(copy)) {
            return 0;
        }
        while (toFill != null && copy.amount > 0) {
            int used = toFill.fluidTank.fill(copy, doFill);
            if (used > 0) {
                toFill.updateClient = true;
            }
            copy.amount -= used;
            totalUsed += used;
            toFill = this.getNextTank(toFill.func_174877_v());
        }
        return totalUsed;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        TileEntityFluidTank last = this.getLastTank();
        if (!resource.isFluidEqual(last.fluidTank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        TileEntityFluidTank last = this.getLastTank();
        FluidStack stack = last.fluidTank.drain(maxDrain, doDrain);
        if (doDrain && stack != null && stack.amount > 0) {
            last.updateClient = true;
        }
        return stack;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == null || fluid == null || this.fluidTank.getFluid().getFluid() == fluid;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return fluid == null || this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == fluid;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTank compositeTank = new FluidTank(this.fluidTank.getCapacity());
        TileEntityFluidTank last = this.getLastTank();
        if (last == null || last.fluidTank.getFluid() == null) {
            return new FluidTankInfo[]{compositeTank.getInfo()};
        }
        compositeTank.setFluid(last.fluidTank.getFluid().copy());
        int capacity = last.fluidTank.getCapacity();
        last = this.getNextTank(last.func_174877_v());
        while (last != null) {
            FluidStack fluid = last.fluidTank.getFluid();
            if (fluid != null && fluid.amount != 0) {
                if (!compositeTank.getFluid().isFluidEqual(fluid)) break;
                compositeTank.getFluid().amount += fluid.amount;
            }
            capacity += last.fluidTank.getCapacity();
            last = this.getNextTank(last.func_174877_v());
        }
        compositeTank.setCapacity(capacity);
        return new FluidTankInfo[]{compositeTank.getInfo()};
    }

    public void moveFluidDown() {
        int used;
        TileEntityFluidTank next = this.getPreviousTank(this.func_174877_v());
        if (next != null && (used = next.fluidTank.fill(this.fluidTank.getFluid(), true)) > 0) {
            this.updateClient = true;
            next.updateClient = true;
            this.fluidTank.drain(used, true);
        }
    }

    public TileEntityFluidTank getLastTank() {
        TileEntityFluidTank tank;
        TileEntityFluidTank lastTank = this;
        while ((tank = this.getPreviousTank(lastTank.func_174877_v())) != null) {
            lastTank = tank;
        }
        return lastTank;
    }

    public TileEntityFluidTank getNextTank(BlockPos current) {
        TileEntity above = this.field_145850_b.func_175625_s(current.func_177984_a());
        if (above instanceof TileEntityFluidTank) {
            return (TileEntityFluidTank)above;
        }
        return null;
    }

    public TileEntityFluidTank getPreviousTank(BlockPos current) {
        TileEntity below = this.field_145850_b.func_175625_s(current.func_177977_b());
        if (below instanceof TileEntityFluidTank) {
            return (TileEntityFluidTank)below;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("fuelTank")) {
            this.fluidTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        this.updateClient = GCCoreUtil.getEffectiveSide() == Side.SERVER;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.fluidTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("net-type", "desc-packet");
        PacketDynamic packet = new PacketDynamic(this);
        ByteBuf buf = Unpooled.buffer();
        packet.encodeInto(buf);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        nbt.func_74773_a("net-data", bytes);
        SPacketUpdateTileEntity tileUpdate = new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
        return tileUpdate;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (pkt.func_148857_g() == null) {
            throw new RuntimeException("[GC] Missing NBTTag compound!");
        }
        NBTTagCompound nbt = pkt.func_148857_g();
        try {
            if ("desc-packet".equals(nbt.func_74779_i("net-type"))) {
                byte[] bytes = nbt.func_74770_j("net-data");
                ByteBuf data = Unpooled.wrappedBuffer((byte[])bytes);
                PacketDynamic packet = new PacketDynamic();
                packet.decodeInto(data);
                packet.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("[GC] Failed to read a packet! (" + nbt.func_74781_a("net-type") + ", " + nbt.func_74781_a("net-data"), t);
        }
    }

    @Override
    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.fluidTank == null) {
                networkedList.add(0);
                networkedList.add("");
                networkedList.add(0);
            } else {
                networkedList.add(this.fluidTank.getCapacity());
                networkedList.add(this.fluidTank.getFluid() == null ? "" : this.fluidTank.getFluid().getFluid().getName());
                networkedList.add(this.fluidTank.getFluidAmount());
            }
        }
    }

    @Override
    public void readExtraNetworkedData(ByteBuf buffer) {
        if (this.field_145850_b.field_72995_K) {
            int capacity = buffer.readInt();
            String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            FluidTankGC fluidTank = new FluidTankGC(capacity, this);
            int amount = buffer.readInt();
            if (fluidName.equals("")) {
                fluidTank.setFluid(null);
            } else {
                Fluid fluid = FluidRegistry.getFluid((String)fluidName);
                fluidTank.setFluid(new FluidStack(fluid, amount));
            }
            this.fluidTank = fluidTank;
        }
    }

    @Override
    public double getPacketRange() {
        return 40.0;
    }

    @Override
    public int getPacketCooldown() {
        return 1;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

