/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenDistributor;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProviderColored;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOxygenDistributor
extends TileEntityOxygen
implements IBubbleProviderColored {
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    public boolean active;
    public boolean lastActive;
    public float bubbleSize;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityOxygenDistributor() {
        super("container.oxygendistributor.name", 6000, 8);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim(this));
        }
    }

    @Override
    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim(this));
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            int bubbleR = MathHelper.func_76123_f((float)this.bubbleSize);
            int bubbleR2 = (int)(this.bubbleSize * this.bubbleSize);
            int xMin = this.func_174877_v().func_177958_n() - bubbleR;
            int xMax = this.func_174877_v().func_177958_n() + bubbleR;
            int yMin = this.func_174877_v().func_177956_o() - bubbleR;
            int yMax = this.func_174877_v().func_177956_o() + bubbleR;
            int zMin = this.func_174877_v().func_177952_p() - bubbleR;
            int zMax = this.func_174877_v().func_177952_p() + bubbleR;
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    for (int y = yMin; y < yMax; ++y) {
                        IBlockState state = new BlockVec3(x, y, z).getBlockState(this.field_145850_b);
                        if (state == null || !(state.func_177230_c() instanceof IOxygenReliantBlock) || this.getDistanceFromServer(x, y, z) > bubbleR2) continue;
                        this.field_145850_b.func_175684_a(new BlockPos(x, y, z), state.func_177230_c(), 0);
                    }
                }
            }
            loadedTiles.remove(new BlockVec3Dim(this));
        }
        super.func_145843_s();
    }

    @Override
    public double getPacketRange() {
        return 64.0;
    }

    @Override
    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            if (this.field_145850_b.func_73046_m().func_71262_S()) {
                networkedList.add(loadedTiles.size());
                for (BlockVec3Dim distributor : loadedTiles) {
                    if (distributor == null) {
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        continue;
                    }
                    networkedList.add(distributor.x);
                    networkedList.add(distributor.y);
                    networkedList.add(distributor.z);
                    networkedList.add(distributor.dim);
                }
            } else {
                networkedList.add(-1);
            }
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() - this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() - this.bubbleSize), (double)((float)this.func_174877_v().func_177958_n() + this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() + this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() + this.bubbleSize));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    @Override
    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            int size = dataStream.readInt();
            if (size >= 0) {
                loadedTiles.clear();
                for (int i = 0; i < size; ++i) {
                    int i1 = dataStream.readInt();
                    int i2 = dataStream.readInt();
                    int i3 = dataStream.readInt();
                    int i4 = dataStream.readInt();
                    if (i1 == -1 && i2 == -1 && i3 == -1 && i4 == -1) continue;
                    loadedTiles.add(new BlockVec3Dim(i1, i2, i3, i4));
                }
            }
            this.bubbleSize = dataStream.readFloat();
        }
    }

    public int getDistanceFromServer(int par1, int par3, int par5) {
        int d3 = this.func_174877_v().func_177958_n() - par1;
        int d4 = this.func_174877_v().func_177956_o() - par3;
        int d5 = this.func_174877_v().func_177952_p() - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    @Override
    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(1)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.bubbleSize = this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun && this.getOxygenStored() > this.oxygenPerTick ? (this.bubbleSize += 0.01f) : (this.bubbleSize -= 0.1f);
            this.bubbleSize = Math.min(Math.max(this.bubbleSize, 0.0f), 16.0f);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.active = this.bubbleSize >= 1.0f && this.hasEnoughEnergyToRun && this.getOxygenStored() > this.oxygenPerTick;
            if (this.ticks % (this.active ? 20 : 4) == 0) {
                double size = this.bubbleSize;
                int bubbleR = MathHelper.func_76128_c((double)size) + 4;
                int bubbleR2 = (int)(size * size);
                for (int x = this.func_174877_v().func_177958_n() - bubbleR; x <= this.func_174877_v().func_177958_n() + bubbleR; ++x) {
                    for (int y = this.func_174877_v().func_177956_o() - bubbleR; y <= this.func_174877_v().func_177956_o() + bubbleR; ++y) {
                        for (int z = this.func_174877_v().func_177952_p() - bubbleR; z <= this.func_174877_v().func_177952_p() + bubbleR; ++z) {
                            BlockPos pos = new BlockPos(x, y, z);
                            IBlockState state = this.field_145850_b.func_180495_p(pos);
                            Block block = state.func_177230_c();
                            if (!(block instanceof IOxygenReliantBlock)) continue;
                            if (this.getDistanceFromServer(x, y, z) <= bubbleR2) {
                                ((IOxygenReliantBlock)block).onOxygenAdded(this.field_145850_b, pos, state);
                                continue;
                            }
                            this.field_145850_b.func_175684_a(pos, block, 0);
                        }
                    }
                }
            }
        }
        this.lastActive = this.active;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
        if (nbt.func_74764_b("bubbleSize")) {
            this.bubbleSize = nbt.func_74760_g("bubbleSize");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
        nbt.func_74776_a("bubbleSize", this.bubbleSize);
        return nbt;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
                case 1: {
                    return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItemEmpty(itemstack);
            }
            case 1: {
                return itemstack.func_77973_b() instanceof IItemOxygenSupply && itemstack.func_77952_i() == itemstack.func_77958_k();
            }
        }
        return false;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemOxygenSupply;
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.getOxygenStored() > this.oxygenPerTick;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenDistributor) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockOxygenDistributor.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return null;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public boolean shouldUseOxygen() {
        return this.hasEnoughEnergyToRun;
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean inBubble(double pX, double pY, double pZ) {
        double r = this.bubbleSize;
        r *= r;
        double d3 = (double)this.func_174877_v().func_177958_n() + 0.5 - pX;
        if ((d3 *= d3) > r) {
            return false;
        }
        double d4 = (double)this.func_174877_v().func_177952_p() + 0.5 - pZ;
        if (d3 + (d4 *= d4) > r) {
            return false;
        }
        double d5 = (double)this.func_174877_v().func_177956_o() + 0.5 - pY;
        return d3 + d4 + d5 * d5 < r;
    }

    @Override
    public float getBubbleSize() {
        return this.bubbleSize;
    }

    @Override
    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }

    @Override
    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    @Override
    public Vector3 getColor() {
        return new Vector3(0.125, 0.125, 0.5);
    }
}

