/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenSealer;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.fluid.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.fluid.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityOxygenSealer
extends TileEntityOxygen
implements ITileClientUpdates {
    private static final int UNSEALED_OXYGENPERTICK = 12;
    public static int countEntities = 0;
    public static ArrayList<TileEntityOxygenSealer> loadedTiles = new ArrayList();
    private static int countTemp = 0;
    private static boolean sealerCheckedThisTick = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean sealed;
    public boolean lastSealed = false;
    public boolean lastDisabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean active;
    public ThreadFindSeal threadSeal;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int stopSealThreadCooldown;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int threadCooldownTotal;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean calculatingSealed;
    public List<BlockVec3> leaksClient;

    public TileEntityOxygenSealer() {
        super("container.oxygensealer.name", 10000, 12);
        this.noRedstoneControl = true;
        this.storage.setMaxExtract(5.0f);
        this.storage.setMaxReceive(25.0f);
        this.storage.setCapacity(32000.0f);
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public static void onServerTick() {
        countEntities = countTemp;
        countTemp = 0;
        sealerCheckedThisTick = false;
    }

    public static HashMap<BlockVec3, TileEntityOxygenSealer> getSealersAround(World world, BlockPos pos, int rSquared) {
        HashMap<BlockVec3, TileEntityOxygenSealer> ret = new HashMap<BlockVec3, TileEntityOxygenSealer>();
        for (TileEntityOxygenSealer tile : new ArrayList<TileEntityOxygenSealer>(loadedTiles)) {
            if (tile == null || tile.func_145831_w() != world || !(tile.func_145835_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < (double)rSquared)) continue;
            ret.put(new BlockVec3(tile.func_174877_v()), tile);
        }
        return ret;
    }

    public static TileEntityOxygenSealer getNearestSealer(World world, double x, double y, double z) {
        TileEntityOxygenSealer ret = null;
        double dist = 9216.0;
        for (Object tile : world.field_147482_g) {
            double testDist;
            if (!(tile instanceof TileEntityOxygenSealer) || !((testDist = ((TileEntityOxygenSealer)tile).func_145835_a(x, y, z)) < dist)) continue;
            dist = testDist;
            ret = (TileEntityOxygenSealer)tile;
        }
        return ret;
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            if (!loadedTiles.contains(this)) {
                loadedTiles.add(this);
            }
            this.stopSealThreadCooldown = 126 + countEntities;
        } else {
            this.clientOnLoad();
        }
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(this);
        }
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(this);
        }
        super.onChunkUnload();
    }

    public int getScaledThreadCooldown(int i) {
        if (this.active) {
            return Math.min(i, (int)Math.floor((double)(this.stopSealThreadCooldown * i) / (double)this.threadCooldownTotal));
        }
        return 0;
    }

    public int getFindSealChecks() {
        if (!this.active || this.getOxygenStored() < this.oxygenPerTick || !this.hasEnoughEnergyToRun) {
            return 0;
        }
        BlockPos posAbove = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p());
        IBlockState stateAbove = this.field_145850_b.func_180495_p(posAbove);
        if (!stateAbove.func_177230_c().isAir(stateAbove, (IBlockAccess)this.field_145850_b, posAbove) && !OxygenPressureProtocol.canBlockPassAir(this.field_145850_b, stateAbove.func_177230_c(), this.func_174877_v().func_177984_a(), EnumFacing.UP)) {
            return 0;
        }
        return 1250;
    }

    public boolean thermalControlEnabled() {
        ItemStack oxygenItemStack = this.func_70301_a(2);
        return oxygenItemStack != null && oxygenItemStack.func_77973_b() == GCItems.basicItem && oxygenItemStack.func_77952_i() == 20 && this.hasEnoughEnergyToRun && !this.disabled;
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack oxygenItemStack = this.func_70301_a(1);
            if (oxygenItemStack != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
                IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
                int oxygenDraw = (int)Math.floor(Math.min(30.0f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
                this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
                if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                    this.setOxygenStored(this.getOxygenStored());
                }
            }
            if (this.thermalControlEnabled()) {
                if (this.storage.getMaxExtract() != 20.0f) {
                    this.storage.setMaxExtract(20.0f);
                }
            } else if (this.storage.getMaxExtract() != 5.0f) {
                this.storage.setMaxExtract(5.0f);
                this.storage.setMaxReceive(25.0f);
            }
        }
        this.oxygenPerTick = this.sealed ? 2 : 12;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++countTemp;
            boolean bl = this.active = this.getOxygenStored() >= 1 && this.hasEnoughEnergyToRun && !this.disabled;
            if (this.disabled != this.lastDisabled) {
                this.lastDisabled = this.disabled;
                if (!this.disabled) {
                    this.stopSealThreadCooldown = this.threadCooldownTotal * 3 / 5;
                }
            }
            if (this.stopSealThreadCooldown > 0) {
                --this.stopSealThreadCooldown;
            } else if (!sealerCheckedThisTick) {
                this.threadCooldownTotal = this.stopSealThreadCooldown = 75 + countEntities;
                if (this.active || this.sealed) {
                    sealerCheckedThisTick = true;
                    OxygenPressureProtocol.updateSealerStatus(this);
                }
            }
            if (this.threadSeal != null) {
                if (this.threadSeal.looping.get()) {
                    this.calculatingSealed = this.active;
                } else {
                    this.calculatingSealed = false;
                    this.sealed = this.threadSeal.sealedFinal.get();
                }
            } else {
                this.calculatingSealed = true;
            }
            this.lastSealed = this.sealed;
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
                case 1: {
                    return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
                }
                case 2: {
                    return itemstack.func_77973_b() == GCItems.basicItem && itemstack.func_77952_i() == 20;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItemEmpty(itemstack);
            }
            case 1: {
                return FluidUtil.isEmptyContainer(itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IItemOxygenSupply;
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() == GCItems.basicItem && itemstack.func_77952_i() == 20;
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.getOxygenStored() > this.oxygenPerTick && !this.getDisabled(0);
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenSealer) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockOxygenSealer.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public boolean shouldUseOxygen() {
        return this.hasEnoughEnergyToRun && this.active;
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.of(this.getElectricInputDirection().func_176734_d());
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public void sendUpdateToClient(EntityPlayerMP player) {
        if (this.sealed || this.threadSeal == null || this.threadSeal.leakTrace == null || this.threadSeal.leakTrace.isEmpty()) {
            return;
        }
        Integer[] data = new Integer[this.threadSeal.leakTrace.size()];
        int index = 0;
        for (BlockVec3 vec : this.threadSeal.leakTrace) {
            int dx = vec.x - this.field_174879_c.func_177958_n() + 128;
            int dz = vec.z - this.field_174879_c.func_177952_p() + 128;
            int dy = vec.y;
            int composite = dx < 0 || dx > 255 || dz < 0 || dz > 255 || dy < 0 ? -1 : dz + (dy + (dx << 8) << 8);
            data[index++] = composite;
        }
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_LEAK_DATA, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{this.func_174877_v(), data}), player);
    }

    @Override
    public void buildDataPacket(int[] data) {
    }

    @Override
    public void updateClient(List<Object> data) {
        this.leaksClient = new ArrayList<BlockVec3>();
        if (data.size() > 1) {
            for (int i = 1; i < data.size(); ++i) {
                int comp = (Integer)data.get(i);
                if (comp < 0) continue;
                int dx = (comp >> 16) - 128;
                int dy = comp >> 8 & 0xFF;
                int dz = (comp & 0xFF) - 128;
                this.leaksClient.add(new BlockVec3(this.field_174879_c.func_177958_n() + dx, dy, this.field_174879_c.func_177952_p() + dz));
            }
        }
    }

    public List<BlockVec3> getLeakTraceClient() {
        this.clientOnLoad();
        return this.leaksClient;
    }
}

