/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.entity.IEntityNoisy;
import micdoodle8.mods.galacticraft.api.entity.ITelemetry;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockSpaceGlass;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.client.sounds.SoundUpdaterMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EntityAstroMiner
extends Entity
implements IInventory,
IPacketReceiver,
IEntityNoisy,
IAntiGrav,
ITelemetry {
    public static final int MINE_LENGTH = 24;
    public static final int MINE_LENGTH_AST = 12;
    public static final int AISTATE_OFFLINE = -1;
    public static final int AISTATE_STUCK = 0;
    public static final int AISTATE_ATBASE = 1;
    public static final int AISTATE_TRAVELLING = 2;
    public static final int AISTATE_MINING = 3;
    public static final int AISTATE_RETURNING = 4;
    public static final int AISTATE_DOCKING = 5;
    public static final int FAIL_BASEDESTROYED = 3;
    public static final int FAIL_OUTOFENERGY = 4;
    public static final int FAIL_RETURNPATHBLOCKED = 5;
    public static final int FAIL_ANOTHERWASLINKED = 8;
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityAstroMiner.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final int MAXENERGY = 12000;
    private static final int RETURNENERGY = 1000;
    private static final int RETURNDROPS = 10;
    private static final int INV_SIZE = 227;
    private static final float cLENGTH = 2.6f;
    private static final float cWIDTH = 1.8f;
    private static final float cHEIGHT = 1.7f;
    private static final double SPEEDUP = 2.5;
    private static final BlockVec3[] headings = new BlockVec3[]{new BlockVec3(0, -1, 0), new BlockVec3(0, 1, 0), new BlockVec3(0, 0, -1), new BlockVec3(0, 0, 1), new BlockVec3(-1, 0, 0), new BlockVec3(1, 0, 0)};
    private static final BlockVec3[] headings2 = new BlockVec3[]{new BlockVec3(0, -3, 0), new BlockVec3(0, 2, 0), new BlockVec3(0, 0, -3), new BlockVec3(0, 0, 2), new BlockVec3(-3, 0, 0), new BlockVec3(2, 0, 0)};
    private static final ArrayList<Block> noMineList = new ArrayList();
    public static BlockTuple blockingBlock = new BlockTuple(Blocks.field_150350_a, 0);
    private final boolean TEMPDEBUG = false;
    private final boolean TEMPFAST = false;
    private final LinkedList<BlockVec3> wayPoints = new LinkedList();
    private final LinkedList<BlockVec3> minePoints = new LinkedList();
    private final int baseSafeRadius = 32;
    private final double speedbase = 0.022;
    private double speed = 0.022;
    private final float rotSpeedBase = 1.5f;
    private float rotSpeed = 1.5f;
    public NonNullList<ItemStack> stacks;
    public int energyLevel;
    public int mineCount = 0;
    public float targetYaw;
    public float targetPitch;
    public int AIstate;
    public int timeInCurrentState = 0;
    public EntityPlayerMP playerMP = null;
    public EnumFacing facing;
    public float shipDamage;
    public int currentDamage;
    public int timeSinceHit;
    public boolean stopForTurn;
    public LinkedList<BlockVec3> laserBlocks = new LinkedList();
    public LinkedList<Integer> laserTimes = new LinkedList();
    public float retraction = 1.0f;
    protected ITickable soundUpdater;
    private UUID playerUUID;
    private BlockVec3 posTarget;
    private BlockVec3 posBase;
    private BlockVec3 waypointBase;
    private BlockVec3 minePointCurrent = null;
    private EnumFacing baseFacing;
    private EnumFacing facingAI;
    private EnumFacing lastFacing;
    private double speedup = 2.5;
    private boolean noSpeedup = false;
    private boolean flagLink = false;
    private boolean flagCheckPlayer = false;
    private boolean toAddToServer = AsteroidsTickHandlerServer.loadingSavedChunks.get();
    private int turnProgress;
    private double minecartX;
    private double minecartY;
    private double minecartZ;
    private double minecartYaw;
    private double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private int tryBlockLimit;
    private int inventoryDrops;
    private int givenFailMessage = 0;
    private BlockVec3 mineLast = null;
    private int mineCountDown = 0;
    private int pathBlockedCount = 0;
    private boolean soundToStop = false;
    private boolean spawnedInCreative = false;
    private int serverIndex;

    public EntityAstroMiner(World world, NonNullList<ItemStack> cargo, int energy) {
        this(world);
        this.toAddToServer = true;
        this.stacks = cargo;
        this.energyLevel = energy;
    }

    public EntityAstroMiner(World world) {
        super(world);
        this.facing = EnumFacing.NORTH;
        this.field_70156_m = true;
        this.field_70158_ak = true;
        this.field_70178_ae = true;
        this.field_70130_N = 2.6f;
        this.field_70131_O = 1.8f;
        this.func_70105_a(2.6f, 1.8f);
        this.field_70145_X = true;
        if (world != null && world.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketDynamic((Entity)this));
        }
    }

    public static boolean spawnMinerAtBase(World world, int x, int y, int z, EnumFacing facing, BlockVec3 base, EntityPlayerMP player) {
        if (world.field_72995_K) {
            return true;
        }
        EntityAstroMiner miner = new EntityAstroMiner(world, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)227, (Object)ItemStack.field_190927_a), 0);
        miner.setPlayer(player);
        if (player.field_71075_bZ.field_75098_d) {
            miner.spawnedInCreative = true;
        }
        miner.waypointBase = new BlockVec3(x, y, z).modifyPositionFromSide(facing, 1);
        miner.func_70107_b(miner.waypointBase.x, miner.waypointBase.y - 1, miner.waypointBase.z);
        miner.baseFacing = facing;
        miner.facingAI = facing;
        miner.lastFacing = facing;
        miner.field_70159_w = 0.0;
        miner.field_70181_x = 0.0;
        miner.field_70179_y = 0.0;
        miner.targetPitch = 0.0f;
        switch (facing) {
            case NORTH: {
                miner.targetYaw = 180.0f;
                break;
            }
            case SOUTH: {
                miner.targetYaw = 0.0f;
                break;
            }
            case WEST: {
                miner.targetYaw = 270.0f;
                break;
            }
            case EAST: {
                miner.targetYaw = 90.0f;
            }
        }
        miner.field_70125_A = miner.targetPitch;
        miner.field_70177_z = miner.targetYaw;
        miner.setBoundingBoxForFacing();
        miner.AIstate = 1;
        miner.posBase = base;
        double d = miner.speedup = world.field_73011_w instanceof WorldProviderAsteroids ? 5.5 : 2.5;
        if (miner.prepareMove(12, 0)) {
            miner.field_70128_L = true;
            return false;
        }
        if (miner.prepareMove(12, 1)) {
            miner.field_70128_L = true;
            return false;
        }
        if (miner.prepareMove(12, 2)) {
            miner.field_70128_L = true;
            return false;
        }
        world.func_72838_d((Entity)miner);
        miner.flagLink = true;
        return true;
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * 5.0) * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"entity.astro_miner.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return !this.field_70128_L && var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70296_d() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    private boolean emptyInventory(TileEntityMinerBase minerBase) {
        boolean doneOne = false;
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.func_190926_b()) continue;
            int sizeprev = stack.func_190916_E();
            minerBase.addToInventory(stack);
            if (stack.func_190926_b()) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return true;
            }
            if (stack.func_190916_E() >= sizeprev) continue;
            this.stacks.set(i, (Object)stack);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70071_h_() {
        block38: {
            block37: {
                block39: {
                    if (this.field_70163_u < -64.0) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.getDamage() > 0.0f) {
                        this.setDamage(this.getDamage() - 1.0f);
                    }
                    this.stopForTurn = !this.checkRotation();
                    this.facing = this.getFacingFromRotation();
                    this.setBoundingBoxForFacing();
                    if (this.field_70170_p.field_72995_K) {
                        if (this.turnProgress == 0) {
                            ++this.turnProgress;
                            if (this.AIstate < 2) {
                                this.field_70165_t = this.minecartX;
                                this.field_70163_u = this.minecartY;
                                this.field_70161_v = this.minecartZ;
                            } else {
                                double diffX = this.minecartX - this.field_70165_t;
                                double diffY = this.minecartY - this.field_70163_u;
                                double diffZ = this.minecartZ - this.field_70161_v;
                                if (Math.abs(diffX) > 1.0 || Math.abs(diffY) > 1.0 || Math.abs(diffZ) > 1.0) {
                                    this.field_70165_t = this.minecartX;
                                    this.field_70163_u = this.minecartY;
                                    this.field_70161_v = this.minecartZ;
                                } else {
                                    if (Math.abs(diffX) > Math.abs(this.field_70159_w)) {
                                        this.field_70159_w += diffX / 10.0;
                                    }
                                    if (Math.abs(diffY) > Math.abs(this.field_70181_x)) {
                                        this.field_70181_x += diffY / 10.0;
                                    }
                                    if (Math.abs(diffZ) > Math.abs(this.field_70179_y)) {
                                        this.field_70179_y += diffZ / 10.0;
                                    }
                                }
                            }
                        }
                        this.field_70165_t += this.field_70159_w;
                        this.field_70163_u += this.field_70181_x;
                        this.field_70161_v += this.field_70179_y;
                        this.func_174826_a(this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                        if (this.AIstate == 3 && this.field_70173_aa % 2 == 0) {
                            this.prepareMoveClient(1, 2);
                        }
                        if (this.AIstate < 1) {
                            this.stopRocketSound();
                        }
                        return;
                    }
                    if (this.toAddToServer) {
                        this.toAddToServer = false;
                        this.serverIndex = AsteroidsTickHandlerServer.monitorMiner(this);
                    }
                    if (this.field_70173_aa % 10 != 0 && !this.flagLink) break block37;
                    this.flagLink = false;
                    this.checkPlayer();
                    if (!this.posBase.blockExists(this.field_70170_p)) break block38;
                    TileEntity tileEntity = this.posBase.getTileEntity((IBlockAccess)this.field_70170_p);
                    if (!(tileEntity instanceof TileEntityMinerBase) || !((TileEntityMinerBase)tileEntity).isMaster || tileEntity.func_145837_r()) break block39;
                    UUID linker = ((TileEntityMinerBase)tileEntity).getLinkedMiner();
                    if (!this.func_110124_au().equals(linker)) {
                        if (linker != null) {
                            this.freeze(8);
                            return;
                        }
                        ((TileEntityMinerBase)tileEntity).linkMiner(this);
                        break block38;
                    } else if (((TileEntityMinerBase)tileEntity).linkedMiner != this) {
                        ((TileEntityMinerBase)tileEntity).linkMiner(this);
                    }
                    break block38;
                }
                if (this.playerMP != null && (this.givenFailMessage & 8) == 0) {
                    this.playerMP.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner3.fail")));
                    this.givenFailMessage += 8;
                }
                break block38;
            }
            if (this.flagCheckPlayer) {
                this.checkPlayer();
            }
        }
        if (this.playerMP == null) {
            if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketDynamic((Entity)this), GCCoreUtil.getDimensionID((World)this.field_70170_p));
            }
            return;
        }
        if (this.lastFacing != this.facingAI) {
            this.lastFacing = this.facingAI;
            this.prepareMove(12, 0);
            this.prepareMove(12, 1);
            this.prepareMove(12, 2);
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.AIstate > 1) {
            if (this.energyLevel <= 0) {
                this.freeze(4);
            } else if (!(this.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) && this.field_70173_aa % 2 == 0) {
                --this.energyLevel;
            }
        }
        switch (this.AIstate) {
            case 0: {
                if (this.field_70173_aa % 600 != 0) break;
                if ((this.givenFailMessage & 8) > 0) {
                    this.atBase();
                    break;
                }
                this.AIstate = 4;
                if (this.energyLevel > 0) break;
                this.energyLevel = 20;
                break;
            }
            case 1: {
                this.atBase();
                break;
            }
            case 2: {
                if (this.moveToTarget()) break;
                this.prepareMove(2, 2);
                break;
            }
            case 3: {
                if (this.doMining() || this.field_70173_aa % 2 != 0) break;
                --this.energyLevel;
                this.prepareMove(1, 2);
                break;
            }
            case 4: {
                this.moveToBase();
                this.prepareMove(4, 1);
                break;
            }
            case 5: {
                if (this.waypointBase != null) {
                    this.speed = 0.013749999999999998;
                    this.rotSpeed = 0.9375f;
                    if (!this.moveToPos(this.waypointBase, true)) break;
                    this.AIstate = 1;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                    this.speed = 0.022;
                    this.rotSpeed = 1.5f;
                    break;
                }
                GCLog.severe((String)"AstroMiner missing base position: this is a bug.");
                this.AIstate = 0;
                break;
            }
        }
        GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketDynamic((Entity)this), GCCoreUtil.getDimensionID((World)this.field_70170_p));
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_174826_a(this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
    }

    private void checkPlayer() {
        if (this.playerMP == null) {
            if (this.playerUUID != null) {
                this.playerMP = PlayerUtil.getPlayerByUUID((UUID)this.playerUUID);
            }
        } else if (!PlayerUtil.isPlayerOnline((EntityPlayerMP)this.playerMP)) {
            this.playerMP = null;
        }
    }

    private void freeze(int i) {
        this.AIstate = 0;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        if (this.playerMP != null && (this.givenFailMessage & 1 << i) == 0) {
            this.playerMP.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)("gui.message.astro_miner" + i + ".fail"))));
            this.givenFailMessage += 1 << i;
        }
    }

    public void decodePacketdata(ByteBuf buffer) {
        TileEntity tile;
        int z;
        int y;
        this.AIstate = buffer.readInt();
        this.energyLevel = buffer.readInt();
        this.targetPitch = buffer.readFloat();
        this.targetYaw = buffer.readFloat();
        this.mineCount = buffer.readInt();
        int x = buffer.readInt();
        BlockPos pos = new BlockPos(x, y = buffer.readInt(), z = buffer.readInt());
        if (this.field_70170_p.func_175667_e(pos) && (tile = this.field_70170_p.func_175625_s(pos)) instanceof TileEntityMinerBase) {
            ((TileEntityMinerBase)tile).linkedMiner = this;
            ((TileEntityMinerBase)tile).linkCountDown = 20;
        }
    }

    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.playerMP == null ? -1 : this.AIstate);
        list.add(this.energyLevel);
        list.add(Float.valueOf(this.targetPitch));
        list.add(Float.valueOf(this.targetYaw));
        list.add(this.mineCount);
        list.add(this.posBase.x);
        list.add(this.posBase.y);
        list.add(this.posBase.z);
    }

    public void recall() {
        if (this.AIstate > 1 && this.AIstate < 4) {
            this.AIstate = 4;
            this.pathBlockedCount = 0;
        }
    }

    private EnumFacing getFacingFromRotation() {
        if (this.field_70125_A > 45.0f) {
            return EnumFacing.UP;
        }
        if (this.field_70125_A < -45.0f) {
            return EnumFacing.DOWN;
        }
        float rY = this.field_70177_z % 360.0f;
        if (rY < 45.0f || rY > 315.0f) {
            return EnumFacing.SOUTH;
        }
        if (rY < 135.0f) {
            return EnumFacing.EAST;
        }
        if (rY < 225.0f) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.WEST;
    }

    private void atBase() {
        TileEntity tileEntity = this.posBase.getTileEntity((IBlockAccess)this.field_70170_p);
        if (!(tileEntity instanceof TileEntityMinerBase) || tileEntity.func_145837_r() || !((TileEntityMinerBase)tileEntity).isMaster) {
            this.freeze(3);
            return;
        }
        TileEntityMinerBase minerBase = (TileEntityMinerBase)tileEntity;
        this.givenFailMessage &= 0x40;
        this.wayPoints.clear();
        boolean somethingTransferred = true;
        if (this.field_70173_aa % 5 == 0) {
            somethingTransferred = this.emptyInventory(minerBase);
        }
        this.inventoryDrops = 0;
        if (minerBase.hasEnoughEnergyToRun && this.energyLevel < 12000) {
            this.energyLevel += 16;
            minerBase.storage.extractEnergyGC(minerBase.storage.getMaxExtract(), false);
        }
        if (this.energyLevel >= 12000 && !somethingTransferred && this.hasHoldSpace()) {
            this.energyLevel = 12000;
            if (this.findNextTarget(minerBase)) {
                this.AIstate = 2;
                this.wayPoints.add(this.waypointBase.clone());
                this.mineCount = 0;
            } else if (this.playerMP != null && (this.givenFailMessage & 0x40) == 0) {
                this.playerMP.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner6.fail")));
                this.givenFailMessage += 64;
            }
        }
    }

    private boolean hasHoldSpace() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private boolean findNextTarget(TileEntityMinerBase minerBase) {
        if (!this.minePoints.isEmpty() && this.pathBlockedCount < 2) {
            this.posTarget = this.minePoints.getFirst().clone();
            GCLog.debug((String)("Still mining at: " + this.posTarget + " Remaining shafts: " + this.minePoints.size()));
            return true;
        }
        this.posTarget = minerBase.findNextTarget();
        this.pathBlockedCount = 0;
        if (this.posTarget == null) {
            return false;
        }
        GCLog.debug((String)("Miner target: " + this.posTarget));
        return true;
    }

    private boolean moveToTarget() {
        if (this.energyLevel < 1000 || this.inventoryDrops > 10) {
            this.AIstate = 4;
            this.pathBlockedCount = 0;
            return true;
        }
        if (this.posTarget == null) {
            GCLog.severe((String)"AstroMiner missing target: this is a bug.");
            this.AIstate = 0;
            return true;
        }
        if (this.moveToPos(this.posTarget, false)) {
            this.AIstate = 3;
            this.wayPoints.add(this.posTarget.clone());
            this.setMinePoints();
            return true;
        }
        return false;
    }

    private void moveToBase() {
        if (this.wayPoints.size() == 0) {
            this.AIstate = 5;
            if (this.waypointBase != null) {
                this.func_70107_b(this.waypointBase.x, this.waypointBase.y, this.waypointBase.z);
                this.facingAI = this.baseFacing;
            }
            return;
        }
        if (this.moveToPos(this.wayPoints.getLast(), true)) {
            this.wayPoints.removeLast();
        }
    }

    private void setMinePoints() {
        int otherEnd;
        if (this.minePoints.size() > 0) {
            return;
        }
        BlockVec3 inFront = new BlockVec3(MathHelper.func_76128_c((double)(this.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(this.field_70163_u + 1.5)), MathHelper.func_76128_c((double)(this.field_70161_v + 0.5)));
        int n = otherEnd = this.field_70170_p.field_73011_w instanceof WorldProviderAsteroids ? 12 : 24;
        if (this.baseFacing == EnumFacing.NORTH || this.baseFacing == EnumFacing.WEST) {
            otherEnd = -otherEnd;
        }
        switch (this.baseFacing) {
            case NORTH: 
            case SOUTH: {
                this.minePoints.add(inFront.clone().translate(0, 0, otherEnd));
                this.minePoints.add(inFront.clone().translate(4, 0, otherEnd));
                this.minePoints.add(inFront.clone().translate(4, 0, 0));
                this.minePoints.add(inFront.clone().translate(2, 3, 0));
                this.minePoints.add(inFront.clone().translate(2, 3, otherEnd));
                this.minePoints.add(inFront.clone().translate(-2, 3, otherEnd));
                this.minePoints.add(inFront.clone().translate(-2, 3, 0));
                this.minePoints.add(inFront.clone().translate(-4, 0, 0));
                this.minePoints.add(inFront.clone().translate(-4, 0, otherEnd));
                this.minePoints.add(inFront.clone().translate(-2, -3, otherEnd));
                this.minePoints.add(inFront.clone().translate(-2, -3, 0));
                this.minePoints.add(inFront.clone().translate(2, -3, 0));
                this.minePoints.add(inFront.clone().translate(2, -3, otherEnd));
                this.minePoints.add(inFront.clone().translate(0, 0, otherEnd));
                break;
            }
            case WEST: 
            case EAST: {
                this.minePoints.add(inFront.clone().translate(otherEnd, 0, 0));
                this.minePoints.add(inFront.clone().translate(otherEnd, 0, 4));
                this.minePoints.add(inFront.clone().translate(0, 0, 4));
                this.minePoints.add(inFront.clone().translate(0, 3, 2));
                this.minePoints.add(inFront.clone().translate(otherEnd, 3, 2));
                this.minePoints.add(inFront.clone().translate(otherEnd, 3, -2));
                this.minePoints.add(inFront.clone().translate(0, 3, -2));
                this.minePoints.add(inFront.clone().translate(0, 0, -4));
                this.minePoints.add(inFront.clone().translate(otherEnd, 0, -4));
                this.minePoints.add(inFront.clone().translate(otherEnd, -3, -2));
                this.minePoints.add(inFront.clone().translate(0, -3, -2));
                this.minePoints.add(inFront.clone().translate(0, -3, 2));
                this.minePoints.add(inFront.clone().translate(otherEnd, -3, 2));
                this.minePoints.add(inFront.clone().translate(otherEnd, 0, 0));
            }
        }
    }

    private boolean doMining() {
        if (this.energyLevel < 1000 || this.inventoryDrops > 10 || this.minePoints.size() == 0) {
            if (this.minePoints.size() > 0 && this.minePointCurrent != null) {
                this.minePoints.addFirst(this.minePointCurrent);
            }
            this.AIstate = 4;
            this.pathBlockedCount = 0;
            GCLog.debug((String)("Miner going home: " + this.posBase.toString() + " " + this.minePoints.size() + " shafts still to be mined"));
            return true;
        }
        if (this.moveToPos(this.minePoints.getFirst(), false)) {
            this.minePointCurrent = this.minePoints.removeFirst();
            GCLog.debug((String)("Miner mid mining: " + this.minePointCurrent.toString() + " " + this.minePoints.size() + " shafts still to be mined"));
            return true;
        }
        return false;
    }

    private void tryBackIn() {
        BlockVec3 blockVec3 = new BlockVec3((Entity)this);
        if ((double)this.waypointBase.distanceSquared(blockVec3) <= 9.1) {
            this.AIstate = 5;
            switch (this.baseFacing) {
                case NORTH: {
                    this.targetYaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    this.targetYaw = 0.0f;
                    break;
                }
                case WEST: {
                    this.targetYaw = 270.0f;
                    break;
                }
                case EAST: {
                    this.targetYaw = 90.0f;
                }
            }
        } else {
            this.freeze(5);
        }
    }

    private boolean prepareMove(int limit, int dist) {
        if (this.mineCountDown > 0) {
            --this.mineCountDown;
            return false;
        }
        BlockVec3 inFront = new BlockVec3(MathHelper.func_76128_c((double)(this.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(this.field_70163_u + 1.5)), MathHelper.func_76128_c((double)(this.field_70161_v + 0.5)));
        if (dist == 2) {
            inFront.translate(headings2[this.facingAI.func_176745_a()]);
        } else {
            if ((this.facingAI.func_176745_a() & 1) == EnumFacing.DOWN.func_176745_a()) {
                ++dist;
            }
            if (dist > 0) {
                inFront.translate(headings[this.facingAI.func_176745_a()].clone().scale(dist));
            }
        }
        if (!inFront.equals((Object)this.mineLast) && this.AIstate != 1) {
            this.mineCountDown = 3;
            this.mineLast = inFront;
            return false;
        }
        int x = inFront.x;
        int y = inFront.y;
        int z = inFront.z;
        if (y == this.waypointBase.y && x == this.waypointBase.x - (this.baseFacing == EnumFacing.EAST ? 1 : 0) && z == this.waypointBase.z - (this.baseFacing == EnumFacing.SOUTH ? 1 : 0)) {
            this.tryBackIn();
            return false;
        }
        boolean wayBarred = false;
        this.tryBlockLimit = limit;
        BlockPos pos = new BlockPos(x, y, z);
        switch (EnumFacing.func_82600_a((int)(this.facingAI.func_176745_a() & 6))) {
            case DOWN: {
                if (this.tryMineBlock(pos)) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(1, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-2, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-2, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, 0, 1))) {
                    wayBarred = true;
                }
                if (!this.tryMineBlock(pos.func_177982_a(0, 0, 1))) break;
                wayBarred = true;
                break;
            }
            case NORTH: {
                if (this.tryMineBlock(pos.func_177982_a(0, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(1, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-2, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-2, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos)) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(-1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 1, 0))) {
                    wayBarred = true;
                }
                if (!this.tryMineBlock(pos.func_177982_a(-1, 1, 0))) break;
                wayBarred = true;
                break;
            }
            case WEST: {
                if (this.tryMineBlock(pos.func_177982_a(0, -2, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -1, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -1, 1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -1, -2))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 0, 1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos.func_177982_a(0, 1, -1))) {
                    wayBarred = true;
                }
                if (this.tryMineBlock(pos)) {
                    wayBarred = true;
                }
                if (!this.tryMineBlock(pos.func_177982_a(0, 1, 0))) break;
                wayBarred = true;
            }
        }
        if (wayBarred) {
            if (this.playerMP != null && EntityAstroMiner.blockingBlock.block != Blocks.field_150350_a) {
                if (EntityAstroMiner.blockingBlock.block == Blocks.field_150348_b) {
                    this.playerMP.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner1_a.fail") + " " + GCCoreUtil.translate((String)"gui.message.astro_miner1_b.fail")));
                } else {
                    this.playerMP.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.message.astro_miner1_a.fail") + " " + GCCoreUtil.translate((String)blockingBlock.toString())));
                }
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.tryBlockLimit = 0;
            if (this.AIstate == 2) {
                this.AIstate = 4;
            } else if (this.AIstate == 3) {
                ++this.pathBlockedCount;
                this.AIstate = 4;
            } else if (this.AIstate == 4) {
                this.tryBackIn();
            } else {
                this.freeze(5);
            }
            blockingBlock = new BlockTuple(Blocks.field_150350_a, 0);
        }
        if (this.tryBlockLimit == limit && !this.noSpeedup) {
            this.field_70159_w *= this.speedup;
            this.field_70181_x *= this.speedup;
            this.field_70179_y *= this.speedup;
        }
        return wayBarred;
    }

    private boolean prepareMoveClient(int limit, int dist) {
        BlockVec3 inFront = new BlockVec3(MathHelper.func_76128_c((double)(this.field_70165_t + 0.5)), MathHelper.func_76128_c((double)(this.field_70163_u + 1.5)), MathHelper.func_76128_c((double)(this.field_70161_v + 0.5)));
        if (dist == 2) {
            inFront.translate(headings2[this.facing.func_176745_a()]);
        } else {
            if ((this.facing.func_176745_a() & 1) == EnumFacing.DOWN.func_176745_a()) {
                ++dist;
            }
            if (dist > 0) {
                inFront.translate(headings[this.facing.func_176745_a()].clone().scale(dist));
            }
        }
        if (inFront.equals((Object)this.mineLast)) {
            return false;
        }
        int x = inFront.x;
        int y = inFront.y;
        int z = inFront.z;
        boolean wayBarred = false;
        this.tryBlockLimit = limit;
        BlockPos pos = new BlockPos(x, y, z);
        switch (EnumFacing.func_82600_a((int)(this.facing.func_176745_a() & 6))) {
            case DOWN: {
                if (this.tryBlockClient(pos)) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(1, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-2, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-2, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, 0, 1))) {
                    wayBarred = true;
                }
                if (!this.tryBlockClient(pos.func_177982_a(0, 0, 1))) break;
                wayBarred = true;
                break;
            }
            case NORTH: {
                if (this.tryBlockClient(pos.func_177982_a(0, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(1, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-2, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-2, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos)) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(-1, 0, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 1, 0))) {
                    wayBarred = true;
                }
                if (!this.tryBlockClient(pos.func_177982_a(-1, 1, 0))) break;
                wayBarred = true;
                break;
            }
            case WEST: {
                if (this.tryBlockClient(pos.func_177982_a(0, -2, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -1, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -1, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -1, 1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -1, -2))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 0, 1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 0, -2))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 0, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, -2, 0))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos.func_177982_a(0, 1, -1))) {
                    wayBarred = true;
                }
                if (this.tryBlockClient(pos)) {
                    wayBarred = true;
                }
                if (!this.tryBlockClient(pos.func_177982_a(0, 1, 0))) break;
                wayBarred = true;
            }
        }
        if (wayBarred) {
            this.tryBlockLimit = 0;
        }
        if (this.tryBlockLimit == limit) {
            this.mineLast = inFront;
        }
        return wayBarred;
    }

    private boolean tryMineBlock(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.func_149688_o(state) == Material.field_151579_a) {
            return false;
        }
        if (noMineList.contains(b)) {
            EntityAstroMiner.blockingBlock.block = b;
            EntityAstroMiner.blockingBlock.meta = b.func_176201_c(state);
            return true;
        }
        if (b instanceof BlockLiquid) {
            if ((b == Blocks.field_150353_l || b == Blocks.field_150356_k) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && this.AIstate != 4) {
                EntityAstroMiner.blockingBlock.block = Blocks.field_150353_l;
                EntityAstroMiner.blockingBlock.meta = 0;
                return true;
            }
            return false;
        }
        if (b instanceof IFluidBlock) {
            return false;
        }
        boolean gtFlag = false;
        if (b != GCBlocks.fallenMeteor) {
            if (b instanceof IPlantable && b != Blocks.field_150329_H && b != Blocks.field_150330_I && b != Blocks.field_150398_cm && b != Blocks.field_150392_bi && !(b instanceof BlockFlower) && b != Blocks.field_150436_aH) {
                EntityAstroMiner.blockingBlock.block = b;
                EntityAstroMiner.blockingBlock.meta = b.func_176201_c(state);
                return true;
            }
            int meta = b.func_176201_c(state);
            if (b.func_176195_g(state, this.field_70170_p, pos) < 0.0f) {
                EntityAstroMiner.blockingBlock.block = b;
                EntityAstroMiner.blockingBlock.meta = meta;
                return true;
            }
            if (b.hasTileEntity(state)) {
                if (CompatibilityManager.isGTLoaded() && this.gregTechCheck(b)) {
                    gtFlag = true;
                } else {
                    EntityAstroMiner.blockingBlock.block = b;
                    EntityAstroMiner.blockingBlock.meta = meta;
                    return true;
                }
            }
        }
        if (this.tryBlockLimit == 0) {
            return false;
        }
        int result = ForgeHooks.onBlockBreakEvent((World)this.field_70170_p, (GameType)this.playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)this.playerMP, (BlockPos)pos);
        if (result < 0) {
            EntityAstroMiner.blockingBlock.block = Blocks.field_150348_b;
            EntityAstroMiner.blockingBlock.meta = 0;
            return true;
        }
        --this.tryBlockLimit;
        if (!(b instanceof IPlantable && !(b instanceof BlockReed) || b instanceof BlockLeaves)) {
            ItemStack drops;
            ItemStack itemStack = drops = gtFlag ? this.getGTDrops(this.field_70170_p, pos, b) : this.getPickBlock(this.field_70170_p, pos, b);
            if (drops != null && !this.addToInventory(drops)) {
                this.dropStack(pos, drops);
            }
        }
        this.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        return false;
    }

    private void dropStack(BlockPos pos, ItemStack drops) {
        float f = 0.7f;
        double d0 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.field_70170_p, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drops);
        entityitem.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)entityitem);
        ++this.inventoryDrops;
    }

    private boolean gregTechCheck(Block b) {
        Class clazz = CompatibilityManager.classGTOre;
        return clazz != null && clazz.isInstance(b);
    }

    private ItemStack getGTDrops(World w, BlockPos pos, Block b) {
        List array = b.getDrops((IBlockAccess)w, pos, b.func_176223_P(), 1);
        if (array != null && array.size() > 0) {
            return (ItemStack)array.get(0);
        }
        return ItemStack.field_190927_a;
    }

    private boolean tryBlockClient(BlockPos pos) {
        BlockVec3 bv = new BlockVec3(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (this.laserBlocks.contains(bv)) {
            return false;
        }
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.func_149688_o(state) == Material.field_151579_a) {
            return false;
        }
        if (noMineList.contains(b)) {
            return true;
        }
        if (b instanceof BlockLiquid) {
            return false;
        }
        if (b instanceof IFluidBlock) {
            return false;
        }
        if (b instanceof IPlantable) {
            return true;
        }
        if (b.hasTileEntity(state) || b.func_176195_g(state, this.field_70170_p, pos) < 0.0f) {
            return true;
        }
        if (this.tryBlockLimit == 0) {
            return false;
        }
        --this.tryBlockLimit;
        this.laserBlocks.add(bv);
        this.laserTimes.add(this.field_70173_aa);
        return false;
    }

    public void removeLaserBlocks(int removeCount) {
        for (int i = 0; i < removeCount; ++i) {
            this.laserBlocks.removeFirst();
            this.laserTimes.removeFirst();
        }
    }

    private ItemStack getPickBlock(World world, BlockPos pos, Block b) {
        if (b == GCBlocks.fallenMeteor) {
            return new ItemStack(GCItems.meteoricIronRaw);
        }
        if (b instanceof BlockSpaceGlass) {
            return (ItemStack)b.getDrops((IBlockAccess)world, pos, b.func_176223_P(), 0).get(0);
        }
        int i = 0;
        Item item = Item.func_150898_a((Block)b);
        if (item == null) {
            GCLog.info((String)("AstroMiner was unable to mine anything from: " + b.func_149739_a()));
            return null;
        }
        if (item.func_77614_k()) {
            i = b.func_176201_c(world.func_180495_p(pos));
        }
        return new ItemStack(item, 1, i);
    }

    private boolean addToInventory(ItemStack itemstack) {
        ItemStack itemstack1;
        int k;
        boolean flag1 = false;
        int invSize = this.func_70302_i_();
        if (itemstack.func_77985_e()) {
            for (k = 0; !itemstack.func_190926_b() && k < invSize; ++k) {
                itemstack1 = (ItemStack)this.stacks.get(k);
                if (!RecipeUtil.stacksMatch((ItemStack)itemstack, (ItemStack)itemstack1)) continue;
                int l = itemstack1.func_190916_E() + itemstack.func_190916_E();
                if (l <= itemstack.func_77976_d()) {
                    itemstack.func_190920_e(0);
                    itemstack1.func_190920_e(l);
                    flag1 = true;
                    continue;
                }
                if (itemstack1.func_190916_E() >= itemstack.func_77976_d()) continue;
                itemstack.func_190918_g(itemstack.func_77976_d() - itemstack1.func_190916_E());
                itemstack1.func_190920_e(itemstack.func_77976_d());
                flag1 = true;
            }
        }
        if (!itemstack.func_190926_b()) {
            for (k = 0; k < invSize; ++k) {
                itemstack1 = (ItemStack)this.stacks.get(k);
                if (!itemstack1.func_190926_b()) continue;
                this.stacks.set(k, (Object)itemstack.func_77946_l());
                itemstack.func_190920_e(0);
                flag1 = true;
                break;
            }
        }
        if (flag1) {
            this.func_70296_d();
            ++this.mineCount;
        }
        return flag1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean moveToPos(BlockVec3 pos, boolean reverse) {
        this.noSpeedup = false;
        if (reverse != this.baseFacing.func_176745_a() < 4) {
            if (this.field_70161_v > (double)pos.z + 1.0E-4 || this.field_70161_v < (double)pos.z - 1.0E-4) {
                this.moveToPosZ(pos.z, this.stopForTurn);
                return false;
            } else if (this.field_70163_u > (double)pos.y - 0.9999 || this.field_70163_u < (double)pos.y - 1.0001) {
                this.moveToPosY(pos.y - 1, this.stopForTurn);
                return false;
            } else {
                if (!(this.field_70165_t > (double)pos.x + 1.0E-4) && !(this.field_70165_t < (double)pos.x - 1.0E-4)) return true;
                this.moveToPosX(pos.x, this.stopForTurn);
            }
            return false;
        } else if (this.field_70165_t > (double)pos.x + 1.0E-4 || this.field_70165_t < (double)pos.x - 1.0E-4) {
            this.moveToPosX(pos.x, this.stopForTurn);
            return false;
        } else if (this.field_70163_u > (double)pos.y - 0.9999 || this.field_70163_u < (double)pos.y - 1.0001) {
            this.moveToPosY(pos.y - 1, this.stopForTurn);
            return false;
        } else {
            if (!(this.field_70161_v > (double)pos.z + 1.0E-4) && !(this.field_70161_v < (double)pos.z - 1.0E-4)) return true;
            this.moveToPosZ(pos.z, this.stopForTurn);
        }
        return false;
    }

    private void moveToPosX(int x, boolean stopForTurn) {
        this.targetPitch = 0.0f;
        if (this.field_70165_t > (double)x) {
            if (this.AIstate != 5) {
                this.targetYaw = 270.0f;
            }
            this.field_70159_w = -this.speed;
            if (this.field_70159_w * this.speedup <= (double)x - this.field_70165_t) {
                this.field_70159_w = (double)x - this.field_70165_t;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.WEST;
        } else {
            if (this.AIstate != 5) {
                this.targetYaw = 90.0f;
            }
            this.field_70159_w = this.speed;
            if (this.field_70159_w * this.speedup >= (double)x - this.field_70165_t) {
                this.field_70159_w = (double)x - this.field_70165_t;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.EAST;
        }
        if (stopForTurn) {
            this.field_70159_w = 0.0;
        }
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    private void moveToPosY(int y, boolean stopForTurn) {
        if (this.field_70163_u > (double)y) {
            this.targetPitch = -90.0f;
            this.field_70181_x = -this.speed;
            if (this.field_70181_x * this.speedup <= (double)y - this.field_70163_u) {
                this.field_70181_x = (double)y - this.field_70163_u;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.DOWN;
        } else {
            this.targetPitch = 90.0f;
            this.field_70181_x = this.speed;
            if (this.field_70181_x * this.speedup >= (double)y - this.field_70163_u) {
                this.field_70181_x = (double)y - this.field_70163_u;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.UP;
        }
        if (stopForTurn) {
            this.field_70181_x = 0.0;
        }
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
    }

    private void moveToPosZ(int z, boolean stopForTurn) {
        this.targetPitch = 0.0f;
        if (this.field_70161_v > (double)z) {
            if (this.AIstate != 5) {
                this.targetYaw = 180.0f;
            }
            this.field_70179_y = -this.speed;
            if (this.field_70179_y * this.speedup <= (double)z - this.field_70161_v) {
                this.field_70179_y = (double)z - this.field_70161_v;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.NORTH;
        } else {
            if (this.AIstate != 5) {
                this.targetYaw = 0.0f;
            }
            this.field_70179_y = this.speed;
            if (this.field_70179_y * this.speedup >= (double)z - this.field_70161_v) {
                this.field_70179_y = (double)z - this.field_70161_v;
                this.noSpeedup = true;
            }
            this.facingAI = EnumFacing.SOUTH;
        }
        if (stopForTurn) {
            this.field_70179_y = 0.0;
        }
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    private boolean checkRotation() {
        boolean flag = true;
        if (this.field_70125_A > this.targetPitch + 0.001f || this.field_70125_A < this.targetPitch - 0.001f) {
            if (this.field_70125_A > this.targetPitch + 180.0f) {
                this.field_70125_A -= 360.0f;
            } else if (this.field_70125_A < this.targetPitch - 180.0f) {
                this.field_70125_A += 360.0f;
            }
            if (this.field_70125_A > this.targetPitch) {
                this.field_70125_A -= this.rotSpeed;
                if (this.field_70125_A < this.targetPitch) {
                    this.field_70125_A = this.targetPitch;
                }
            } else {
                this.field_70125_A += this.rotSpeed;
                if (this.field_70125_A > this.targetPitch) {
                    this.field_70125_A = this.targetPitch;
                }
            }
        }
        if (this.field_70177_z > this.targetYaw + 0.001f || this.field_70177_z < this.targetYaw - 0.001f) {
            if (this.field_70177_z > this.targetYaw + 180.0f) {
                this.field_70177_z -= 360.0f;
            } else if (this.field_70177_z < this.targetYaw - 180.0f) {
                this.field_70177_z += 360.0f;
            }
            if (this.field_70177_z > this.targetYaw) {
                this.field_70177_z -= this.rotSpeed;
                if (this.field_70177_z < this.targetYaw) {
                    this.field_70177_z = this.targetYaw;
                }
            } else {
                this.field_70177_z += this.rotSpeed;
                if (this.field_70177_z > this.targetYaw) {
                    this.field_70177_z = this.targetYaw;
                }
            }
            flag = false;
        }
        return flag;
    }

    public void setPlayer(EntityPlayerMP player) {
        this.playerMP = player;
        this.playerUUID = player.func_110124_au();
    }

    private void setBoundingBoxForFacing() {
        float xsize = 1.8f;
        float ysize = 1.8f;
        float zsize = 1.8f;
        switch (this.facing) {
            case DOWN: 
            case UP: {
                ysize = 2.6f;
                break;
            }
            case NORTH: 
            case SOUTH: {
                ysize = 1.7f;
                zsize = 2.6f;
                break;
            }
            case WEST: 
            case EAST: {
                ysize = 1.7f;
                xsize = 2.6f;
            }
        }
        this.field_70130_N = Math.max(xsize, zsize);
        this.field_70131_O = ysize;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)xsize / 2.0, this.field_70163_u + 1.0 - (double)ysize / 2.0, this.field_70161_v - (double)zsize / 2.0, this.field_70165_t + (double)xsize / 2.0, this.field_70163_u + 1.0 + (double)ysize / 2.0, this.field_70161_v + (double)zsize / 2.0));
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70128_L || par1DamageSource.equals(DamageSource.field_76367_g)) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity e = par1DamageSource.func_76346_g();
            if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
                if (this.playerMP == null && !this.spawnedInCreative) {
                    e.func_145747_a((ITextComponent)new TextComponentString("WARNING: that Astro Miner belonged to an offline player, cannot reset player's Astro Miner count."));
                }
                this.func_70106_y();
                return true;
            }
            if (this.isEntityInvulnerable() || e instanceof EntityLivingBase && !(e instanceof EntityPlayer)) {
                return false;
            }
            this.func_70018_K();
            this.shipDamage += par2 * 10.0f;
            if (e instanceof EntityPlayer) {
                this.shipDamage += par2 * 21.0f;
            }
            if (this.shipDamage > 90.0f) {
                this.func_70106_y();
                this.dropShipAsItem();
                return true;
            }
            return true;
        }
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return par1Entity.func_70046_E();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70057_ab() {
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float p_70492_1_) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(p_70492_1_));
    }

    public void func_70012_b(double x, double y, double z, float rotYaw, float rotPitch) {
        this.minecartX = x;
        this.minecartY = y;
        this.minecartZ = z;
        super.func_70012_b(x, y, z, rotYaw, rotPitch);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        this.minecartX = x;
        this.minecartY = y;
        this.minecartZ = z;
        this.minecartYaw = y;
        this.minecartPitch = pitch;
        this.turnProgress = 0;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.velocityX = this.field_70159_w = p_70016_1_;
        this.velocityY = this.field_70181_x = p_70016_3_;
        this.velocityZ = this.field_70179_y = p_70016_5_;
        this.turnProgress = 0;
    }

    protected void func_70105_a(float p_70105_1_, float p_70105_2_) {
        this.setBoundingBoxForFacing();
    }

    public void func_70107_b(double p_70107_1_, double p_70107_3_, double p_70107_5_) {
        this.func_174826_a(this.func_174813_aQ().func_72317_d(p_70107_1_ - this.field_70165_t, p_70107_3_ - this.field_70163_u, p_70107_5_ - this.field_70161_v));
        this.field_70165_t = p_70107_1_;
        this.field_70163_u = p_70107_3_;
        this.field_70161_v = p_70107_5_;
    }

    public void func_70106_y() {
        TileEntity tileEntity;
        if (!this.field_70170_p.field_72995_K && this.playerMP != null) {
            int astroCount;
            GCPlayerStats stats = GCPlayerStats.get((Entity)this.playerMP);
            if (!this.spawnedInCreative && (astroCount = stats.getAstroMinerCount()) > 0) {
                stats.setAstroMinerCount(stats.getAstroMinerCount() - 1);
            }
            AsteroidsTickHandlerServer.removeChunkData(stats, this);
        }
        super.func_70106_y();
        if (this.posBase != null && (tileEntity = this.posBase.getTileEntity((IBlockAccess)this.field_70170_p)) instanceof TileEntityMinerBase) {
            ((TileEntityMinerBase)tileEntity).unlinkMiner();
        }
        if (this.soundUpdater != null) {
            this.soundUpdater.func_73660_a();
        }
    }

    public boolean isEntityInvulnerable() {
        return this.playerMP == null;
    }

    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        ItemStack rocket = new ItemStack(AsteroidsItems.astroMiner, 1, 0);
        droppedItems.add(rocket);
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (!((ItemStack)this.stacks.get(i)).func_190926_b()) {
                droppedItems.add((ItemStack)this.stacks.get(i));
            }
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        return droppedItems;
    }

    public void dropShipAsItem() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (ItemStack item : this.getItemsDropped(new ArrayList<ItemStack>())) {
            EntityItem entityItem = this.func_70099_a(item, 0.0f);
            if (!item.func_77942_o()) continue;
            entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ITickable getSoundUpdater() {
        return this.soundUpdater;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound setSoundUpdater(EntityPlayerSP player) {
        this.soundUpdater = new SoundUpdaterMiner(player, this);
        return (ISound)this.soundUpdater;
    }

    public void stopRocketSound() {
        if (this.soundUpdater != null) {
            ((SoundUpdaterMiner)this.soundUpdater).stopRocketSound();
        }
        this.soundToStop = false;
    }

    public void transmitData(int[] data) {
        data[0] = (int)this.field_70165_t;
        data[1] = (int)this.field_70163_u;
        data[2] = (int)this.field_70161_v;
        data[3] = this.energyLevel;
        data[4] = this.AIstate;
    }

    public void receiveData(int[] data, String[] str) {
        str[0] = "";
        str[1] = "x: " + data[0];
        str[2] = "y: " + data[1];
        str[3] = "z: " + data[2];
        int energyPerCent = data[3] / 120;
        str[4] = GCCoreUtil.translate((String)"gui.energy_storage.desc.1") + ": " + energyPerCent + "%";
        switch (data[4]) {
            case 0: {
                str[0] = GCCoreUtil.translate((String)"gui.message.no_energy.name");
                break;
            }
            case 1: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.docked");
                break;
            }
            case 2: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.travelling");
                break;
            }
            case 3: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.mining");
                break;
            }
            case 4: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.returning");
                break;
            }
            case 5: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.docking");
                break;
            }
            case -1: {
                str[0] = GCCoreUtil.translate((String)"gui.miner.offline");
            }
        }
    }

    public void adjustDisplay(int[] data) {
        GL11.glScalef((float)0.9f, (float)0.9f, (float)0.9f);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        NBTTagCompound bvTag;
        this.stacks = NonNullList.func_191197_a((int)227, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        int itemCount = 0;
        for (ItemStack stack : this.stacks) {
            itemCount += stack.func_190916_E();
        }
        this.mineCount = itemCount;
        this.serverIndex = nbt.func_74764_b("sindex") ? nbt.func_74762_e("sindex") : -1;
        if (nbt.func_74764_b("Energy")) {
            this.energyLevel = nbt.func_74762_e("Energy");
        }
        if (nbt.func_74764_b("BaseX")) {
            this.posBase = new BlockVec3(nbt.func_74762_e("BaseX"), nbt.func_74762_e("BaseY"), nbt.func_74762_e("BaseZ"));
            this.flagLink = true;
        }
        if (nbt.func_74764_b("TargetX")) {
            this.posTarget = new BlockVec3(nbt.func_74762_e("TargetX"), nbt.func_74762_e("TargetY"), nbt.func_74762_e("TargetZ"));
        }
        if (nbt.func_74764_b("WBaseX")) {
            this.waypointBase = new BlockVec3(nbt.func_74762_e("WBaseX"), nbt.func_74762_e("WBaseY"), nbt.func_74762_e("WBaseZ"));
        }
        if (nbt.func_74764_b("BaseFacing")) {
            this.baseFacing = EnumFacing.func_82600_a((int)nbt.func_74762_e("BaseFacing"));
        }
        if (nbt.func_74764_b("AIState")) {
            this.AIstate = nbt.func_74762_e("AIState");
        }
        if (nbt.func_74764_b("Facing")) {
            this.facingAI = EnumFacing.func_82600_a((int)nbt.func_74762_e("Facing"));
            switch (this.facingAI) {
                case NORTH: {
                    this.targetYaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    this.targetYaw = 0.0f;
                    break;
                }
                case WEST: {
                    this.targetYaw = 270.0f;
                    break;
                }
                case EAST: {
                    this.targetYaw = 90.0f;
                }
            }
        }
        this.lastFacing = null;
        if (nbt.func_74764_b("WayPoints")) {
            this.wayPoints.clear();
            NBTTagList wpList = nbt.func_150295_c("WayPoints", 10);
            for (int j = 0; j < wpList.func_74745_c(); ++j) {
                bvTag = wpList.func_150305_b(j);
                this.wayPoints.add(BlockVec3.readFromNBT((NBTTagCompound)bvTag));
            }
        }
        if (nbt.func_74764_b("MinePoints")) {
            this.minePoints.clear();
            NBTTagList mpList = nbt.func_150295_c("MinePoints", 10);
            for (int j = 0; j < mpList.func_74745_c(); ++j) {
                bvTag = mpList.func_150305_b(j);
                this.minePoints.add(BlockVec3.readFromNBT((NBTTagCompound)bvTag));
            }
        }
        this.minePointCurrent = nbt.func_74764_b("MinePointCurrent") ? BlockVec3.readFromNBT((NBTTagCompound)nbt.func_74775_l("MinePointCurrent")) : null;
        this.playerUUID = nbt.func_150297_b("playerUUIDMost", 4) && nbt.func_150297_b("playerUUIDLeast", 4) ? new UUID(nbt.func_74763_f("playerUUIDMost"), nbt.func_74763_f("playerUUIDLeast")) : null;
        this.speedup = nbt.func_74764_b("speedup") ? nbt.func_74769_h("speedup") : (WorldUtil.getProviderForDimensionServer((int)this.field_71093_bK) instanceof WorldProviderAsteroids ? 4.0 : 2.5);
        this.pathBlockedCount = nbt.func_74762_e("pathBlockedCount");
        this.spawnedInCreative = nbt.func_74767_n("spawnedInCreative");
        this.flagCheckPlayer = true;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        int j;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagList var2 = new NBTTagList();
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        nbt.func_74782_a("Items", (NBTBase)var2);
        nbt.func_74768_a("sindex", this.serverIndex);
        nbt.func_74768_a("Energy", this.energyLevel);
        if (this.posBase != null) {
            nbt.func_74768_a("BaseX", this.posBase.x);
            nbt.func_74768_a("BaseY", this.posBase.y);
            nbt.func_74768_a("BaseZ", this.posBase.z);
        }
        if (this.posTarget != null) {
            nbt.func_74768_a("TargetX", this.posTarget.x);
            nbt.func_74768_a("TargetY", this.posTarget.y);
            nbt.func_74768_a("TargetZ", this.posTarget.z);
        }
        if (this.waypointBase != null) {
            nbt.func_74768_a("WBaseX", this.waypointBase.x);
            nbt.func_74768_a("WBaseY", this.waypointBase.y);
            nbt.func_74768_a("WBaseZ", this.waypointBase.z);
        }
        nbt.func_74768_a("BaseFacing", this.baseFacing.func_176745_a());
        nbt.func_74768_a("AIState", this.AIstate);
        nbt.func_74768_a("Facing", this.facingAI.func_176745_a());
        if (this.wayPoints.size() > 0) {
            NBTTagList wpList = new NBTTagList();
            for (j = 0; j < this.wayPoints.size(); ++j) {
                wpList.func_74742_a((NBTBase)this.wayPoints.get(j).writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("WayPoints", (NBTBase)wpList);
        }
        if (this.minePoints.size() > 0) {
            NBTTagList mpList = new NBTTagList();
            for (j = 0; j < this.minePoints.size(); ++j) {
                mpList.func_74742_a((NBTBase)this.minePoints.get(j).writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("MinePoints", (NBTBase)mpList);
        }
        if (this.minePointCurrent != null) {
            nbt.func_74782_a("MinePointCurrent", (NBTBase)this.minePointCurrent.writeToNBT(new NBTTagCompound()));
        }
        if (this.playerUUID != null) {
            nbt.func_74772_a("playerUUIDMost", this.playerUUID.getMostSignificantBits());
            nbt.func_74772_a("playerUUIDLeast", this.playerUUID.getLeastSignificantBits());
        }
        nbt.func_74780_a("speedup", this.speedup);
        nbt.func_74768_a("pathBlockedCount", this.pathBlockedCount);
        nbt.func_74757_a("spawnedInCreative", this.spawnedInCreative);
    }

    static {
        noMineList.add(Blocks.field_150357_h);
        noMineList.add(Blocks.field_150341_Y);
        noMineList.add(Blocks.field_150384_bq);
        noMineList.add(Blocks.field_150378_br);
        noMineList.add((Block)Blocks.field_150427_aO);
        noMineList.add(Blocks.field_150417_aV);
        noMineList.add(Blocks.field_150458_ak);
        noMineList.add(Blocks.field_150448_aq);
        noMineList.add(Blocks.field_150442_at);
        noMineList.add((Block)Blocks.field_150488_af);
        noMineList.add(AsteroidBlocks.blockWalkway);
    }
}

