/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.tile.TileEntityInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class TileEntityCrashedProbe
extends TileEntityInventory {
    protected ResourceLocation lootTable;
    protected long lootTableSeed;
    private boolean hasCoreToDrop;

    public TileEntityCrashedProbe() {
        super("container.crashed_probe.name");
        this.inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    }

    protected void fillWithLoot(EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable loottable = this.field_145850_b.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da());
            }
            loottable.func_186460_a((IInventory)this, random, lootcontext$builder.func_186471_a());
        }
    }

    protected boolean handleInventory() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasCoreToDrop = nbt.func_74764_b("ctd") ? nbt.func_74767_n("ctd") : true;
        if (!this.checkLootAndRead(nbt)) {
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("ctd", this.hasCoreToDrop);
        if (!this.checkLootAndWrite(nbt)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.getInventory());
        }
        return nbt;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public ItemStack func_70301_a(int slot) {
        this.fillWithLoot(null);
        return super.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.fillWithLoot(null);
        return super.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        this.fillWithLoot(null);
        return super.func_70304_b(index);
    }

    public boolean func_191420_l() {
        this.fillWithLoot(null);
        return super.func_191420_l();
    }

    public void func_174888_l() {
        this.fillWithLoot(null);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setDropCore() {
        this.hasCoreToDrop = true;
    }

    public boolean getDropCore() {
        return this.hasCoreToDrop;
    }

    protected boolean checkLootAndRead(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    protected boolean checkLootAndWrite(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    public void setLootTable(ResourceLocation lootTable, long lootTableSeed) {
        this.lootTable = lootTable;
        this.lootTableSeed = lootTableSeed;
    }
}

