/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.base;

import com.rwtema.extrautils2.blocks.BlockDecorativeGlass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseConfiguration;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseHangar;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BasePlate;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseRoom;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.BaseStart;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.Piece;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.base.SizedPiece;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.block.TFBlocks;

public class BaseDeck
extends SizedPiece {
    static final int ROOMSMALL = 6;
    static final int ROOMLARGE = 8;
    protected int roomsOnSide;
    protected int roomDepth;
    protected int largeRoomPosA;
    protected int largeRoomPosB;
    protected int deckTier;
    private ArrayList<BaseDeck> otherDecks = null;
    IBlockState reactorFrame = GeneratorsBlocks.Reactor.func_176203_a(1);
    IBlockState reactorController = GeneratorsBlocks.Reactor.func_176223_P();
    IBlockState reactorGlass = GeneratorsBlocks.ReactorGlass.func_176223_P();
    IBlockState reactorPort = GeneratorsBlocks.Reactor.func_176203_a(2);

    public BaseDeck() {
    }

    public BaseDeck(BaseConfiguration configuration, Random rand, int blockPosX, int blockPosY, int blockPosZ, int tier, EnumFacing dir) {
        super(configuration, configuration.getCorridorWidth() + 1, configuration.getRoomHeight() + 1, configuration.getCorridorLength(), dir);
        this.roomsOnSide = configuration.getRoomsNo();
        this.roomDepth = configuration.getRoomDepth() + (tier == 0 ? 1 : 0);
        this.deckTier = tier;
        this.func_186164_a(EnumFacing.NORTH);
        if (this.getDirection().func_176740_k() == EnumFacing.Axis.X) {
            int w = this.sizeX;
            this.sizeX = this.sizeZ;
            this.sizeZ = w;
        }
        int xMin = blockPosX - this.sizeX / 2;
        int zMin = blockPosZ - this.sizeZ / 2;
        this.field_74887_e = new StructureBoundingBox(xMin, blockPosY, zMin, xMin + this.sizeX, blockPosY + this.sizeY, zMin + this.sizeZ);
        if (this.roomsOnSide <= 1) {
            this.largeRoomPosA = 0;
            this.largeRoomPosB = 2;
        } else {
            this.largeRoomPosA = rand.nextInt(this.roomsOnSide - 1);
            this.largeRoomPosB = this.largeRoomPosA + 1 + rand.nextInt(this.roomsOnSide - this.largeRoomPosA - 1);
        }
        if (tier == 1) {
            this.createOtherDecks(configuration, rand, blockPosX, blockPosY, blockPosZ);
        }
        if ((tier & 4) == 4) {
            this.roomDepth -= 2;
            if (this.getDirection().func_176740_k() == EnumFacing.Axis.X) {
                this.sizeZ += 4;
            } else {
                this.sizeX += 4;
            }
            xMin = blockPosX - this.sizeX / 2;
            zMin = blockPosZ - this.sizeZ / 2;
            switch (this.getDirection()) {
                case NORTH: {
                    ++this.sizeZ;
                    break;
                }
                case SOUTH: {
                    --zMin;
                    ++this.sizeZ;
                    break;
                }
                case WEST: {
                    ++this.sizeX;
                    break;
                }
                default: {
                    --xMin;
                    ++this.sizeX;
                }
            }
            this.field_74887_e = new StructureBoundingBox(xMin, blockPosY, zMin, xMin + this.sizeX, blockPosY + this.sizeY, zMin + this.sizeZ);
        }
    }

    private void createOtherDecks(BaseConfiguration configuration, Random rand, int blockPosX, int blockPosY, int blockPosZ) {
        this.otherDecks = new ArrayList();
        if (this.configuration.isHangarDeck()) {
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY + 1, blockPosZ, 6, this.direction));
        } else {
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY, blockPosZ, 0, this.direction));
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY + this.sizeY, blockPosZ, 2, this.direction));
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        int details = this.deckTier + (this.largeRoomPosA << 4) + (this.largeRoomPosB << 8);
        tagCompound.func_74768_a("dD", details);
        if (this.otherDecks != null) {
            NBTTagList tagList = new NBTTagList();
            for (BaseDeck deck : this.otherDecks) {
                NBTTagCompound tag1 = new NBTTagCompound();
                deck.func_143012_a(tag1);
                tagList.func_74742_a((NBTBase)tag1);
            }
            tagCompound.func_74782_a("oD", (NBTBase)tagList);
        }
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        try {
            int details = tagCompound.func_74762_e("dD");
            this.deckTier = details & 0xF;
            this.largeRoomPosB = details >> 8;
            this.largeRoomPosA = details >> 4 & 0xF;
            this.roomsOnSide = this.configuration.getRoomsNo();
            this.roomDepth = this.configuration.getRoomDepth() + (this.deckTier == 0 ? 1 : 0) - ((this.deckTier & 4) == 4 ? 3 : 0);
            if (tagCompound.func_74764_b("oD")) {
                NBTTagList tagList = tagCompound.func_150295_c("oD", 10);
                this.otherDecks = new ArrayList();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tagAt = tagList.func_150305_b(i);
                    BaseDeck deck = new BaseDeck();
                    deck.func_143011_b(tagAt, manager);
                    this.otherDecks.add(deck);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read Abandoned Base configuration from NBT");
            System.err.println(tagCompound);
        }
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox chunkBounds) {
        int i;
        int leftX;
        int ceilingSpacer;
        IBlockState blockWall = this.configuration.getWallBlock();
        IBlockState blockGrid = AsteroidBlocks.blockWalkway.func_176223_P();
        Block blockStair = GCBlocks.moonStoneStairs;
        IBlockState blockAir = Blocks.field_150350_a.func_176223_P();
        boolean directionNS = this.getDirection().func_176740_k() == EnumFacing.Axis.Z;
        int ceilingDeco = ceilingSpacer = (directionNS ? this.sizeZ : this.sizeX) / this.roomsOnSide + 1;
        int startX = 0;
        int startZ = 0;
        int endX = this.sizeX;
        int endZ = this.sizeZ;
        int endY = this.sizeY;
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = 0; y <= endY; ++y) {
                    if (x == startX || x == endX || y == 0 || y == endY || z == startZ || z == endZ) {
                        int hangarOffset;
                        boolean skipCap = false;
                        if (this.configuration.isHangarDeck() && this.deckTier == 1 && (this.getDirection() == EnumFacing.NORTH && z == endZ || this.getDirection() == EnumFacing.SOUTH && z == startZ || this.getDirection() == EnumFacing.WEST && x == endX || this.getDirection() == EnumFacing.EAST && x == startX)) {
                            IBlockState blockLintel = GCBlocks.airLockFrame.func_176223_P();
                            IBlockState blockAirlock = GCBlocks.airLockFrame.func_176203_a(1);
                            if ((!directionNS && (z == startZ + 1 || z == endZ - 1) || directionNS && (x == startX + 1 || x == endX - 1)) && y < this.sizeY - 1) {
                                this.func_175811_a(worldIn, blockLintel, x, y, z, chunkBounds);
                            } else if (y >= endY - 1 || directionNS && (x == startX || x == endX) || !directionNS && (z == startZ || z == endZ)) {
                                this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                            } else if (y == 0 || y == endY - 2) {
                                if (y == 0 && (!directionNS && z == (startZ + endZ) / 2 || directionNS && x == (startX + endX) / 2)) {
                                    this.func_175811_a(worldIn, blockAirlock, x, y, z, chunkBounds);
                                } else {
                                    this.func_175811_a(worldIn, blockLintel, x, y, z, chunkBounds);
                                }
                                skipCap = true;
                            } else {
                                this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                            }
                        } else if ((y != 0 || (this.deckTier & 1) != 1) && (y != endY || (this.deckTier & 1) != 2) || (!directionNS || z != startZ && z != endZ) && (directionNS || x != startX && x != endX)) {
                            if (y == 0 && (this.deckTier & 1) == 1 && this.configuration.getDeckType() == EnumBaseType.HUMANOID && (directionNS && (x == startX + 2 + (this.configuration.isHangarDeck() ? 1 : 0) || x == startX + 4 + (this.configuration.isHangarDeck() ? 1 : 0)) || !directionNS && (z == startZ + 2 + (this.configuration.isHangarDeck() ? 1 : 0) || z == startZ + 4 + (this.configuration.isHangarDeck() ? 1 : 0)))) {
                                this.func_175811_a(worldIn, blockGrid, x, y, z, chunkBounds);
                            } else if (!this.configuration.isHangarDeck() && (this.getDirection() == EnumFacing.SOUTH && z == endZ || this.getDirection() == EnumFacing.NORTH && z == startZ || this.getDirection() == EnumFacing.EAST && x == endX || this.getDirection() == EnumFacing.WEST && x == startX)) {
                                int endW;
                                int startW;
                                int w;
                                IBlockState windowOrWall = blockWall;
                                switch (this.configuration.getDeckType()) {
                                    default: 
                                }
                                IBlockState blockGlass = GCBlocks.spaceGlassTinClear.func_176223_P();
                                if (directionNS) {
                                    w = x;
                                    startW = startX;
                                    endW = endX;
                                } else {
                                    w = z;
                                    startW = startZ;
                                    endW = endZ;
                                }
                                int edge = 0;
                                if ((y == 2 || y == 3) && w > startW + edge && w < endW - edge) {
                                    windowOrWall = blockGlass;
                                }
                                this.func_175811_a(worldIn, windowOrWall, x, y, z, chunkBounds);
                            } else {
                                this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                            }
                        }
                        int n = hangarOffset = this.configuration.isHangarDeck() ? 1 : 0;
                        if (y != 0 || (this.deckTier & 1) != 1 || this.configuration.getDeckType() != EnumBaseType.HUMANOID || (!directionNS || x < startX + 2 + hangarOffset || x > startX + 4 + hangarOffset) && (directionNS || z < startZ + 2 + hangarOffset || z > startZ + 4 + hangarOffset) || (!directionNS || z != startZ && z != endZ) && (directionNS || x != startX && x != endX) || skipCap) continue;
                        this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                        continue;
                    }
                    this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                }
                if (endY == this.sizeY) continue;
                this.func_175811_a(worldIn, blockWall, x, this.sizeY, z, chunkBounds);
            }
        }
        int rightX = leftX = (this.deckTier & 4) == 4 && (this.direction == EnumFacing.SOUTH || this.direction == EnumFacing.EAST) ? 3 : 2;
        int leftZ = leftX;
        int rightZ = rightX;
        for (i = 0; i < this.roomsOnSide; ++i) {
            int largeRoomOffset;
            boolean largeRoom = i == this.largeRoomPosA || i == this.largeRoomPosB;
            int roomsize = largeRoom ? 8 : 6;
            int n = largeRoomOffset = largeRoom ? 2 : 1;
            if (directionNS) {
                this.makeDoorway(worldIn, this.sizeX, leftZ + largeRoomOffset, directionNS, chunkBounds);
                this.makeDoorway(worldIn, 0, rightZ + largeRoomOffset, directionNS, chunkBounds);
                leftZ += roomsize;
                rightZ += roomsize;
                continue;
            }
            this.makeDoorway(worldIn, leftX + largeRoomOffset, this.sizeZ, directionNS, chunkBounds);
            this.makeDoorway(worldIn, rightX + largeRoomOffset, 0, directionNS, chunkBounds);
            leftX += roomsize;
            rightX += roomsize;
        }
        if (directionNS) {
            this.func_186164_a(this.direction);
        } else {
            this.func_186164_a(this.direction.func_176734_d());
        }
        if (this.configuration.isHangarDeck() && this.deckTier == 1) {
            int n = i = directionNS ? this.sizeX : this.sizeZ;
        }
        if ((this.deckTier & 4) == 4) {
            TileEntityReactorController reactorController1;
            int torgz;
            int torgy;
            int torgx;
            switch (this.configuration.getDeckType()) {
                default: 
            }
            IBlockState blockGlass = Block.func_149634_a((Item)BlockDecorativeGlass.DecorStates.glass.get().func_77973_b()).func_176223_P();
            if (!directionNS) {
                int w = endX;
                endX = endZ;
                endZ = w;
            }
            for (int y = 1; y < 5; ++y) {
                for (int x = 2; x < endX - 1; ++x) {
                    this.func_175811_a(worldIn, blockGlass, x, y, endZ, chunkBounds);
                }
            }
            Rotation ladderfacing = Rotation.CLOCKWISE_180;
            switch (this.direction) {
                case EAST: {
                    ladderfacing = Rotation.NONE;
                    break;
                }
                case WEST: {
                    ladderfacing = Rotation.NONE;
                }
            }
            for (int ladderx = 5; ladderx <= 7; ++ladderx) {
                for (int laddery = -8; laddery <= 1; ++laddery) {
                    this.func_175811_a(worldIn, TFBlocks.iron_ladder.func_176223_P().func_185907_a(ladderfacing), ladderx, laddery, 1, chunkBounds);
                }
            }
            for (torgx = 3; torgx < 10; ++torgx) {
                for (torgy = -1; torgy < 1; ++torgy) {
                    for (torgz = 5; torgz < 12; ++torgz) {
                        this.func_175811_a(worldIn, Block.func_149634_a((Item)BlockDecorativeGlass.DecorStates.glass.get().func_77973_b()).func_176223_P(), torgx, torgy, endZ - torgz, chunkBounds);
                    }
                }
            }
            for (torgx = 5; torgx < 8; ++torgx) {
                for (torgy = -1; torgy < 1; ++torgy) {
                    for (torgz = 7; torgz < 10; ++torgz) {
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), torgx, torgy, endZ - torgz, chunkBounds);
                    }
                }
            }
            int facingLamp = 2;
            switch (this.direction) {
                case WEST: {
                    facingLamp = 5;
                    break;
                }
                case EAST: {
                    facingLamp = 4;
                    break;
                }
                case NORTH: {
                    facingLamp = 3;
                    break;
                }
                case SOUTH: {
                    facingLamp = 2;
                }
            }
            this.func_175811_a(worldIn, GCBlocks.brightLamp.func_176203_a(facingLamp), 6, -2, endZ - 2, chunkBounds);
            this.func_175811_a(worldIn, GCBlocks.brightLamp.func_176203_a(facingLamp), 6, 7, endZ - 1, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 6, -3, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -3, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorPort, 6, -3, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -3, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 6, -3, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, -3, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 5, -3, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, -3, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, -3, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 7, -3, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, -3, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -3, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, -3, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -2, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 4, -2, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -2, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 4, -1, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 4, -1, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 4, -1, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, 0, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 4, 0, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, 0, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, -2, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 8, -2, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, -2, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 8, -1, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 8, -1, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 8, -1, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, 0, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 8, 0, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, 0, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, -2, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -2, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, -2, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 5, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 7, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, 0, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, 0, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, 0, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, -1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, -2, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -2, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, -2, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 5, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 7, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, 0, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, 0, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, 0, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, -1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 6, 1, endZ - 6, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, 1, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorGlass, 6, 1, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 6, 1, endZ - 10, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, 1, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorPort, 5, 1, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 5, 1, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, 1, endZ - 7, chunkBounds);
            this.func_175811_a(worldIn, this.reactorPort, 7, 1, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 7, 1, endZ - 9, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 4, 1, endZ - 8, chunkBounds);
            this.func_175811_a(worldIn, this.reactorFrame, 8, 1, endZ - 8, chunkBounds);
            BlockPos blockpos = new BlockPos(this.func_74874_b().field_78897_a + 6, this.func_74874_b().field_78895_b + 1, this.func_74874_b().field_78896_c + endZ - 8);
            this.func_175811_a(worldIn, this.reactorController, 6, 1, endZ - 8, chunkBounds);
            if (worldIn.func_175625_s(blockpos) != null && worldIn.func_175625_s(blockpos) instanceof TileEntityReactorController && (reactorController1 = (TileEntityReactorController)worldIn.func_175625_s(blockpos)) != null) {
                reactorController1.onAdded();
            }
            int facing = 0;
            switch (this.direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    facing = 2;
                    break;
                }
                case EAST: {
                    facing = 1;
                    break;
                }
                case WEST: {
                    facing = 3;
                }
            }
        }
        this.func_186164_a(EnumFacing.NORTH);
        return true;
    }

    public List<Piece> getRooms(int roomIndex, BaseStart startPiece, Random rand) {
        ArrayList<Piece> rooms;
        block16: {
            Iterator<BaseDeck> iterator;
            int blockZ;
            int blockX;
            int rightZ;
            rooms = new ArrayList<Piece>();
            boolean directionNS = this.getDirection().func_176740_k() == EnumFacing.Axis.Z;
            EnumFacing left = directionNS ? EnumFacing.WEST : EnumFacing.SOUTH;
            EnumFacing right = directionNS ? EnumFacing.EAST : EnumFacing.NORTH;
            int leftX = directionNS ? this.field_74887_e.field_78893_d + 1 : this.field_74887_e.field_78897_a;
            int leftZ = directionNS ? this.field_74887_e.field_78896_c : this.field_74887_e.field_78892_f + 1;
            int rightX = directionNS ? this.field_74887_e.field_78897_a - this.roomDepth - 1 : this.field_74887_e.field_78897_a;
            int n = rightZ = directionNS ? this.field_74887_e.field_78896_c : this.field_74887_e.field_78896_c - this.roomDepth - 1;
            if ((this.deckTier & 4) == 4 && this.direction == EnumFacing.SOUTH) {
                ++rightZ;
                ++leftZ;
            }
            if ((this.deckTier & 4) == 4 && this.direction == EnumFacing.EAST) {
                ++rightX;
                ++leftX;
            }
            for (int i = 0; i < this.roomsOnSide; ++i) {
                boolean largeRoom = i == this.largeRoomPosA || i == this.largeRoomPosB;
                int roomsize = largeRoom ? 8 : 6;
                rooms.add(this.getRoom(roomIndex++, left, leftX, leftZ, largeRoom, true, rand));
                rooms.add(this.getRoom(roomIndex++, right, rightX, rightZ, largeRoom, false, rand));
                if (directionNS) {
                    leftZ += roomsize;
                    rightZ += roomsize;
                    continue;
                }
                leftX += roomsize;
                rightX += roomsize;
            }
            if (this.configuration.isHangarDeck() && (this.deckTier & 1) == 1) {
                blockX = 0;
                blockZ = 0;
                switch (this.direction) {
                    case NORTH: {
                        blockX = this.field_74887_e.field_78897_a + (this.sizeX - 26) / 2;
                        blockZ = this.field_74887_e.field_78892_f + 1;
                        break;
                    }
                    case SOUTH: {
                        blockX = this.field_74887_e.field_78897_a + (this.sizeX - 26) / 2;
                        blockZ = this.field_74887_e.field_78896_c - 1 - 42;
                        break;
                    }
                    case WEST: {
                        blockX = this.field_74887_e.field_78893_d + 1;
                        blockZ = this.field_74887_e.field_78896_c + (this.sizeZ - 26) / 2;
                        break;
                    }
                    default: {
                        blockX = this.field_74887_e.field_78897_a - 1 - 42;
                        blockZ = this.field_74887_e.field_78896_c + (this.sizeZ - 26) / 2;
                    }
                }
                rooms.add(new BaseHangar(this.configuration, rand, blockX, blockZ, this.direction.func_176734_d()));
            }
            if ((this.configuration.isHangarDeck() || this.configuration.getDeckType() == EnumBaseType.HUMANOID) && (this.deckTier & 1) == 1) {
                blockX = this.field_74887_e.field_78897_a;
                blockZ = this.field_74887_e.field_78896_c;
                int sX = this.sizeX;
                int sZ = this.sizeZ;
                switch (this.direction) {
                    case NORTH: {
                        ++blockZ;
                        --sZ;
                        if (this.configuration.isHangarDeck()) break;
                        --sZ;
                        break;
                    }
                    case SOUTH: {
                        --sZ;
                        if (this.configuration.isHangarDeck()) break;
                        ++blockZ;
                        --sZ;
                        break;
                    }
                    case WEST: {
                        ++blockX;
                        --sX;
                        if (this.configuration.isHangarDeck()) break;
                        --sX;
                        break;
                    }
                    default: {
                        --sX;
                        if (this.configuration.isHangarDeck()) break;
                        ++blockX;
                        --sX;
                    }
                }
                rooms.add(new BasePlate(this.configuration, blockX, this.field_74887_e.field_78895_b - 1, blockZ, sX, sZ, this.direction));
            }
            if (this.otherDecks == null || !(iterator = this.otherDecks.iterator()).hasNext()) break block16;
            BaseDeck deck = iterator.next();
            rooms.add(deck);
            List<Piece> newRooms = deck.getRooms(roomIndex, startPiece, rand);
            rooms.addAll(newRooms);
            roomIndex += newRooms.size();
        }
        return rooms;
    }

    protected void makeDoorway(World worldIn, int x, int z, boolean directionNS, StructureBoundingBox chunkBounds) {
        IBlockState blockLintel = GCBlocks.airLockFrame.func_176223_P();
        IBlockState blockAirlock = GCBlocks.airLockFrame.func_176203_a(1);
        Block blockStair = GCBlocks.moonStoneStairs;
        IBlockState blockAir = Blocks.field_150350_a.func_176223_P();
        int meta = directionNS ? 2 : 0;
        switch (this.configuration.getDeckType()) {
            case HUMANOID: {
                if (directionNS) {
                    --z;
                } else {
                    --x;
                }
                this.func_175811_a(worldIn, blockLintel, x, 0, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockAir, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockAir, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockAirlock, x, 0, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockLintel, x, 0, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                break;
            }
        }
    }

    protected Piece getRoom(int i, EnumFacing dir, int blockX, int blockZ, boolean large, boolean left, Random rand) {
        int sX;
        int sZ = sX = large ? 8 : 6;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            sZ = this.roomDepth;
        } else {
            sX = this.roomDepth;
        }
        int sY = this.sizeY;
        return new BaseRoom(this.configuration, rand, blockX, this.field_74887_e.field_78895_b, blockZ, sX, sY, sZ, dir, this.configuration.getRandomRoom(i), left ? i == 0 : i == this.roomsOnSide - 1, left ? i == this.roomsOnSide - 1 : i == 0, this.deckTier);
    }

    public static enum EnumBaseType {
        HUMANOID(10, 6, GCBlocks.basicBlock.func_176203_a(4), new ItemStack(Items.field_151073_bk, 3, 0));

        public final int height;
        public final int width;
        public final IBlockState wall;
        public final ItemStack treasure;

        private EnumBaseType(int height, int width, IBlockState wallBlock, ItemStack treasure) {
            this.height = height;
            this.width = width;
            this.wall = wallBlock;
            this.treasure = treasure;
        }
    }
}

