/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import com.google.common.collect.Maps;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.client.DisplayHelper;
import gigaherz.guidebook.guidebook.BookDocument;
import gigaherz.guidebook.guidebook.client.BookRegistry;
import gigaherz.guidebook.guidebook.client.BookRendering;
import gigaherz.guidebook.guidebook.client.IAnimatedBookBackground;
import gigaherz.guidebook.guidebook.conditions.ConditionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.torgy.torgo.TorgoPrint;

public class GuiGuidebook
extends GuiScreen {
    private static final ResourceLocation BOOK_GUI_TEXTURES = GuidebookMod.location("textures/gui/book.png");
    public static boolean useNaturalArrows = false;
    public final ResourceLocation bookLocation;
    int numberOfButtons = 20;
    ArrayList termsPlain = new ArrayList();
    private GuiButton buttonClose;
    private GuiButton buttonNextPage;
    private GuiButton buttonPreviousPage;
    private GuiButton buttonNextChapter;
    private GuiButton buttonPreviousChapter;
    private GuiButton buttonBack;
    private GuiButton buttonHome;
    private final ArrayList<TorgoButton> guiButtons = new ArrayList();
    private int currentButton = 0;
    private GuiTextField searchTextField;
    private final ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
    private final TextureManager renderEngine;
    private BookRendering book;
    private IAnimatedBookBackground background;
    private final Map<String, String> searchTerms;
    private boolean initialized;

    public GuiGuidebook(ResourceLocation book) {
        this.renderEngine = Minecraft.func_71410_x().field_71446_o;
        this.searchTerms = Maps.newHashMap();
        this.initialized = false;
        this.bookLocation = book;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        if (!this.initialized) {
            this.initialized = true;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ConditionContext conditionContext = new ConditionContext();
            conditionContext.setPlayer(player);
            BookDocument theBook = BookRegistry.get(this.bookLocation);
            this.book = (BookRendering)theBook.getRendering();
            boolean conditions = theBook.reevaluateConditions(conditionContext);
            if (this.book == null) {
                this.book = new BookRendering(theBook, this);
                theBook.setRendering(this.book);
            } else {
                this.book.setGui(this);
                if (conditions || this.book.refreshScalingFactor()) {
                    this.book.resetRendering(conditions);
                }
            }
            for (int i = 0; i < this.book.getBook().chapterCount(); ++i) {
                for (Map.Entry<String, String> set : this.book.getBook().getChapter((int)i).descriptions.entrySet()) {
                    this.searchTerms.put(set.getKey().toLowerCase(), set.getValue());
                }
            }
            this.background = this.book.createBackground(this);
            int btnId = 0;
            int left = (this.field_146294_l - 286) / 2;
            int right = left + 286;
            int center = this.field_146294_l / 4;
            int top = (this.field_146295_m - 198) / 2 - 9;
            int bottom = top + 198;
            this.buttonHome = new SpriteButton(btnId++, center - 7, bottom - 13, 6);
            this.buttonBack = new SpriteButton(btnId++, left + 8, top - 5, 2);
            this.buttonClose = new SpriteButton(btnId++, right - 6, top - 6, 3);
            if (useNaturalArrows) {
                this.buttonPreviousPage = new SpriteButton(btnId++, left + 24, bottom - 13, 1);
                this.buttonNextPage = new SpriteButton(btnId++, right - 42, bottom - 13, 0);
                this.buttonPreviousChapter = new SpriteButton(btnId++, left + 2, bottom - 13, 5);
                this.buttonNextChapter = new SpriteButton(btnId++, right - 23, bottom - 13, 4);
            } else {
                this.buttonPreviousPage = new SpriteButton(btnId++, left + 24, bottom - 13, 0);
                this.buttonNextPage = new SpriteButton(btnId++, right - 42, bottom - 13, 1);
                this.buttonPreviousChapter = new SpriteButton(btnId++, left + 2, bottom - 13, 4);
                this.buttonNextChapter = new SpriteButton(btnId++, right - 23, bottom - 13, 5);
            }
            int y = 2;
            int height = 19;
            int width = 300;
            int x = this.field_146294_l / 2 - width / 2;
            for (int i = 0; i < this.numberOfButtons; ++i) {
                this.guiButtons.add(new TorgoButton(btnId++, x, this.numberOfButtons * y++, width, height, ""));
            }
        }
        this.field_146292_n.add(this.buttonHome);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.field_146292_n.add(this.buttonNextPage);
        for (int i = 0; this.numberOfButtons > i; ++i) {
            this.guiButtons.get((int)i).field_146125_m = false;
            this.guiButtons.get((int)i).field_146124_l = false;
            this.field_146292_n.add(this.guiButtons.get(i));
        }
        this.updateButtonStates();
        this.repositionButtons();
        int half = this.field_146294_l / 2;
        this.searchTextField = new GuiTextField(99, this.field_146289_q, half - 70, 10, 140, 20);
        this.searchTextField.func_146203_f(50);
        this.searchTextField.func_146180_a("");
        this.searchTextField.func_146195_b(true);
    }

    private void setupConditionsAndPosition() {
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        this.func_183500_a(i, j);
        if (this.book.refreshScalingFactor()) {
            this.book.resetRendering(false);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.buttonClose.field_146127_k) {
                this.background.startClosing();
            } else if (button.field_146127_k == this.buttonHome.field_146127_k) {
                this.book.navigateHome();
            } else if (button.field_146127_k == this.buttonBack.field_146127_k) {
                this.book.navigateBack();
            } else if (button.field_146127_k == this.buttonNextPage.field_146127_k) {
                this.book.nextPage();
            } else if (button.field_146127_k == this.buttonPreviousPage.field_146127_k) {
                this.book.prevPage();
            } else if (button.field_146127_k == this.buttonNextChapter.field_146127_k) {
                this.book.nextChapter();
            } else if (button.field_146127_k == this.buttonPreviousChapter.field_146127_k) {
                this.book.prevChapter();
            } else {
                this.processSearchTerm(true);
            }
            this.updateButtonStates();
            this.searchTextField.func_146180_a("");
            this.searchTextField.func_146195_b(true);
            this.processSearchTerm();
        }
    }

    private void updateButtonStates() {
        this.buttonClose.field_146124_l = this.background.isFullyOpen();
        this.buttonHome.field_146124_l = this.background.isFullyOpen() && this.book.getBook().home != null;
        this.buttonBack.field_146124_l = this.background.isFullyOpen() && this.book.canGoBack();
        this.buttonNextPage.field_146124_l = this.background.isFullyOpen() && this.book.canGoNextPage();
        this.buttonPreviousPage.field_146124_l = this.background.isFullyOpen() && this.book.canGoPrevPage();
        this.buttonNextChapter.field_146124_l = this.background.isFullyOpen() && this.book.canGoNextChapter();
        this.buttonPreviousChapter.field_146124_l = this.background.isFullyOpen() && this.book.canGoPrevChapter();
        this.buttonClose.field_146125_m = this.buttonClose.field_146124_l;
        this.buttonHome.field_146125_m = this.buttonHome.field_146124_l;
        this.buttonBack.field_146125_m = this.buttonBack.field_146124_l;
        this.buttonNextPage.field_146125_m = this.buttonNextPage.field_146124_l;
        this.buttonPreviousPage.field_146125_m = this.buttonPreviousPage.field_146124_l;
        this.buttonNextChapter.field_146125_m = this.buttonNextChapter.field_146124_l;
        this.buttonPreviousChapter.field_146125_m = this.buttonPreviousChapter.field_146124_l;
    }

    public void func_73876_c() {
        if (this.background.update()) {
            this.field_146297_k.func_147108_a(null);
        }
        this.searchTextField.func_146178_a();
        this.updateButtonStates();
    }

    private void setMousePosition(int x, int y, int curButton) {
        int i = this.field_146297_k.field_71443_c * (x + 295) / this.field_146294_l;
        int k = y * 2 + 10;
        Mouse.setCursorPosition((int)(i + 15), (int)k);
        Mouse.destroy();
        try {
            Mouse.create();
        }
        catch (LWJGLException e) {
            TorgoPrint.torgoP((Object[])new Object[]{"MOUSE ERROR: ", e});
        }
        for (int j = 0; j < this.guiButtons.size(); ++j) {
            this.guiButtons.get(j).setHighlighted(j == curButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 203) {
            this.book.prevPage();
            return;
        }
        if (keyCode == 205) {
            this.book.nextPage();
            return;
        }
        this.searchTextField.func_146201_a(typedChar, keyCode);
        if (keyCode == 1 && this.searchTextField.func_146179_b() != "" && this.searchTextField.func_146179_b() != "Search") {
            this.searchTextField.func_146180_a("");
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
        if (keyCode == 208) {
            ++this.currentButton;
            if (this.numberOfButtons - 1 < this.currentButton || !this.guiButtons.get((int)this.currentButton).field_146125_m || !this.guiButtons.get((int)this.currentButton).field_146124_l) {
                --this.currentButton;
                return;
            }
            this.setMousePosition(this.guiButtons.get((int)this.currentButton).field_146128_h, this.guiButtons.get((int)this.currentButton).field_146129_i, this.currentButton);
        } else if (keyCode == 200) {
            --this.currentButton;
            if (this.currentButton < 0) {
                this.currentButton = 0;
            }
            this.setMousePosition(this.guiButtons.get((int)this.currentButton).field_146128_h, this.guiButtons.get((int)this.currentButton).field_146129_i, this.currentButton);
        } else if (keyCode == 28) {
            this.processSearchTerm(true);
        } else {
            this.processSearchTerm();
            if (typedChar >= 'a' && typedChar <= 'z' || typedChar >= 'A' && typedChar <= 'Z' || typedChar >= '0' && typedChar <= '9' || typedChar == ' ' || keyCode == 211 || keyCode == 14) {
                this.searchTextField.func_146195_b(true);
                this.currentButton = 0;
                this.setMousePosition(this.guiButtons.get((int)this.currentButton).field_146128_h, this.guiButtons.get((int)this.currentButton).field_146129_i, this.currentButton);
            }
        }
    }

    public void goToSection(String target) {
        this.book.navigateByNameTo(this.searchTerms.get(target));
        this.searchTextField.func_146195_b(true);
    }

    public void processSearchTerm() {
        this.processSearchTerm(false);
    }

    public void processSearchTerm(Boolean goForIt) {
        this.termsPlain.clear();
        int y = 0;
        String colorString = "a";
        String origColorString = "r";
        String textString = "";
        if (this.searchTextField.func_146179_b().length() > 0 && !this.searchTextField.func_146179_b().isEmpty() && !this.searchTextField.func_146179_b().equals("Search")) {
            int i;
            for (i = 0; i < this.book.getBook().chapterCount(); ++i) {
                for (Map.Entry<String, String> set : this.book.getBook().getChapter((int)i).descriptions.entrySet()) {
                    if (!set.getKey().toLowerCase().contains(this.searchTextField.func_146179_b().toLowerCase())) continue;
                    this.termsPlain.add(set.getKey().toLowerCase());
                }
            }
            if (goForIt.booleanValue()) {
                for (i = 0; this.numberOfButtons > i; ++i) {
                    if (!this.guiButtons.get(i).highlighted || !this.guiButtons.get((int)i).field_146124_l || !this.guiButtons.get((int)i).field_146125_m) continue;
                    this.goToSection(this.guiButtons.get(i).getString());
                    break;
                }
                this.searchTextField.func_146180_a("");
            } else {
                Collections.sort(this.termsPlain);
                for (i = 0; this.termsPlain.size() > i && this.numberOfButtons != i; ++i) {
                    this.guiButtons.get(i).setString(this.termsPlain.get(i).toString());
                    this.guiButtons.get((int)i).field_146126_j = this.termsPlain.get(i).toString().toUpperCase().replaceAll(this.searchTextField.func_146179_b().toUpperCase(), "\u00a7" + colorString + this.searchTextField.func_146179_b().toUpperCase() + "\u00a7" + origColorString);
                    this.guiButtons.get((int)i).field_146125_m = true;
                    this.guiButtons.get((int)i).field_146124_l = true;
                    ++y;
                }
            }
        }
        while (y < this.numberOfButtons) {
            this.guiButtons.get((int)y).field_146125_m = false;
            this.guiButtons.get((int)y).field_146124_l = false;
            ++y;
        }
        this.repositionButtons();
        this.searchTextField.func_146195_b(true);
    }

    private void repositionButtons() {
        this.setupConditionsAndPosition();
        double bookScale = this.book.getScalingFactor() / (double)this.book.getBook().getFontSize();
        double bookWidth = 286.0 * bookScale;
        double bookHeight = 198.0 * bookScale;
        int left = (int)(((double)this.field_146294_l - bookWidth) / 2.0);
        int center = this.field_146294_l / 2;
        int right = (int)((double)left + bookWidth);
        int top = (int)(((double)this.field_146295_m - bookHeight) / 2.0);
        int bottom = (int)((double)top + bookHeight);
        int leftLeft = left;
        int rightRight = right;
        int topTop = top - 16 + (int)(8.0 * bookScale);
        int bottomBottom = bottom + 2;
        this.buttonHome.field_146128_h = center - 7;
        this.buttonHome.field_146129_i = bottomBottom;
        this.buttonBack.field_146128_h = leftLeft + 18;
        this.buttonBack.field_146129_i = topTop + 3;
        this.buttonClose.field_146128_h = rightRight - 12;
        this.buttonClose.field_146129_i = topTop;
        this.buttonPreviousPage.field_146128_h = leftLeft + 22;
        this.buttonPreviousPage.field_146129_i = bottomBottom;
        this.buttonPreviousChapter.field_146128_h = leftLeft;
        this.buttonPreviousChapter.field_146129_i = bottomBottom;
        this.buttonNextPage.field_146128_h = rightRight - 16 - 18;
        this.buttonNextPage.field_146129_i = bottomBottom;
        this.buttonNextChapter.field_146128_h = rightRight - 16;
        this.buttonNextChapter.field_146129_i = bottomBottom;
        for (int i = 0; this.numberOfButtons > i; ++i) {
            this.guiButtons.get((int)i).field_146128_h = center - 150;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        double backgroundScale = this.book.getScalingFactor() / (double)this.book.getBook().getFontSize();
        double bookHeight = 198.0 * backgroundScale;
        this.background.draw(partialTicks, (int)bookHeight, (float)backgroundScale);
        if (this.background.isFullyOpen()) {
            this.book.drawCurrentPages();
        }
        this.searchTextField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.background.isFullyOpen()) {
            this.book.mouseHover(mouseX, mouseY);
        }
        if (System.currentTimeMillis() < DisplayHelper.displayTime) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaled = new ScaledResolution(mc);
            int screenWidth = scaled.func_78326_a();
            int screenHeight = scaled.func_78328_b();
            int x = screenWidth / 2;
            int y = (int)((double)screenHeight * 0.6);
            float scale = 1.5f;
            GL11.glPushMatrix();
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            int scaledX = (int)((float)x / scale - (float)(mc.field_71466_p.func_78256_a(DisplayHelper.displayText) / 2) / scale);
            int scaledY = (int)((float)y / scale);
            mc.field_71466_p.func_175065_a(DisplayHelper.displayText, (float)scaledX, (float)scaledY, 0xFFFFFF, true);
            GL11.glPopMatrix();
        }
    }

    public void drawTooltip(ItemStack stack, int x, int y) {
        this.func_146285_a(stack, x, y);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.hasWheel() && Mouse.getEventDWheel() != 0) {
            if (Math.signum(Mouse.getEventDWheel()) < 0.0f) {
                this.searchTextField.func_146180_a("");
                this.processSearchTerm();
                this.book.nextPage();
            } else {
                this.searchTextField.func_146180_a("");
                this.processSearchTerm();
                this.book.prevPage();
            }
        }
        this.searchTextField.func_146195_b(true);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.book.mouseClicked(mouseButton)) {
            return;
        }
        if (mouseButton == 3) {
            this.book.navigateBack();
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchTextField.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.searchTextField.func_146206_l()) {
            this.searchTextField.func_146180_a("");
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public ItemModelMesher getMesher() {
        return this.mesher;
    }

    public TextureManager getRenderEngine() {
        return this.renderEngine;
    }

    @SideOnly(value=Side.CLIENT)
    public class TorgoButton
    extends GuiButton {
        private boolean highlighted;
        private String buttonString;

        public TorgoButton(int id, int x, int y, int width, int height, String text) {
            super(id, x, y, width, height, text);
        }

        public void setHighlighted(boolean status) {
            this.highlighted = status;
        }

        public String getString() {
            return this.buttonString;
        }

        public void setString(String string) {
            this.buttonString = string;
        }

        public boolean func_146115_a() {
            if (this.field_146123_n) {
                for (int i = 0; i < GuiGuidebook.this.guiButtons.size(); ++i) {
                    if (GuiGuidebook.this.guiButtons.get(i) != null && ((TorgoButton)((Object)GuiGuidebook.this.guiButtons.get(i))).getString() != null && ((TorgoButton)((Object)GuiGuidebook.this.guiButtons.get(i))).getString().equals(this.getString())) {
                        ((TorgoButton)((Object)((GuiGuidebook)GuiGuidebook.this).guiButtons.get((int)i))).highlighted = true;
                        GuiGuidebook.this.currentButton = i;
                        continue;
                    }
                    ((TorgoButton)((Object)((GuiGuidebook)GuiGuidebook.this).guiButtons.get((int)i))).highlighted = false;
                }
            }
            return this.highlighted;
        }

        public void func_191745_a(Minecraft p_drawButton_1_, int p_drawButton_2_, int p_drawButton_3_, float p_drawButton_4_) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = p_drawButton_1_.field_71466_p;
                p_drawButton_1_.func_110434_K().func_110577_a(field_146122_a);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = this.highlighted || p_drawButton_2_ >= this.field_146128_h && p_drawButton_3_ >= this.field_146129_i && p_drawButton_2_ < this.field_146128_h + this.field_146120_f && p_drawButton_3_ < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
                this.func_146119_b(p_drawButton_1_, p_drawButton_2_, p_drawButton_3_);
                int j = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    j = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    j = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    j = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            }
        }

        protected int func_146114_a(boolean mouseOver) {
            int i = 1;
            if (!this.field_146124_l) {
                i = 0;
            } else if (this.func_146115_a()) {
                i = 2;
            }
            return i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SpriteButton
    extends GuiButton {
        private static final int[] xPixel = new int[]{5, 5, 4, 4, 4, 4, 4, 29};
        private static final int[] yPixel = new int[]{2, 16, 30, 64, 79, 93, 107, 107};
        private static final int[] xSize = new int[]{17, 17, 18, 13, 21, 21, 15, 15};
        private static final int[] ySize = new int[]{11, 11, 11, 13, 11, 11, 15, 15};
        private final int whichIcon;

        public SpriteButton(int buttonId, int x, int y, int iconIndex) {
            super(buttonId, x, y, xSize[iconIndex], ySize[iconIndex], "");
            this.whichIcon = iconIndex;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float p_191745_4_) {
            if (this.field_146125_m) {
                boolean hover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_GUI_TEXTURES);
                int x = xPixel[this.whichIcon];
                int y = yPixel[this.whichIcon];
                int w = xSize[this.whichIcon];
                int h = ySize[this.whichIcon];
                if (hover) {
                    x += 25;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, x, y, w, h);
            }
        }
    }
}

