/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.internal.PacketSetBiome;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class WorldLocation {
    private World world;
    private BlockPos pos;

    public WorldLocation(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public AxisAlignedBB getAABB() {
        return new AxisAlignedBB(this.pos);
    }

    public TileEntity getTile() {
        return this.world.func_175667_e(this.pos) ? this.world.func_175625_s(this.pos) : null;
    }

    public <T extends TileEntity> T getTileOfType(Class<T> tile) {
        return (T)((TileEntity)WorldUtil.cast(this.getTile(), tile));
    }

    public <T> T getTileOfInterface(Class<T> tile) {
        if (!tile.isInterface()) {
            throw new UnsupportedOperationException(tile.getName() + " is not an interface!");
        }
        return WorldUtil.cast(this.getTile(), tile);
    }

    public boolean isLoaded() {
        return this.world.func_175667_e(this.pos);
    }

    public void setTile(TileEntity tile) {
        if (this.isLoaded()) {
            this.world.func_175690_a(this.pos, tile);
        }
    }

    public IBlockState getState() {
        return this.isLoaded() ? this.world.func_180495_p(this.pos) : Blocks.field_150350_a.func_176223_P();
    }

    public Block getBlock() {
        return this.getState().func_177230_c();
    }

    public int getMeta() {
        return this.getBlock().func_176201_c(this.getState());
    }

    public void setState(IBlockState state) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, state);
        }
    }

    public void setState(IBlockState state, int flags) {
        if (this.isLoaded()) {
            this.world.func_180501_a(this.pos, state, flags);
        }
    }

    public void setAir() {
        if (this.isLoaded()) {
            this.world.func_175698_g(this.pos);
        }
    }

    public boolean isAir() {
        if (this.isLoaded()) {
            return this.getBlock() == Blocks.field_150350_a;
        }
        return true;
    }

    public void destroyBlock(boolean dropBlock) {
        if (this.isLoaded()) {
            this.world.func_175655_b(this.pos, dropBlock);
        }
    }

    public boolean canSeeSky() {
        return this.canSeeSky(false);
    }

    public boolean canSeeSky(boolean __default) {
        if (this.isLoaded()) {
            return this.world.func_175678_i(this.pos);
        }
        return __default;
    }

    public int getLight() {
        if (this.isLoaded()) {
            return this.world.func_175699_k(this.pos);
        }
        return 0;
    }

    public int getLightFor(EnumSkyBlock type) {
        if (this.isLoaded()) {
            return this.world.func_175642_b(type, this.pos);
        }
        return 0;
    }

    public BlockPos getHeight() {
        return this.world.func_175645_m(this.pos);
    }

    public void setLight(EnumSkyBlock type, int lightValue) {
        this.world.func_175653_a(type, this.pos, lightValue);
    }

    public Biome getBiome() {
        return this.isLoaded() ? this.world.func_180494_b(this.pos) : Biomes.field_76772_c;
    }

    public void setBiome(Biome biome) {
        if (this.isLoaded()) {
            int i = this.pos.func_177958_n() & 0xF;
            int j = this.pos.func_177952_p() & 0xF;
            int id = j << 4 | i;
            Chunk c = this.world.func_175726_f(this.pos);
            byte[] blockBiomeArray = c.func_76605_m();
            blockBiomeArray[id] = (byte)(Biome.func_185362_a((Biome)biome) & 0xFF);
            c.func_76616_a(blockBiomeArray);
            if (!this.world.field_72995_K) {
                HCNet.INSTANCE.sendToAllAround(new PacketSetBiome(this.pos.func_177958_n(), this.pos.func_177952_p(), id, blockBiomeArray[id]), this.getPointWithRad(296));
            }
        }
    }

    public boolean resetBiome() {
        Biome[] bfg = this.world.func_72959_q().func_76937_a(null, this.pos.func_177958_n(), this.pos.func_177952_p(), 1, 1);
        if (bfg != null && bfg[0] != null && this.world.func_180494_b(this.pos) != bfg[0]) {
            this.setBiome(bfg[0]);
            return true;
        }
        return false;
    }

    public NetworkRegistry.TargetPoint getPointWithRad(int radius) {
        return new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, (double)radius);
    }

    public void setMeta(int meta) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, this.getBlock().func_176203_a(meta));
        }
    }

    public void setBlock(Block block) {
        if (this.isLoaded()) {
            this.world.func_175656_a(this.pos, block.func_176203_a(this.getMeta()));
        }
    }

    public WorldLocation offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public WorldLocation offset(EnumFacing facing, int steps) {
        return new WorldLocation(this.world, this.pos.func_177967_a(facing, steps));
    }

    public WorldLocation offset(int x, int y, int z) {
        return new WorldLocation(this.world, this.pos.func_177982_a(x, y, z));
    }

    protected void finalize() throws Throwable {
        this.world = null;
        this.pos = null;
        super.finalize();
    }

    public Material getMaterial() {
        return this.getBlock().func_149688_o(this.getState());
    }

    public SoundType getSoundType() {
        return this.getSoundType(null);
    }

    public SoundType getSoundType(Entity e) {
        return this.getBlock().getSoundType(this.getState(), this.getWorld(), this.getPos(), e);
    }

    public int getRedstone() {
        return this.isLoaded() ? this.world.func_175687_A(this.pos) : 0;
    }

    public void markDirty() {
        this.markDirty(3);
    }

    public Chunk getChunk() {
        return this.world.func_175726_f(this.pos);
    }

    public void markDirty(int flags) {
        if (this.world.field_72995_K) {
            return;
        }
        this.world.markAndNotifyBlock(this.pos, this.world.func_175726_f(this.pos), this.getState(), this.getState(), flags);
        TileSyncable sync = this.getTileOfType(TileSyncable.class);
        if (sync != null) {
            sync.sync();
        }
    }

    public void playSound(String sound, float volume, float pitch, SoundCategory cat) {
        HammerCore.audioProxy.playSoundAt(this.world, sound, this.pos, volume, pitch, cat);
    }

    @Nullable
    public EntityItem dropItem(ItemStack stack) {
        if (!this.world.field_72995_K) {
            EntityItem ei = new EntityItem(this.world, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, stack);
            this.world.func_72838_d((Entity)ei);
            return ei;
        }
        return null;
    }

    @Nullable
    public EntityItem dropItem(ItemStack stack, double xOffset, double yOffset, double zOffset, double velX, double velY, double velZ) {
        if (!this.world.field_72995_K) {
            EntityItem ei = new EntityItem(this.world, (double)this.pos.func_177958_n() + xOffset, (double)this.pos.func_177956_o() + yOffset, (double)this.pos.func_177952_p() + zOffset, stack);
            ei.field_70159_w = velX;
            ei.field_70181_x = velY;
            ei.field_70179_y = velZ;
            this.world.func_72838_d((Entity)ei);
            return ei;
        }
        return null;
    }
}

