/*
 * Decompiled with CFR 0.152.
 */
package elec332.huds.client.hud.armor;

import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import elec332.core.hud.AbstractHud;
import elec332.core.hud.drawing.ItemStackDrawer;
import elec332.core.hud.position.Alignment;
import elec332.core.hud.position.HorizontalStartingPoint;
import elec332.core.hud.position.IStartingPoint;
import elec332.core.hud.position.VerticalStartingPoint;
import elec332.core.util.ItemStackHelper;
import elec332.huds.client.hud.armor.DamageDisplayType;
import elec332.huds.client.hud.armor.IDamageDisplayType;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmorHud
extends AbstractHud {
    private IDamageDisplayType displayType;
    private static final String[] displayTypes = new String[DamageDisplayType.values().length];
    private static int lpValue = 0;
    ItemStack oxyTank = new ItemStack(GCItems.oxTankHeavy, 1, 0);
    private long lastWorldTime = 0L;
    EntityEquipmentSlot[] armorSlots = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public ArmorHud() {
        super(Alignment.LEFT, (IStartingPoint)HorizontalStartingPoint.LEFT, (IStartingPoint)VerticalStartingPoint.MIDDLE);
        this.displayType = DamageDisplayType.USES_LEFT;
    }

    public static void setLPValue(int lp, boolean showLP) {
        lpValue = lp;
    }

    protected void configure(@Nonnull Configuration config) {
        this.displayType = DamageDisplayType.valueOf(config.getString("displayType", this.getConfigCategory(), this.displayType.toString(), "This defines the way that the tool/armor damage will be displayed.", displayTypes));
    }

    public int getHudHeight() {
        return 117;
    }

    public void renderHud(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull Alignment alignment, int startX, int startY, float partialTicks) {
        NBTTagCompound nbt;
        int currentY = startY;
        for (EntityEquipmentSlot slot : this.armorSlots) {
            ItemStack stack = player.func_184582_a(slot);
            if (!ItemStackHelper.isStackValid((ItemStack)stack)) continue;
            String s = stack.func_77984_f() ? this.displayType.getDamageForDisplay(stack) : null;
            alignment.renderHudPart(ItemStackDrawer.INSTANCE, (Object)stack, s, startX, currentY, new Object[0]);
            currentY += 18;
        }
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack amuletSlot = baubles.getStackInSlot(0);
        if (!amuletSlot.func_190926_b() && amuletSlot.func_77973_b() == RegistrarBloodMagicItems.SIGIL_SEER && (nbt = amuletSlot.func_77978_p()) != null && nbt.func_74764_b("StoredLP")) {
            int storedLP = nbt.func_74762_e("StoredLP");
            alignment.renderHudPart(ItemStackDrawer.INSTANCE, (Object)amuletSlot, String.valueOf(storedLP), startX, currentY, new Object[0]);
            currentY += 18;
        }
        if (TickHandlerClient.airRemaining > 0 && TickHandlerClient.airRemaining < 20000) {
            alignment.renderHudPart(ItemStackDrawer.INSTANCE, (Object)this.oxyTank, String.valueOf(TickHandlerClient.airRemaining), startX, currentY, new Object[0]);
            currentY += 18;
        }
        if (TickHandlerClient.airRemaining2 > 0 && TickHandlerClient.airRemaining2 < 20000) {
            alignment.renderHudPart(ItemStackDrawer.INSTANCE, (Object)this.oxyTank, String.valueOf(TickHandlerClient.airRemaining2), startX, currentY, new Object[0]);
        }
    }

    static {
        for (int i = 0; i < displayTypes.length; ++i) {
            ArmorHud.displayTypes[i] = DamageDisplayType.values()[i].toString();
        }
    }
}

