/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.capability;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import li.cil.oc.common.tileentity.Assembler;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class HUDHandlerEnergy
implements IWailaDataProvider {
    static final IWailaDataProvider INSTANCE = new HUDHandlerEnergy();

    @Override
    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("capability.energyinfo") || accessor.getTileEntity() == null || accessor.getTileEntity() instanceof Assembler) {
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("forgeEnergy")) {
            long capacity;
            long stored;
            TileEntity tile;
            if (accessor.getTileEntity() instanceof TileEntityEnergyCube) {
                tile = MekanismUtils.getTileEntitySafe((IBlockAccess)accessor.getWorld(), (BlockPos)accessor.getPosition());
                TileEntityEnergyCube cube = (TileEntityEnergyCube)tile;
                stored = (long)(cube.getEnergy() / 2.5);
                capacity = (long)(cube.getMaxEnergy() / 2.5);
            } else if (accessor.getTileEntity() instanceof TileEntityReactorController) {
                tile = MekanismUtils.getTileEntitySafe((IBlockAccess)accessor.getWorld(), (BlockPos)accessor.getPosition());
                TileEntityReactorController reactor = (TileEntityReactorController)tile;
                stored = (long)(reactor.getReactor().getPassiveGeneration(false, true) / 2.5);
                capacity = (long)(reactor.getReactor().getPassiveGeneration(false, false) / 2.5);
            } else {
                stored = accessor.getNBTData().func_74775_l("forgeEnergy").func_74763_f("stored");
                capacity = accessor.getNBTData().func_74775_l("forgeEnergy").func_74763_f("capacity");
            }
            String storedString = new DecimalFormat(",###").format(stored);
            String maxString = new DecimalFormat(",###").format(capacity);
            ((ITaggedList)currenttip).add(storedString + " / " + maxString + " RF", "IEnergyStorage");
            return currenttip;
        }
        return currenttip;
    }

    @Override
    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            NBTTagCompound energyTag = new NBTTagCompound();
            energyTag.func_74768_a("capacity", energyStorage.getMaxEnergyStored());
            energyTag.func_74768_a("stored", energyStorage.getEnergyStored());
            tag.func_74782_a("forgeEnergy", (NBTBase)energyTag);
        }
        return tag;
    }
}

