/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.fluid;

import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IFCustomFluid
extends Fluid {
    public IFCustomFluid(String fluidName, int temperature) {
        super(fluidName, new ResourceLocation("industrialforegoing", "blocks/fluids/base_still"), new ResourceLocation("industrialforegoing", "blocks/fluids/base_flow"));
        this.setDensity(3000).setViscosity(6000).setTemperature(temperature);
    }

    public IFCustomFluid(String fluidName, int temperature, ResourceLocation still, ResourceLocation flow) {
        super(fluidName, still, flow);
        this.setDensity(3000).setViscosity(6000).setTemperature(temperature);
    }

    public IFCustomFluid(String fluidName, int temperature, Color color) {
        this(fluidName, temperature);
        this.setColor(color);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        if (this.fluidName.equalsIgnoreCase("rainbow")) {
            long time = System.currentTimeMillis() % 2000L;
            float hue = (float)time / 2000.0f;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            return rgb;
        }
        return this.color;
    }

    public void register() {
        FluidRegistry.registerFluid((Fluid)this);
        FluidRegistry.addBucketForFluid((Fluid)this);
    }
}

