package jeresources.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.*;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.event.ForgeEventFactory;

import javax.annotation.Nullable;
import java.io.File;
import java.io.IOException;

public class FakeClientWorld extends World {
    public static final WorldSettings worldSettings = new WorldSettings(0, GameType.SURVIVAL, true, false, WorldType.field_77137_b);
    public static final WorldInfo worldInfo = new WorldInfo(worldSettings, "just_enough_resources_fake");
    public static final FakeSaveHandler saveHandler = new FakeSaveHandler();
    public static final WorldProvider worldProvider = new WorldProvider() {
        @Override
        public DimensionType func_186058_p() {
            return DimensionType.OVERWORLD;
        }

        @Override
        public long getWorldTime() {
            return worldInfo.func_76073_f();
        }
    };

    private CapabilityDispatcher capabilities;

    public FakeClientWorld() {
        super(saveHandler, worldInfo, worldProvider, new Profiler(), true);
        this.capabilities = ForgeEventFactory.gatherCapabilities(this, null);
    }

    @Nullable
    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return capabilities == null ? null : capabilities.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capabilities != null && capabilities.hasCapability(capability, facing);
    }

    @Override
    protected IChunkProvider func_72970_h() {
        return new IChunkProvider() {
            @Nullable
            @Override
            public Chunk func_186026_b(int x, int z) {
                return null;
            }

            @Override
            public Chunk func_186025_d(int x, int z) {
                return null;
            }

            @Override
            public boolean func_73156_b() {
                return false;
            }

            @Override
            public String func_73148_d() {
                return null;
            }

            @Override
            public boolean func_191062_e(int p_191062_1_, int p_191062_2_) {
                return false;
            }
        };
    }

    @Override
    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return false;
    }

    private static class FakeSaveHandler implements ISaveHandler {

        @Override
        public WorldInfo func_75757_d() {
            return worldInfo;
        }

        @Override
        public void func_75762_c() throws MinecraftException {

        }

        @Override
        public IChunkLoader func_75763_a(WorldProvider provider) {
            return new IChunkLoader() {
                @Nullable
                @Override
                public Chunk func_75815_a(World worldIn, int x, int z) throws IOException {
                    return null;
                }

                @Override
                public void func_75816_a(World worldIn, Chunk chunkIn) throws MinecraftException, IOException {

                }

                @Override
                public void func_75819_b(World worldIn, Chunk chunkIn) throws IOException {

                }

                @Override
                public void func_75817_a() {

                }

                @Override
                public void func_75818_b() {

                }

                @Override
                public boolean func_191063_a(int p_191063_1_, int p_191063_2_) {
                    return false;
                }
            };
        }

        @Override
        public void func_75755_a(WorldInfo worldInformation, NBTTagCompound tagCompound) {

        }

        @Override
        public void func_75761_a(WorldInfo worldInformation) {

        }

        @Override
        public IPlayerFileData func_75756_e() {
            return new IPlayerFileData() {
                @Override
                public void func_75753_a(EntityPlayer player) {

                }

                @Override
                public NBTTagCompound func_75752_b(EntityPlayer player) {
                    return new NBTTagCompound();
                }

                @Override
                public String[] func_75754_f() {
                    return new String[0];
                }
            };
        }

        @Override
        public void func_75759_a() {

        }

        @Override
        public File func_75765_b() {
            return null;
        }

        @Override
        public File func_75758_b(String mapName) {
            return null;
        }

        @Override
        public TemplateManager func_186340_h() {
            return null;
        }
    }
}
