package jeresources.util;

import jeresources.api.render.ColourHelper;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

import java.nio.FloatBuffer;

public class RenderHelper {
    public static void drawArrow(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c(ColourHelper.getRed(color), ColourHelper.getGreen(color), ColourHelper.getBlue(color));
        GL11.glLineWidth(scale * 1.3F);
        GL11.glBegin(GL11.GL_LINES);
        GL11.glVertex2d(xBegin, yBegin);
        GL11.glVertex2d(xEnd, yEnd);
        GL11.glEnd();
        double angle = Math.atan2(yEnd - yBegin, xEnd - xBegin) * 180.0 / Math.PI;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b(xEnd, yEnd, 0.0);
        GlStateManager.func_179114_b((float) angle, 0.0F, 0.0F, 1.0F);
        GlStateManager.func_179139_a(scale, scale, 1.0);
        GL11.glBegin(GL11.GL_TRIANGLES);
        GL11.glVertex2d(3.0, 0.0);
        GL11.glVertex2d(0.0, -1.5);
        GL11.glVertex2d(0.0, 1.5);
        GL11.glEnd();
        GlStateManager.func_179121_F();
    }

    public static void drawLine(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c(ColourHelper.getRed(color), ColourHelper.getGreen(color), ColourHelper.getBlue(color));
        GL11.glLineWidth(scale * 1.3F);
        GL11.glBegin(GL11.GL_LINES);
        GL11.glVertex2d(xBegin, yBegin);
        GL11.glVertex2d(xEnd, yEnd);
        GL11.glEnd();
    }

    public static void drawPoint(double x, double y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179124_c(ColourHelper.getRed(color), ColourHelper.getGreen(color), ColourHelper.getBlue(color));
        GL11.glPointSize(scale * 1.3F);
        GL11.glBegin(GL11.GL_POINTS);
        GL11.glVertex2d(x, y);
        GL11.glEnd();
    }

    public static void renderEntity(int x, int y, float scale, float yaw, float pitch, EntityLivingBase entityLivingBase) {
        if (entityLivingBase.field_70170_p == null) entityLivingBase.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(x, y, 50.0F);
        GlStateManager.func_179152_a(-scale, scale, scale);
        GlStateManager.func_179114_b(180.0F, 0.0F, 0.0F, 1.0F);
        float renderYawOffset = entityLivingBase.field_70761_aq;
        float rotationYaw = entityLivingBase.field_70177_z;
        float rotationPitch = entityLivingBase.field_70125_A;
        float prevRotationYawHead = entityLivingBase.field_70758_at;
        float rotationYawHead = entityLivingBase.field_70759_as;
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(entityLivingBase, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        GlStateManager.func_179114_b(-((float) Math.atan((double) (pitch / 40.0F))) * 20.0F, 1.0F, 0.0F, 0.0F);
        entityLivingBase.field_70761_aq = (float) Math.atan((double) (yaw / 40.0F)) * 20.0F;
        entityLivingBase.field_70177_z = (float) Math.atan((double) (yaw / 40.0F)) * 40.0F;
        entityLivingBase.field_70125_A = -((float) Math.atan((double) (pitch / 40.0F))) * 20.0F;
        entityLivingBase.field_70759_as = entityLivingBase.field_70177_z;
        entityLivingBase.field_70758_at = entityLivingBase.field_70177_z;
        GlStateManager.func_179137_b(0.0F, entityLivingBase.func_70033_W(), 0.0F);
        getRenderManager().func_178631_a(180.0F);
        getRenderManager().func_188391_a(entityLivingBase, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F, false);
        entityLivingBase.field_70761_aq = renderYawOffset;
        entityLivingBase.field_70177_z = rotationYaw;
        entityLivingBase.field_70125_A = rotationPitch;
        entityLivingBase.field_70758_at = prevRotationYawHead;
        entityLivingBase.field_70759_as = rotationYawHead;
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g(OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g(OpenGlHelper.field_77478_a);
    }

    public static void renderChest(float x, float y, float rotate, float scale, float lidAngle) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.Vanilla.CHEST);
        ModelChest modelchest = new ModelChest();

        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        GlStateManager.func_179109_b(x, y, 50.0F);
        GlStateManager.func_179114_b(-160.0F, 1.0F, 0.0F, 0.0F);
        GlStateManager.func_179152_a(scale, -scale, -scale);
        GlStateManager.func_179109_b(0.5F, 0.5F, 0.5F);
        GlStateManager.func_179114_b(rotate, 0.0F, 1.0F, 0.0F);
        GlStateManager.func_179109_b(-0.5F, -0.5F, -0.5F);

        float lidAngleF = lidAngle / 180;
        lidAngleF = 1.0F - lidAngleF;
        lidAngleF = 1.0F - lidAngleF * lidAngleF * lidAngleF;
        modelchest.field_78234_a.field_78795_f = -(lidAngleF * (float) Math.PI / 2.0F);
        modelchest.field_78233_c.field_82906_o += 0.1F;
        modelchest.field_78233_c.field_82907_q += 0.12F;
        modelchest.field_78232_b.field_82906_o -= 0.755F;
        modelchest.field_78232_b.field_82908_p -= 0.4F;
        modelchest.field_78232_b.field_82907_q -= 0.9F;
        modelchest.func_78231_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    public static void renderBlock(IBlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b(-30.0F, 0.0F, 1.0F, 0.0F);
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(x, y, 50.0F + z);
        GlStateManager.func_179114_b(20.0F, 1.0F, 0.0F, 0.0F);
        scale *= 50;
        GlStateManager.func_179152_a(scale, -scale, -scale);
        GlStateManager.func_179109_b(0.5F, 0.5F, 0.5F);
        GlStateManager.func_179114_b(rotate, 0.0F, 1.0F, 0.0F);
        GlStateManager.func_179109_b(-0.5F, -0.5F, -0.5F);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_175602_ab().func_175016_a(block, 1.0F);
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public static void scissor(Minecraft mc, int x, int y, int w, int h) {
        int scale = new ScaledResolution(mc).func_78325_e();
        float[] xyzTranslation = getGLTranslation(scale);
        x *= scale;
        y *= scale;
        w *= scale;
        h *= scale;
        int scissorX = Math.round(xyzTranslation[0] + x);
        int scissorY = Math.round(mc.field_71440_d - y - h - xyzTranslation[1]);
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorInfo.x, scissorInfo.y, scissorInfo.width, scissorInfo.height);
    }

    public static void stopScissor() {
        GL11.glDisable(GL11.GL_SCISSOR_TEST);
    }

    public static void drawTexture(int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        GuiUtils.drawTexturedModalRect(x, y, u, v, width, height, 0);
    }

    private static RenderManager getRenderManager() {
        return Minecraft.func_71410_x().func_175598_ae();
    }

    public static float[] getGLTranslation(int scale) {
        FloatBuffer buf = BufferUtils.createFloatBuffer(16);
        GL11.glGetFloat(GL11.GL_MODELVIEW_MATRIX, buf);
        buf.rewind();
        Matrix4f mat = new Matrix4f();
        mat.load(buf);
        // { x, y, z }
        return new float[] { mat.m30 * scale, mat.m31 * scale, mat.m32 * scale };
    }
}
