/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.animation;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.init.ModBBAnimations;
import com.barribob.MaelstromMod.packets.MessageLoopAnimationUpdate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class AnimationManagerServer {
    private static final Map<EntityLivingBase, Map<String, Integer>> loopingAnimations = new HashMap<EntityLivingBase, Map<String, Integer>>();
    private static final int REFRESH_RATE = 20;

    public static void updateLooping(EntityLivingBase entity, String animationId, boolean remove) {
        if (remove && loopingAnimations.containsKey(entity) && loopingAnimations.get(entity).containsKey(animationId)) {
            loopingAnimations.get(entity).remove(animationId);
            return;
        }
        if (!loopingAnimations.containsKey(entity)) {
            loopingAnimations.put(entity, new HashMap());
        }
        if (!loopingAnimations.get(entity).containsKey(animationId)) {
            loopingAnimations.get(entity).put(animationId, entity.field_70173_aa);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList<EntityLivingBase> entitiesToRemove = new ArrayList<EntityLivingBase>();
            for (Map.Entry<EntityLivingBase, Map<String, Integer>> entry : loopingAnimations.entrySet()) {
                EntityLivingBase entity = entry.getKey();
                if (!entity.isAddedToWorld() && entity.field_70128_L) {
                    entitiesToRemove.add(entity);
                    continue;
                }
                for (Map.Entry<String, Integer> kv : entry.getValue().entrySet()) {
                    if (kv.getValue() % 20 == 0) {
                        Main.network.sendToAllTracking((IMessage)new MessageLoopAnimationUpdate(ModBBAnimations.getAnimationId(kv.getKey()), entity.func_145782_y()), (Entity)entity);
                    }
                    kv.setValue(kv.getValue() + 1);
                }
            }
            for (EntityLivingBase entity : entitiesToRemove) {
                loopingAnimations.remove(entity);
            }
        }
    }
}

